/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.AdministratorCannotBeRemovedException;
import be.WAAR.PresentationLayer.ArchitectureValueGetter;
import be.WAAR.PresentationLayer.FailedToCreatePresentationTypeException;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.InvalidNewPasswordException;
import be.WAAR.PresentationLayer.InvalidPasswordException;
import be.WAAR.PresentationLayer.MaximumInvalidPasswordsExceededException;
import be.WAAR.PresentationLayer.MaximumInvalidPasswordsForUserExceededException;
import be.WAAR.PresentationLayer.NotAPresentationAttributeTypeException;
import be.WAAR.PresentationLayer.NotAnArchitectureFieldException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PasswordUnconfirmedException;
import be.WAAR.PresentationLayer.PresentationArchitectureFieldMap;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.ResourceNotFoundException;
import be.WAAR.PresentationLayer.UDBInputStream;
import be.WAAR.PresentationLayer.UDBOutputStream;
import be.WAAR.PresentationLayer.UnknownUserIDException;
import be.WAAR.PresentationLayer.UserAlreadyExistsException;
import be.WAAR.PresentationLayer.UserIDDisabledException;
import be.WAAR.PresentationLayer.UserIDUnknownException;
import be.WAAR.PresentationLayer.UserProperties;
import be.WAAR.PresentationLayer.UserSession;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class Architecture {
    private static final String ARCHITECTURE_HTML = "architecture.html";
    private static final Locale architectureLocale = new Locale("EN");
    private static AttributeTypePool attributeTypePool;
    private static Architecture instance;
    private static PresentationArchitectureFieldMap presentationArchitectureFieldMap;
    private static HashMap<String, String> supportedLanguages;
    private static final String USERDATABASEFILENAME = "udb";
    private static HashMap<Long, UserSession> userSessions;
    private static HashMap<String, UserProperties> waarUsers;
    static String architectureHtml;
    static String waarHomeDirectory;
    private long userSessionIDLastAssigned;

    static {
        instance = new Architecture();
        presentationArchitectureFieldMap = PresentationArchitectureFieldMap.getInstance();
        userSessions = new HashMap();
    }

    private static void writeUDBFile() {
        block14: {
            File userDatabaseFile = new File(String.valueOf(waarHomeDirectory) + File.separatorChar + USERDATABASEFILENAME);
            try {
                DataOutputStream userDatabaseOutputStream = new DataOutputStream(new UDBOutputStream(userDatabaseFile));
                try {
                    try {
                        for (Map.Entry<String, UserProperties> me : waarUsers.entrySet()) {
                            userDatabaseOutputStream.writeBytes(String.valueOf(me.getKey()) + '=' + me.getValue().toString() + "\r\n");
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            userDatabaseOutputStream.close();
                        }
                        catch (IOException iOException2) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        userDatabaseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    userDatabaseOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void checkPassword(String userID, String userPassword, String newPassword, String confirmNewPassword) throws InvalidPasswordException, UnknownUserIDException, InvalidNewPasswordException, PasswordUnconfirmedException, MaximumInvalidPasswordsForUserExceededException, UserIDDisabledException {
        HashMap<String, UserProperties> hashMap = waarUsers;
        synchronized (hashMap) {
            if (!waarUsers.containsKey(userID)) throw new UnknownUserIDException(userID, Architecture.getDefaultLocale());
            UserProperties userProperties = waarUsers.get(userID);
            if (userProperties.isDisabled()) {
                throw new UserIDDisabledException(userID, Architecture.getDefaultLocale());
            }
            if (userProperties.getPassword().equals(userPassword)) {
                if (!userProperties.isPasswordToBeChangedAtNextLogon()) return;
                if (newPassword.length() < 8 || newPassword.equals(userPassword)) {
                    throw new InvalidNewPasswordException(Architecture.getDefaultLocale());
                }
                if (!newPassword.equals(confirmNewPassword)) throw new PasswordUnconfirmedException(Architecture.getDefaultLocale());
                waarUsers.put(userID, new UserProperties(String.valueOf(newPassword) + "#@#false#@#" + userProperties.getSuspiciousLogonAttemptTimes() + "#@#" + userProperties.getLanguage()));
                Architecture.writeUDBFile();
            } else {
                try {
                    try {
                        userProperties.registerSuspiciousLogonAttempt();
                        throw new InvalidPasswordException(Architecture.getDefaultLocale());
                    }
                    catch (MaximumInvalidPasswordsExceededException maximumInvalidPasswordsExceededException) {
                        throw new MaximumInvalidPasswordsForUserExceededException(userID, Architecture.getDefaultLocale());
                    }
                }
                catch (Throwable throwable) {
                    Architecture.writeUDBFile();
                    throw throwable;
                }
            }
            return;
        }
    }

    static String checkUserLanguage(String userLanguage) throws InvalidAttributeValueException {
        String userLanguage_uc = userLanguage.toUpperCase();
        if (supportedLanguages.containsKey(userLanguage_uc)) {
            return userLanguage_uc;
        }
        throw new InvalidAttributeValueException(userLanguage, "Is not a supported language", Architecture.getDefaultLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dropUserSession(long sessionID) {
        HashMap<Long, UserSession> hashMap = userSessions;
        synchronized (hashMap) {
            userSessions.remove(new Long(sessionID));
        }
    }

    static String getArchitectureFieldValue(String fieldName, OnLinePresentationFunction userFunction) throws NotAnArchitectureFieldException {
        if (presentationArchitectureFieldMap.containsKey(fieldName)) {
            ArchitectureValueGetter valueGetter = (ArchitectureValueGetter)presentationArchitectureFieldMap.get(fieldName);
            return valueGetter.getValue(userFunction);
        }
        throw new NotAnArchitectureFieldException(fieldName, userFunction.getUserLocale());
    }

    static PresentationType getAttributeType(String typeName, Class<? extends OnLinePresentationFunction> presentationFunctionClass, Locale locale) throws FailedToCreatePresentationTypeException {
        return attributeTypePool.get(typeName, presentationFunctionClass, locale);
    }

    public static AttributeTypePool getAttributeTypePool() {
        return attributeTypePool;
    }

    static GenericStringValue getDefaultLanguage() {
        return new GenericStringValue("EN");
    }

    static Architecture getInstance() {
        return instance;
    }

    static InputStream getResourceInputStream(String resourceName, Class<? extends OnLinePresentationFunction> presentationFunctionClass) throws ResourceNotFoundException {
        return instance.resourceInputStream(resourceName, presentationFunctionClass);
    }

    static BufferedReader getResourceReader(String resourceName, Class<? extends OnLinePresentationFunction> presentationFunctionClass) throws ResourceNotFoundException {
        return instance.resourceReader(resourceName, presentationFunctionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UserSession getUserSession(long sessionID) {
        HashMap<Long, UserSession> hashMap = userSessions;
        synchronized (hashMap) {
            return userSessions.get(new Long(sessionID));
        }
    }

    static Map<String, String> supportedLanguages() {
        return supportedLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLanguage(String userID, String newLanguage) throws UnknownUserIDException {
        HashMap<String, UserProperties> hashMap = waarUsers;
        synchronized (hashMap) {
            if (waarUsers.containsKey(userID)) {
                UserProperties userProperties = waarUsers.get(userID);
                if (supportedLanguages.containsKey(newLanguage)) {
                    waarUsers.put(userID, new UserProperties(String.valueOf(userProperties.getPassword()) + "#@#" + userProperties.isPasswordToBeChangedAtNextLogon() + "#@#" + userProperties.getSuspiciousLogonAttemptTimes() + "#@#" + newLanguage));
                    Architecture.writeUDBFile();
                }
            } else {
                throw new UnknownUserIDException(userID, Architecture.getDefaultLocale());
            }
        }
    }

    public static Locale getDefaultLocale() {
        return architectureLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserProperties getUserProperties(String userID, Locale locale) throws UserIDUnknownException {
        HashMap<String, UserProperties> hashMap = waarUsers;
        synchronized (hashMap) {
            if (waarUsers.containsKey(userID.toLowerCase())) {
                return waarUsers.get(userID.toLowerCase());
            }
        }
        throw new UserIDUnknownException(userID, locale);
    }

    public static HashMap<String, UserProperties> getWaarUsers() {
        return waarUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newWaarUser(String userID, String password, String userLanguage, Locale locale) throws UserAlreadyExistsException {
        String lowerCaseUserID = userID.toLowerCase();
        HashMap<String, UserProperties> hashMap = waarUsers;
        synchronized (hashMap) {
            if (waarUsers.containsKey(lowerCaseUserID)) {
                throw new UserAlreadyExistsException(userID, locale);
            }
            waarUsers.put(lowerCaseUserID, new UserProperties(String.valueOf(password) + "#@#true#@#[]#@#" + userLanguage));
            Architecture.writeUDBFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWaarUser(String userID, Locale locale) throws AdministratorCannotBeRemovedException, UserIDUnknownException {
        String lowerCaseUserID = userID.toLowerCase();
        HashMap<String, UserProperties> hashMap = waarUsers;
        synchronized (hashMap) {
            if (!waarUsers.containsKey(lowerCaseUserID)) {
                throw new UserIDUnknownException(userID, locale);
            }
            if (lowerCaseUserID.equals("waaradministrator")) {
                throw new AdministratorCannotBeRemovedException(locale);
            }
            waarUsers.remove(lowerCaseUserID);
            Architecture.writeUDBFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Architecture() {
        block34: {
            Serializable userDatabaseFile;
            boolean writeUDBFile;
            Properties p;
            block32: {
                waarHomeDirectory = String.valueOf(System.getProperty("user.home")) + (File.separatorChar == '\\' ? String.valueOf(File.separatorChar) + "Application Data" : "") + File.separatorChar + "WAAR";
                new File(waarHomeDirectory).mkdirs();
                attributeTypePool = AttributeTypePool.attributeTypePoolInstance;
                p = new Properties();
                writeUDBFile = false;
                try {
                    userDatabaseFile = new File(String.valueOf(waarHomeDirectory) + File.separatorChar + USERDATABASEFILENAME);
                    UDBInputStream userDatabaseFileInputStream = new UDBInputStream((File)userDatabaseFile);
                    try {
                        try {
                            p.load(userDatabaseFileInputStream);
                        }
                        catch (IOException iOException) {
                            try {
                                userDatabaseFileInputStream.close();
                            }
                            catch (IOException iOException2) {}
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            userDatabaseFileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        userDatabaseFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    p.setProperty("waaradministrator", "WaarAdministrator");
                    writeUDBFile = true;
                }
            }
            if (waarUsers == null) {
                waarUsers = new HashMap();
            }
            userDatabaseFile = waarUsers;
            synchronized (userDatabaseFile) {
                waarUsers.clear();
                for (Map.Entry<Object, Object> me : p.entrySet()) {
                    String userID = (String)me.getKey();
                    String userData_tx = (String)me.getValue();
                    UserProperties userProperties = new UserProperties(userData_tx);
                    waarUsers.put(userID, userProperties);
                }
                if (writeUDBFile) {
                    Architecture.writeUDBFile();
                }
            }
            StringBuffer htmlTemplateText = new StringBuffer(8192);
            try {
                BufferedReader in = this.resourceReader(ARCHITECTURE_HTML, Architecture.class);
                try {
                    try {
                        String w;
                        while ((w = in.readLine()) != null) {
                            htmlTemplateText.append(w);
                        }
                        architectureHtml = htmlTemplateText.toString();
                    }
                    catch (IOException e1) {
                        architectureHtml = "<HTML><BODY>Error while building architecture page template : " + e1.getMessage() + "</BODY></HTML>";
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                architectureHtml = "<HTML><BODY>Architecture HTML file architecture.htmlnot found.</BODY></HTML>";
            }
        }
        supportedLanguages = new HashMap();
        supportedLanguages.put("NL", "Nederlands");
        supportedLanguages.put("FR", "Fran\u00e7ais");
        supportedLanguages.put("DE", "Deutsch");
        supportedLanguages.put("EN", "English");
        supportedLanguages.put("ES", "Espa\u00f1ol");
        supportedLanguages.put("PT", "Portugues");
        supportedLanguages.put("IT", "Italiano");
        supportedLanguages.put("NO", "Norsk");
        supportedLanguages.put("DK", "Dansk");
        supportedLanguages.put("SE", "Svenska");
        supportedLanguages.put("FI", "Suomen");
    }

    private InputStream resourceInputStream(String resourceName, Class<?> resourceClass) throws ResourceNotFoundException {
        InputStream resourceInputStream = resourceClass.getResourceAsStream(resourceName);
        if (resourceInputStream == null && (resourceInputStream = resourceClass.getResourceAsStream("/" + resourceName)) == null) {
            throw new ResourceNotFoundException();
        }
        return resourceInputStream;
    }

    private BufferedReader resourceReader(String resourceName, Class<?> resourceClass) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(this.resourceInputStream(resourceName, resourceClass)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserSession newUserSession() {
        UserSession userSession;
        HashMap<Long, UserSession> hashMap = userSessions;
        synchronized (hashMap) {
            ++this.userSessionIDLastAssigned;
            userSession = new UserSession(this.userSessionIDLastAssigned);
            userSessions.put(new Long(this.userSessionIDLastAssigned), userSession);
        }
        return userSession;
    }

    public static class AttributeTypePool {
        static AttributeTypePool attributeTypePoolInstance = new AttributeTypePool();
        private HashMap<String, PresentationType> pool = new HashMap();

        private AttributeTypePool() {
        }

        private PresentationType loadPresentationTypeFromPackage(String typeName, Class<? extends OnLinePresentationFunction> presentationFunctionClass) throws NotAPresentationAttributeTypeException {
            Object object;
            try {
                object = presentationFunctionClass.getClassLoader().loadClass(typeName).newInstance();
            }
            catch (InstantiationException e) {
                throw new NotAPresentationAttributeTypeException(e);
            }
            catch (IllegalAccessException e) {
                throw new NotAPresentationAttributeTypeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new NotAPresentationAttributeTypeException(e);
            }
            if (object instanceof PresentationType) {
                return (PresentationType)object;
            }
            throw new NotAPresentationAttributeTypeException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PresentationType get(String typeName, Class<? extends OnLinePresentationFunction> presentationFunctionClass, Locale locale) throws FailedToCreatePresentationTypeException {
            HashMap<String, PresentationType> hashMap = this.pool;
            synchronized (hashMap) {
                PresentationType presentationType;
                if (this.pool.containsKey(typeName)) {
                    presentationType = this.pool.get(typeName);
                } else {
                    try {
                        presentationType = this.loadPresentationTypeFromPackage(typeName, presentationFunctionClass);
                    }
                    catch (NotAPresentationAttributeTypeException notAPresentationAttributeTypeException) {
                        try {
                            presentationType = this.loadPresentationTypeFromPackage(typeName, presentationFunctionClass);
                        }
                        catch (NotAPresentationAttributeTypeException e1) {
                            e1.printStackTrace(System.err);
                            throw new FailedToCreatePresentationTypeException(e1, typeName, locale);
                        }
                    }
                    this.pool.put(typeName, presentationType);
                }
                return presentationType;
            }
        }

        public HashMap<String, PresentationType> getPool() {
            return this.pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String typeName) {
            HashMap<String, PresentationType> hashMap = this.pool;
            synchronized (hashMap) {
                this.pool.remove(typeName);
            }
        }
    }
}

