/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.BatchPresentationProperties;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.PresentationFunction;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Logger;

public abstract class BatchPresentationFunction
extends PresentationFunction
implements Runnable {
    static int DEFAULTCOMMITCOUNT = 50;
    private int commitcount;

    public BatchPresentationFunction() {
        this.initialize(DEFAULTCOMMITCOUNT);
    }

    public BatchPresentationFunction(int commitcount) {
        this.initialize(commitcount);
    }

    private void initialize(int c) throws Error {
        this.commitcount = c;
        BatchPresentationProperties rtp = BatchPresentationProperties.getInstance();
        try {
            this.setUserData(new UserData(rtp.getRunTimeProperty("UserID"), rtp.getRunTimeProperty("UserDateFormat"), rtp.getRunTimeProperty("UserTimeFormat"), new GenericStringValue(rtp.getRunTimeProperty("UserLanguage"))));
            Driver d = (Driver)Class.forName(rtp.getRunTimeProperty("DB2DriverName")).newInstance();
            DriverManager.registerDriver(d);
            Connection connection = DriverManager.getConnection(rtp.getRunTimeProperty("DatabaseSystem"), rtp.getRunTimeProperty("UserID"), rtp.getRunTimeProperty("UserPassword"));
            connection.setAutoCommit(false);
            PreparedStatement setSQLID = connection.prepareStatement("SET CURRENT SQLID = '" + BatchPresentationProperties.getInstance().getRunTimeProperty("DBOWNER") + "'");
            setSQLID.execute();
        }
        catch (InstantiationException e) {
            e.printStackTrace(System.err);
            throw new Error();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.err);
            throw new Error();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.err);
            throw new Error();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new Error();
        }
        catch (WaarException e) {
            e.printStackTrace(System.err);
            throw new Error();
        }
    }

    public final void commit() {
    }

    public final int getCommitcount() {
        return this.commitcount;
    }

    public abstract void process() throws Exception;

    public final void rollback() {
    }

    @Override
    public final void run() {
        try {
            this.process();
        }
        catch (Throwable e) {
            Logger.getLogger(this.getClass().getName()).severe(String.valueOf(e.getClass().getName()) + (e.getMessage() == null ? "" : ":" + e.getMessage()));
            e.printStackTrace(System.err);
        }
    }
}

