/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.LogicalValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.Locale;

final class CheckBoxRenderer
extends Renderer {
    private static Renderer instance = new CheckBoxRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private CheckBoxRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        return "<INPUT type=\"checkbox\" name=\"" + presentationField.getName() + "\"" + (presentationField.isInputEnabled() ? "" : "disabled=\"true\"") + this.getHTMLTabIndexSpec(presentationField) + ">";
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        if (presentationFieldValue instanceof LogicalValue) {
            StringBuilder fieldHtml = new StringBuilder(80).append("<INPUT type=\"checkbox\" name=\"" + presentationField.getName() + "\"");
            LogicalValue logicalValue = (LogicalValue)presentationFieldValue;
            if (logicalValue.getValue()) {
                fieldHtml.append(" CHECKED ");
            }
            if (!presentationField.isInputEnabled()) {
                fieldHtml.append(" disabled=\"true\" ");
            }
            fieldHtml.append(this.getHTMLTabIndexSpec(presentationField)).append(">");
            return fieldHtml.toString();
        }
        throw new IllegalArgumentException(presentationFieldValue.getClass().getName());
    }
}

