/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.NumberedEnumerationType;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextsEnumerationType;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.Locale;
import java.util.Map;

final class ComboBoxRenderer
extends Renderer {
    private static Renderer instance = new ComboBoxRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private ComboBoxRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        if (presentationField.isInputEnabled()) {
            PresentationType presentationFieldType = presentationField.getType();
            if (presentationFieldType instanceof TextsEnumerationType) {
                Map<String, String> valuesAndLabels = ((TextsEnumerationType)presentationFieldType).getValuesAndLabels();
                String htmlFieldValue = "<SELECT NAME=\"" + presentationField.getName() + "\">";
                for (Map.Entry<String, String> me : valuesAndLabels.entrySet()) {
                    htmlFieldValue = String.valueOf(htmlFieldValue) + "<OPTION VALUE=\"" + me.getKey() + "\">" + me.getValue() + "</OPTION>";
                }
                htmlFieldValue = String.valueOf(htmlFieldValue) + "</SELECT>";
                return htmlFieldValue;
            }
            if (presentationFieldType instanceof NumberedEnumerationType) {
                String[] labels = ((NumberedEnumerationType)presentationFieldType).getLabels();
                String htmlFieldValue = "<SELECT NAME=\"" + presentationField.getName() + "\">";
                int i = 1;
                String[] stringArray = labels;
                int n = labels.length;
                int n2 = 0;
                while (n2 < n) {
                    String label = stringArray[n2];
                    htmlFieldValue = String.valueOf(htmlFieldValue) + "<OPTION VALUE=\"" + i++ + "\">" + label + "</OPTION>";
                    ++n2;
                }
                htmlFieldValue = String.valueOf(htmlFieldValue) + "</SELECT>";
                return htmlFieldValue;
            }
            throw new IllegalArgumentException(String.valueOf(presentationField.getName()) + " not of type Enumeration");
        }
        return "";
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        String stringValue = presentationFieldValue.toWAARString(userFunction.getUserData());
        PresentationType presentationFieldType = presentationField.getType();
        if (presentationField.isInputEnabled()) {
            if (presentationFieldType instanceof TextsEnumerationType) {
                Map<String, String> valuesAndLabels = ((TextsEnumerationType)presentationFieldType).getValuesAndLabels();
                String htmlFieldValue = "<SELECT" + this.getHTMLControlNameSpec(presentationField) + this.getHTMLTabIndexSpec(presentationField) + ">";
                for (Map.Entry<String, String> me : valuesAndLabels.entrySet()) {
                    String optionValue = me.getKey();
                    htmlFieldValue = String.valueOf(htmlFieldValue) + "<OPTION VALUE=\"" + optionValue + "\"" + (optionValue.equals(stringValue) ? " selected=\"selected\"" : "") + ">" + me.getValue() + "</OPTION>";
                }
                htmlFieldValue = String.valueOf(htmlFieldValue) + "</SELECT>";
                return htmlFieldValue;
            }
            if (presentationFieldType instanceof NumberedEnumerationType) {
                String[] labels = ((NumberedEnumerationType)presentationFieldType).getLabels();
                String htmlFieldValue = "<SELECT" + this.getHTMLControlNameSpec(presentationField) + ">";
                int i = 1;
                String[] stringArray = labels;
                int n = labels.length;
                int n2 = 0;
                while (n2 < n) {
                    String label = stringArray[n2];
                    htmlFieldValue = String.valueOf(htmlFieldValue) + "<OPTION VALUE=\"" + i++ + "\"" + (label.equals(stringValue) ? " selected=\"selected\"" : "") + ">" + label + "</OPTION>";
                    ++n2;
                }
                htmlFieldValue = String.valueOf(htmlFieldValue) + "</SELECT>";
                return htmlFieldValue;
            }
            throw new IllegalArgumentException(String.valueOf(presentationField.getName()) + " not of type Enumeration");
        }
        if (presentationFieldType instanceof TextsEnumerationType) {
            return ((TextsEnumerationType)presentationFieldType).getValuesAndLabels().get(stringValue);
        }
        if (presentationFieldType instanceof NumberedEnumerationType) {
            return stringValue;
        }
        throw new IllegalArgumentException(String.valueOf(presentationField.getName()) + " not of type Enumeration");
    }
}

