/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericDateValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.ISODateFormat;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class GenericDate
extends PresentationType {
    private static final long MILLISECONDSINDAY = 86400000L;

    public static GenericDateValue fromDate(Date date) {
        return new GenericDateValue(date);
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericDateValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }

    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        Date d;
        if (val.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat preferredDateFormat = userData == null ? ISODateFormat.getISODateFormatInstance() : userData.getPreferredDateFormat();
            d = preferredDateFormat.parse(val);
        }
        catch (ParseException e1) {
            throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), e1.getMessage(), locale);
        }
        return GenericDate.fromDate(d);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        UserData userData = userFunction.getUserData();
        SimpleDateFormat preferredDateFormat = userData == null ? ISODateFormat.getISODateFormatInstance() : userData.getPreferredDateFormat();
        String result = preferredDateFormat.format(((GenericDateValue)waarValue).getDate());
        return result;
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        return GenericDate.fromDate(new Date((long)v * 86400000L));
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        return new GenericDateValue(new Date(v - v % 86400000L));
    }
}

