/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericDate;
import be.WAAR.PresentationLayer.GenericDoubleValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Locale;

public class GenericDouble
extends PresentationType {
    public static GenericDoubleValue fromString(String val, Locale locale) throws InvalidAttributeValueException {
        try {
            return new GenericDoubleValue(Double.parseDouble(val));
        }
        catch (NumberFormatException e) {
            throw new InvalidAttributeValueException(val, GenericDate.class.getSimpleName(), e.getMessage(), locale);
        }
    }

    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        return GenericDouble.fromString(val, locale);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        return Double.toString(((GenericDoubleValue)waarValue).getDouble());
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        return new GenericDoubleValue(v);
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        return new GenericDoubleValue(v);
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericDoubleValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

