/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericIntegerValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Locale;

public class GenericInteger
extends PresentationType {
    public static final GenericIntegerValue fromString(String val, Locale locale) throws InvalidAttributeValueException {
        try {
            return new GenericIntegerValue(Integer.parseInt(val));
        }
        catch (NumberFormatException e) {
            throw new InvalidAttributeValueException(val, GenericInteger.class.getSimpleName(), e.getMessage(), locale);
        }
    }

    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        return GenericInteger.fromString(val, locale);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        return Integer.toString(((GenericIntegerValue)waarValue).getInteger());
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        return new GenericIntegerValue(v);
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) throws InvalidAttributeValueException {
        if (v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE) {
            return new GenericIntegerValue((int)v);
        }
        throw new InvalidAttributeValueException(Long.toString(v), this.getClass().getName(), "[-2147483648-2147483647]", locale);
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericIntegerValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

