/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextAreaRenderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Locale;

public class GenericString
extends PresentationType {
    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) {
        return new GenericStringValue(val);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        int p;
        String stringValue = ((GenericStringValue)waarValue).getString();
        StringBuffer stringBuffer = new StringBuffer(stringValue);
        while ((p = stringBuffer.indexOf("\"")) >= 0) {
            stringBuffer.deleteCharAt(p).insert(p, "&quot;");
        }
        while ((p = stringBuffer.indexOf("<")) >= 0) {
            stringBuffer.deleteCharAt(p).insert(p, "&lt;");
        }
        while ((p = stringBuffer.indexOf(">")) >= 0) {
            stringBuffer.deleteCharAt(p).insert(p, "&gt;");
        }
        return stringBuffer.toString();
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("TEXTAREA")) {
            return TextAreaRenderer.getInstance();
        }
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        return new GenericStringValue(Integer.toString(v));
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        return new GenericStringValue(Long.toString(v));
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        return new GenericStringValue(I18N.getString(locale, "Logical.True"));
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericStringValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

