/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericTimeValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.ISOTimeFormat;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class GenericTime
extends PresentationType {
    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        if (val.length() == 0) {
            return null;
        }
        try {
            return new GenericTimeValue((userData == null ? ISOTimeFormat.getISOTimeFormatInstance() : userData.getPreferredTimeFormat()).parse(val));
        }
        catch (ParseException e1) {
            throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), e1.getMessage(), locale);
        }
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        if (waarValue instanceof GenericTimeValue) {
            UserData userData = userFunction.getUserData();
            SimpleDateFormat userDateFormat = userData == null ? ISOTimeFormat.getISOTimeFormatInstance() : userData.getPreferredTimeFormat();
            return userDateFormat.format(((GenericTimeValue)waarValue).getDateTime());
        }
        throw new IllegalArgumentException(waarValue.getClass().getName());
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericTimeValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

