/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Version;
import java.util.HashMap;
import java.util.Map;

public class HTMLEntityRefs {
    static final HTMLEntityRefs V2_0 = new HTMLEntityRefs(new Version(2, 0), null, HTMLEntityRefs.getHTML20Map());
    static final HTMLEntityRefs V3_2 = new HTMLEntityRefs(new Version(3, 2), V2_0, HTMLEntityRefs.getHTML32Map());
    static final HTMLEntityRefs V4_0 = new HTMLEntityRefs(new Version(4, 0), V3_2, HTMLEntityRefs.getHTML40Map());
    static final HTMLEntityRefs XHTMLV1_0 = new HTMLEntityRefs(new Version(1, 0), V4_0, HTMLEntityRefs.getXHTML10Map());
    private HashMap<String, String> entityRefToUniCodeChar;
    private HTMLEntityRefs overAndAboveVersion;
    private HashMap<String, String> unicodeCharToEntityRef;
    private Version version;

    private static HashMap<String, String> getHTML20Map() {
        HashMap<String, String> html20Map = new HashMap<String, String>();
        html20Map.put("\"", "&quot;");
        html20Map.put("&", "&amp;");
        html20Map.put("<", "&lt;");
        html20Map.put(">", "&gt;");
        html20Map.put("\u00c0", "&Agrave;");
        html20Map.put("\u00c1", "&Aacute;");
        html20Map.put("\u00c2", "&Acirc;");
        html20Map.put("\u00c3", "&Atilde;");
        html20Map.put("\u00c4", "&Auml;");
        html20Map.put("\u00c5", "&Aring;");
        html20Map.put("\u00c6", "&AElig;");
        html20Map.put("\u00c7", "&Ccedil;");
        html20Map.put("\u00c8", "&Egrave;");
        html20Map.put("\u00c9", "&Eacute;");
        html20Map.put("\u00ca", "&Ecirc;");
        html20Map.put("\u00cb", "&Euml;");
        html20Map.put("\u00cc", "&Igrave;");
        html20Map.put("\u00cd", "&Iacute;");
        html20Map.put("\u00ce", "&Icirc;");
        html20Map.put("\u00cf", "&Iuml;");
        html20Map.put("\u00d0", "&ETH;");
        html20Map.put("\u00d1", "&Ntilde;");
        html20Map.put("\u00d2", "&Ograve;");
        html20Map.put("\u00d3", "&Oacute;");
        html20Map.put("\u00d4", "&Ocirc;");
        html20Map.put("\u00d5", "&Otilde;");
        html20Map.put("\u00d6", "&Ouml;");
        html20Map.put("\u00d8", "&Oslash;");
        html20Map.put("\u00d9", "&Ugrave;");
        html20Map.put("\u00da", "&Uacute;");
        html20Map.put("\u00db", "&Ucirc;");
        html20Map.put("\u00dc", "&Uuml;");
        html20Map.put("\u00dd", "&Yacute;");
        html20Map.put("\u00de", "&THORN;");
        html20Map.put("\u00df", "&szlig;");
        html20Map.put("\u00e0", "&agrave;");
        html20Map.put("\u00e1", "&aacute;");
        html20Map.put("\u00e2", "&acirc;");
        html20Map.put("\u00e3", "&atilde;");
        html20Map.put("\u00e4", "&auml;");
        html20Map.put("\u00e5", "&aring;");
        html20Map.put("\u00e6", "&aelig;");
        html20Map.put("\u00e7", "&ccedil;");
        html20Map.put("\u00e8", "&egrave;");
        html20Map.put("\u00e9", "&eacute;");
        html20Map.put("\u00ea", "&ecirc;");
        html20Map.put("\u00eb", "&euml;");
        html20Map.put("\u00ec", "&igrave;");
        html20Map.put("\u00ed", "&iacute;");
        html20Map.put("\u00ee", "&icirc;");
        html20Map.put("\u00ef", "&iuml;");
        html20Map.put("\u00f0", "&eth;");
        html20Map.put("\u00f1", "&ntilde;");
        html20Map.put("\u00f2", "&ograve;");
        html20Map.put("\u00f3", "&oacute;");
        html20Map.put("\u00f4", "&ocirc;");
        html20Map.put("\u00f5", "&otilde;");
        html20Map.put("\u00f6", "&ouml;");
        html20Map.put("\u00f8", "&oslash;");
        html20Map.put("\u00f9", "&ugrave;");
        html20Map.put("\u00fa", "&uacute;");
        html20Map.put("\u00fb", "&ucirc;");
        html20Map.put("\u00fc", "&uuml;");
        html20Map.put("\u00fd", "&yacute;");
        html20Map.put("\u00fe", "&thorn;");
        html20Map.put("\u00ff", "&yuml;");
        return html20Map;
    }

    private static HashMap<String, String> getHTML32Map() {
        HashMap<String, String> html32Map = new HashMap<String, String>();
        html32Map.put("\u00d7", "&Otimes;");
        html32Map.put("\u00f7", "&divide;");
        html32Map.put("\u00a0", "&nbsp;");
        html32Map.put("\u00a1", "&iexcl;");
        html32Map.put("\u00a2", "&cent;");
        html32Map.put("\u00a3", "&pound;");
        html32Map.put("\u00a4", "&curren;");
        html32Map.put("\u00a5", "&yen;");
        html32Map.put("\u00a6", "&brvbar;");
        html32Map.put("\u00a7", "&sect;");
        html32Map.put("\u00a8", "&uml;");
        html32Map.put("\u00a9", "&copy;");
        html32Map.put("\u00aa", "&ordf;");
        html32Map.put("\u00ab", "&laquo;");
        html32Map.put("\u00ac", "&not;");
        html32Map.put("\u00ad", "&shy;");
        html32Map.put("\u00ae", "&reg;");
        html32Map.put("\u00af", "&macr;");
        html32Map.put("\u00b0", "&deg;");
        html32Map.put("\u00b1", "&plusmn;");
        html32Map.put("\u00b2", "&sup2;");
        html32Map.put("\u00b3", "&sup3;");
        html32Map.put("\u00b4", "&acute;");
        html32Map.put("\u00b5", "&micro;");
        html32Map.put("\u00b6", "&para;");
        html32Map.put("\u00b7", "&middot;");
        html32Map.put("\u00b8", "&cedil;");
        html32Map.put("\u00b9", "&sup1;");
        html32Map.put("\u00ba", "&ordm;");
        html32Map.put("\u00bb", "&raquo;");
        html32Map.put("\u00bc", "&frac14;");
        html32Map.put("\u00bd", "&frac12;");
        html32Map.put("\u00be", "&frac34;");
        html32Map.put("\u00bf", "&iquest;");
        return html32Map;
    }

    private static HashMap<String, String> getHTML40Map() {
        HashMap<String, String> html40Map = new HashMap<String, String>();
        html40Map.put("\u0152", "&OElig;");
        html40Map.put("\u0153", "&oelig;");
        html40Map.put("\u0160", "&Scaron;");
        html40Map.put("\u0161", "&scaron;");
        html40Map.put("\u0178", "&Yuml;");
        html40Map.put("\u0192", "&fnof;");
        html40Map.put("\u02c6", "&circ;");
        html40Map.put("\u02dc", "&tilde;");
        html40Map.put("\u0391", "&Alpha;");
        html40Map.put("\u0392", "&Beta;");
        html40Map.put("\u0393", "&Gamma;");
        html40Map.put("\u0394", "&Delta;");
        html40Map.put("\u0395", "&Epsilon;");
        html40Map.put("\u0396", "&Zeta;");
        html40Map.put("\u0397", "&Eta;");
        html40Map.put("\u0398", "&Theta;");
        html40Map.put("\u0399", "&Iota;");
        html40Map.put("\u039a", "&Kappa;");
        html40Map.put("\u039b", "&Lambda;");
        html40Map.put("\u039c", "&Mu;");
        html40Map.put("\u039d", "&Nu;");
        html40Map.put("\u039e", "&Xi;");
        html40Map.put("\u039f", "&Omicron;");
        html40Map.put("\u03a0", "&Pi;");
        html40Map.put("\u03a1", "&Rho;");
        html40Map.put("\u03a3", "&Sigma;");
        html40Map.put("\u03a4", "&Tau;");
        html40Map.put("\u03a5", "&Upsilon;");
        html40Map.put("\u03a6", "&Phi;");
        html40Map.put("\u03a7", "&Chi;");
        html40Map.put("\u03a8", "&Psi;");
        html40Map.put("\u03a9", "&Omega;");
        html40Map.put("\u03b1", "&alpha;");
        html40Map.put("\u03b2", "&beta;");
        html40Map.put("\u03b3", "&gamma;");
        html40Map.put("\u03b4", "&delta;");
        html40Map.put("\u03b5", "&epsilon;");
        html40Map.put("\u03b6", "&zeta;");
        html40Map.put("\u03b7", "&eta;");
        html40Map.put("\u03b8", "&theta;");
        html40Map.put("\u03b9", "&iota;");
        html40Map.put("\u03ba", "&kappa;");
        html40Map.put("\u03bb", "&lambda;");
        html40Map.put("\u03bc", "&mu;");
        html40Map.put("\u03bd", "&nu;");
        html40Map.put("\u03be", "&xi;");
        html40Map.put("\u03bf", "&omicron;");
        html40Map.put("\u03c0", "&pi;");
        html40Map.put("\u03c1", "&rho;");
        html40Map.put("\u03c2", "&sigmaf;");
        html40Map.put("\u03c3", "&sigma;");
        html40Map.put("\u03c4", "&tau;");
        html40Map.put("\u03c5", "&upsilon;");
        html40Map.put("\u03c6", "&phi;");
        html40Map.put("\u03c7", "&chi;");
        html40Map.put("\u03c8", "&psi;");
        html40Map.put("\u03c9", "&omega;");
        html40Map.put("\u03d1", "&thetasym;");
        html40Map.put("\u03d2", "&upsih;");
        html40Map.put("\u03d6", "&piv;");
        html40Map.put("\u2002", "&ensp;");
        html40Map.put("\u2003", "&emsp;");
        html40Map.put("\u2009", "&thinsp;");
        html40Map.put("\u200c", "&zwnj;");
        html40Map.put("\u200d", "&zwj;");
        html40Map.put("\u200e", "&lrm;");
        html40Map.put("\u200f", "&rlm;");
        html40Map.put("\u2013", "&ndash;");
        html40Map.put("\u2014", "&mdash;");
        html40Map.put("\u2018", "&lsquo;");
        html40Map.put("\u2019", "&rsquo;");
        html40Map.put("\u201a", "&sbquo;");
        html40Map.put("\u201c", "&ldquo;");
        html40Map.put("\u201d", "&rdquo;");
        html40Map.put("\u201e", "&bdquo;");
        html40Map.put("\u2020", "&dagger;");
        html40Map.put("\u2021", "&Dagger;");
        html40Map.put("\u2022", "&bull;");
        html40Map.put("\u2026", "&hellip;");
        html40Map.put("\u2030", "&permil;");
        html40Map.put("\u2040", "&prime;");
        html40Map.put("\u2033", "&Prime;");
        html40Map.put("\u2039", "&lsaquo;");
        html40Map.put("\u203a", "&rsaquo;");
        html40Map.put("\u203e", "&oline;");
        html40Map.put("\u2044", "&frasl;");
        html40Map.put("\u20ac", "&euro;");
        html40Map.put("\u2111", "&image;");
        html40Map.put("\u2118", "&weierp;");
        html40Map.put("\u211c", "&real;");
        html40Map.put("\u2122", "&trade;");
        html40Map.put("\u2135", "&alefsym;");
        html40Map.put("\u2190", "&larr;");
        html40Map.put("\u2191", "&uarr;");
        html40Map.put("\u2192", "&rarr;");
        html40Map.put("\u2193", "&darr;");
        html40Map.put("\u2194", "&harr;");
        html40Map.put("\u21b5", "&crarr;");
        html40Map.put("\u21d0", "&lArr;");
        html40Map.put("\u21d1", "&uArr;");
        html40Map.put("\u21d2", "&rArr;");
        html40Map.put("\u21d3", "&dArr;");
        html40Map.put("\u21d4", "&hArr;");
        html40Map.put("\u2200", "&forall;");
        html40Map.put("\u2202", "&part;");
        html40Map.put("\u2203", "&exist;");
        html40Map.put("\u2205", "&empty;");
        html40Map.put("\u2207", "&nabla;");
        html40Map.put("\u2208", "&isin;");
        html40Map.put("\u2209", "&notin;");
        html40Map.put("\u220b", "&ni;");
        html40Map.put("\u220f", "&prod;");
        html40Map.put("\u2211", "&sum;");
        html40Map.put("\u2212", "&minus;");
        html40Map.put("\u2217", "&lowast;");
        html40Map.put("\u221a", "&radic;");
        html40Map.put("\u221d", "&prop;");
        html40Map.put("\u221e", "&infin;");
        html40Map.put("\u2220", "&ang;");
        html40Map.put("\u2227", "&and;");
        html40Map.put("\u2228", "&or;");
        html40Map.put("\u2229", "&cap;");
        html40Map.put("\u222a", "&cup;");
        html40Map.put("\u222b", "&int;");
        html40Map.put("\u2234", "&there4;");
        html40Map.put("\u223c", "&sim;");
        html40Map.put("\u2245", "&cong;");
        html40Map.put("\u2248", "&asymp;");
        html40Map.put("\u2260", "&ne;");
        html40Map.put("\u2261", "&equiv;");
        html40Map.put("\u2264", "&le;");
        html40Map.put("\u2265", "&ge;");
        html40Map.put("\u2282", "&sub;");
        html40Map.put("\u2283", "&sup;");
        html40Map.put("\u2284", "&nsub;");
        html40Map.put("\u2286", "&sube;");
        html40Map.put("\u2287", "&supe;");
        html40Map.put("\u2295", "&oplus;");
        html40Map.put("\u2297", "&otimes;");
        html40Map.put("\u22a5", "&perp;");
        html40Map.put("\u22c5", "&sdot;");
        html40Map.put("\u2308", "&lceil;");
        html40Map.put("\u2309", "&rceil;");
        html40Map.put("\u230a", "&lfloor;");
        html40Map.put("\u230b", "&rfloor;");
        html40Map.put("\u2329", "&lang;");
        html40Map.put("\u232a", "&rang;");
        html40Map.put("\u25ca", "&loz;");
        html40Map.put("\u2660", "&spades;");
        html40Map.put("\u2663", "&clubs;");
        html40Map.put("\u2665", "&hearts;");
        html40Map.put("\u2666", "&diams;");
        return html40Map;
    }

    private static HashMap<String, String> getXHTML10Map() {
        HashMap<String, String> xhtml10Map = new HashMap<String, String>();
        xhtml10Map.put("'", "&apos;");
        return xhtml10Map;
    }

    private static StringBuilder translateEntityRefs(HashMap<String, String> entityRefToUniCodeChar, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int p = 0;
        int sLength = stringBuilder.length();
        while (p < sLength) {
            if (stringBuilder.charAt(p) == '&') {
                int e = p + 1;
                StringBuilder entityRefName = new StringBuilder(16).append('&');
                while (e < sLength && stringBuilder.charAt(e) != ';') {
                    entityRefName.append(stringBuilder.charAt(e++));
                }
                entityRefName.append(';');
                if (entityRefToUniCodeChar.containsKey(entityRefName.toString())) {
                    stringBuilder.replace(p, p + entityRefName.length(), entityRefToUniCodeChar.get(entityRefName.toString()));
                    sLength = stringBuilder.length();
                }
            }
            ++p;
        }
        return stringBuilder;
    }

    private static String translateNumeralEntityRefs(StringBuilder stringBuilder) {
        int p = 0;
        int sLength = stringBuilder.length();
        while (p < sLength - 1) {
            if (stringBuilder.charAt(p) == '&' && stringBuilder.charAt(p + 1) == '#') {
                boolean hexmode;
                int e = p + 2;
                if (e < sLength && stringBuilder.charAt(e) == 'x') {
                    hexmode = true;
                    ++e;
                } else {
                    hexmode = false;
                }
                StringBuilder numeral = new StringBuilder(16);
                while (e < sLength && stringBuilder.charAt(e) != ';') {
                    numeral.append(stringBuilder.charAt(e++));
                }
                ++e;
                int number = hexmode ? Integer.parseInt(numeral.toString(), 16) : Integer.parseInt(numeral.toString());
                if (Character.isValidCodePoint(number)) {
                    stringBuilder.delete(p, e);
                    stringBuilder.insert(p, Character.valueOf((char)number));
                    sLength = stringBuilder.length();
                }
            }
            ++p;
        }
        return stringBuilder.toString();
    }

    public static String toXML(String string) {
        int length = string.length();
        StringBuffer w = new StringBuffer(length + length >>> 3);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i++);
            switch (c) {
                case '<': {
                    w.append("&lt;");
                    break;
                }
                case '>': {
                    w.append("&gt;");
                    break;
                }
                case '&': {
                    w.append("&amp;");
                    break;
                }
                case '\"': {
                    w.append("&quot;");
                    break;
                }
                case '\'': {
                    w.append("&apos;");
                    break;
                }
                default: {
                    w.append(c);
                }
            }
        }
        return w.toString();
    }

    private HTMLEntityRefs(Version version, HTMLEntityRefs overAndAboveVersion, HashMap<String, String> unicodeCharToEntityRef) {
        this.version = version;
        this.overAndAboveVersion = overAndAboveVersion;
        this.unicodeCharToEntityRef = unicodeCharToEntityRef;
        this.entityRefToUniCodeChar = new HashMap();
        for (Map.Entry<String, String> me : unicodeCharToEntityRef.entrySet()) {
            this.entityRefToUniCodeChar.put(me.getValue(), me.getKey());
        }
    }

    public String fromEntityRefsToUnicodeString(String string) {
        if (this.overAndAboveVersion != null) {
            return HTMLEntityRefs.translateEntityRefs(this.entityRefToUniCodeChar, this.overAndAboveVersion.fromEntityRefsToUnicodeString(string)).toString();
        }
        return HTMLEntityRefs.translateEntityRefs(this.entityRefToUniCodeChar, HTMLEntityRefs.translateNumeralEntityRefs(new StringBuilder(string))).toString();
    }

    public String toString() {
        return String.valueOf(this.version.toString()) + this.unicodeCharToEntityRef.toString();
    }
}

