/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.NotAnArchitectureFieldException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.Presentation;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.ResourceNotFoundException;
import be.WAAR.PresentationLayer.WaarValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class HTMLPresentationHandler {
    private static final String BODYHTML = ".bodyhtml";
    private static final String FORMHTML = ".formhtml";
    private String bodyOutputTemplate;
    private String formOutputTemplate;
    private OnLinePresentationFunction userFunction;

    HTMLPresentationHandler(OnLinePresentationFunction userFunction) {
        String w;
        StringBuilder templateText;
        BufferedReader in;
        Class<?> applicationClass;
        String formHTMLResourceName;
        block28: {
            this.userFunction = userFunction;
            String presentationName = userFunction.getPresentation().getName();
            String bodyHTMLResourceName = String.valueOf(presentationName) + BODYHTML;
            formHTMLResourceName = String.valueOf(presentationName) + FORMHTML;
            applicationClass = userFunction.getClass();
            try {
                in = Architecture.getResourceReader(bodyHTMLResourceName, applicationClass);
                templateText = new StringBuilder(8192);
                try {
                    try {
                        while ((w = in.readLine()) != null) {
                            templateText.append(w);
                        }
                        this.bodyOutputTemplate = templateText.toString();
                    }
                    catch (IOException e1) {
                        this.bodyOutputTemplate = "Error while building page template : " + e1.getMessage();
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace(System.err);
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace(System.err);
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace(System.err);
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                this.bodyOutputTemplate = "";
            }
        }
        try {
            in = Architecture.getResourceReader(formHTMLResourceName, applicationClass);
            templateText = new StringBuilder(8192);
            try {
                try {
                    while ((w = in.readLine()) != null) {
                        templateText.append(w);
                    }
                    this.formOutputTemplate = templateText.toString();
                }
                catch (IOException e1) {
                    this.formOutputTemplate = "Error while building form template : " + e1.getMessage();
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace(System.err);
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace(System.err);
                }
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.formOutputTemplate = "";
        }
    }

    String createOutputData(Locale locale) {
        int ac;
        int fc;
        String fieldValue;
        int pb;
        Presentation presentation = this.userFunction.getPresentation();
        HashMap<String, PresentationField> presentationFields = presentation.getPresentationFields();
        HashMap<String, WaarValue> presentationValues = presentation.getPresentationValues();
        StringBuilder formOutput = new StringBuilder(this.formOutputTemplate);
        StringBuilder bodyOutput = new StringBuilder(this.bodyOutputTemplate);
        Properties presentationLocaleLabels = presentation.getLabels(locale);
        for (String label : presentationLocaleLabels.stringPropertyNames()) {
            int i;
            String labelRef = "::" + label + "::";
            String labelValue = presentationLocaleLabels.getProperty(label);
            int labelRefLength = labelRef.length();
            while ((i = bodyOutput.indexOf(labelRef)) >= 0) {
                bodyOutput.replace(i, i + labelRefLength, labelValue);
            }
            while ((i = formOutput.indexOf(labelRef)) >= 0) {
                formOutput.replace(i, i + labelRefLength, labelValue);
            }
        }
        for (Map.Entry<String, PresentationField> me : presentationFields.entrySet()) {
            int i;
            String presentationFieldRenderedHtmlValue;
            String presentationFieldHtmlValue;
            String fieldName = me.getKey();
            PresentationField presentationField = me.getValue();
            WaarValue presentationFieldValue = presentationValues.get(fieldName);
            if (presentationFieldValue == null) {
                presentationFieldHtmlValue = presentationField.getType().getEmptyNakedStringRepresentation(presentationField, locale);
                presentationFieldRenderedHtmlValue = presentationField.getPresentationRenderer().getEmptyHTML(presentationField, locale);
            } else {
                presentationFieldHtmlValue = presentationField.getType().getNakedStringRepresentation(presentationFieldValue, this.userFunction, presentationField, locale);
                presentationFieldRenderedHtmlValue = presentationField.getPresentationRenderer().getHTML(presentationFieldValue, this.userFunction, presentationField, locale);
            }
            String htmlFieldRef = "[[" + fieldName + "]]";
            int htmlFieldRefLength = htmlFieldRef.length();
            while ((i = bodyOutput.indexOf(htmlFieldRef)) >= 0) {
                bodyOutput.replace(i, i + htmlFieldRefLength, presentationFieldHtmlValue);
            }
            while ((i = formOutput.indexOf(htmlFieldRef)) >= 0) {
                formOutput.replace(i, i + htmlFieldRefLength, presentationFieldHtmlValue);
            }
            htmlFieldRef = "{{" + fieldName + "}}";
            htmlFieldRefLength = htmlFieldRef.length();
            while ((i = bodyOutput.indexOf(htmlFieldRef)) >= 0) {
                bodyOutput.replace(i, i + htmlFieldRefLength, presentationFieldRenderedHtmlValue);
            }
            while ((i = formOutput.indexOf(htmlFieldRef)) >= 0) {
                formOutput.replace(i, i + htmlFieldRefLength, presentationFieldRenderedHtmlValue);
            }
        }
        do {
            if ((pb = bodyOutput.toString().indexOf("[[")) < 0) continue;
            String fieldName = bodyOutput.substring(pb + 2);
            int pe = fieldName.indexOf("]]");
            fieldName = fieldName.substring(0, pe);
            try {
                fieldValue = Architecture.getArchitectureFieldValue(fieldName, this.userFunction);
            }
            catch (NotAnArchitectureFieldException notAnArchitectureFieldException) {
                fieldValue = "##" + fieldName + "##";
            }
            bodyOutput.delete(pb, pb + pe + 4);
            bodyOutput.insert(pb, fieldValue);
        } while (pb >= 0);
        do {
            if ((pb = formOutput.toString().indexOf("[[")) < 0) continue;
            String fieldName = formOutput.substring(pb + 2);
            int pe = fieldName.indexOf("]]");
            fieldName = fieldName.substring(0, pe);
            try {
                fieldValue = Architecture.getArchitectureFieldValue(fieldName, this.userFunction);
            }
            catch (NotAnArchitectureFieldException notAnArchitectureFieldException) {
                fieldValue = "##" + fieldName + "##";
            }
            formOutput.delete(pb, pb + pe + 4);
            formOutput.insert(pb, fieldValue);
        } while (pb >= 0);
        LinkedList<String> presentationActions = presentation.getPresentationActions();
        Iterator i_presentationActions = presentationActions.iterator();
        String actionsHtml = "";
        int tabIndex = 30021;
        while (i_presentationActions.hasNext()) {
            String actionHtml = (String)i_presentationActions.next();
            actionsHtml = String.valueOf(actionsHtml) + "<INPUT type=\"submit\" name=\"Action\" value=\"" + actionHtml + "\" tabindex=\"" + tabIndex++ + "\">";
        }
        StringBuilder hout = new StringBuilder(Architecture.architectureHtml);
        int bc = hout.toString().indexOf("[[BODYHTML]]");
        if (bc >= 0) {
            hout.replace(bc, bc + 12, bodyOutput.toString());
        }
        if ((fc = hout.toString().indexOf("[[FORMHTML]]")) >= 0) {
            hout.replace(fc, fc + 12, formOutput.toString());
        }
        if ((ac = hout.toString().indexOf("[[ACTIONSHTML]]")) >= 0) {
            hout.replace(ac, ac + 15, actionsHtml);
        }
        do {
            if ((pb = hout.toString().indexOf("[[")) < 0) continue;
            String fieldName = hout.substring(pb + 2);
            int pe = fieldName.indexOf("]]");
            fieldName = fieldName.substring(0, pe);
            try {
                fieldValue = Architecture.getArchitectureFieldValue(fieldName, this.userFunction);
            }
            catch (NotAnArchitectureFieldException notAnArchitectureFieldException) {
                fieldValue = "##" + fieldName + "##";
            }
            hout.delete(pb, pb + pe + 4);
            hout.insert(pb, fieldValue);
        } while (pb >= 0);
        return hout.toString();
    }
}

