/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationFunctionStack;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.UserSession;
import be.WAAR.PresentationLayer.WaarException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HTTPArchitectureServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -7925812282659471814L;
    private Architecture architecture;

    private OnLinePresentationFunction processAction(HttpServletRequest req, HttpServletResponse resp, UserSession userSession, String action) throws ServletException {
        PresentationFunctionStack functionStack = userSession.getFunctionStack();
        OnLinePresentationFunction userFunction = (OnLinePresentationFunction)functionStack.getLast();
        try {
            if (action.equalsIgnoreCase("OK")) {
                userFunction.fillInPresentationValuesIgnoringDefaults(req);
                userFunction.setPresentationMessage("");
                userFunction.doPresentationLogic();
                userFunction.endPresentationLogic();
                if (userFunction.leaveFunctionOnExit()) {
                    userFunction = this.processReturn(req, resp, userSession, functionStack);
                }
            } else if (action.equalsIgnoreCase("Cancel")) {
                userFunction.doCancel();
                userFunction = this.processReturn(req, resp, userSession, functionStack);
            } else if (action.equalsIgnoreCase("Help")) {
                userFunction.setPresentation(String.valueOf(userFunction.getPresentation().getName()) + "Help");
            } else if (action.equalsIgnoreCase("Main")) {
                while (functionStack.size() > 0) {
                    userFunction.doCancel();
                    userFunction = (OnLinePresentationFunction)functionStack.removeLast();
                }
                if (userFunction.isSuspended()) {
                    userFunction.unSuspend();
                }
                functionStack.addLast(userFunction);
            } else if (action.equalsIgnoreCase("Logoff")) {
                do {
                    userFunction.doCancel();
                } while ((userFunction = functionStack.size() > 0 ? (OnLinePresentationFunction)functionStack.removeLast() : null) != null);
            } else {
                userFunction.doActionLogic(action);
            }
        }
        catch (WaarException e1) {
            this.log(e1.getMessage(), e1);
            userFunction.setPresentationMessage(e1);
        }
        return userFunction;
    }

    private OnLinePresentationFunction processInitOrResume(HttpServletRequest req, String applicationName, String functionName, UserSession userSession, UserData userData) throws ServletException {
        String functionStartupMode;
        OnLinePresentationFunction newUserFunction;
        PresentationFunctionStack functionStack = userSession.getFunctionStack();
        OnLinePresentationFunction userFunction = null;
        String returnPath = "";
        String returnParms = "";
        if (functionStack.size() > 0) {
            userFunction = (OnLinePresentationFunction)functionStack.getLast();
            if (userFunction.isSuspended()) {
                userFunction.unSuspend();
                return userFunction;
            }
            returnPath = userFunction.getServletPath();
            returnParms = userFunction.getQueryString();
        }
        String prefix = ((Object)((Object)this)).getClass().getPackage().getName();
        String userFunctionName = String.valueOf(prefix) + "." + functionName;
        try {
            newUserFunction = (OnLinePresentationFunction)((Object)((Object)this)).getClass().getClassLoader().loadClass(userFunctionName).newInstance();
        }
        catch (InstantiationException e) {
            this.log(e.getMessage(), e);
            req.getSession().invalidate();
            Architecture.dropUserSession(userSession.getSessionID());
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log(e.getMessage(), e);
            req.getSession().invalidate();
            Architecture.dropUserSession(userSession.getSessionID());
            throw new ServletException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.log(e.getMessage(), e);
            req.getSession().invalidate();
            Architecture.dropUserSession(userSession.getSessionID());
            throw new ServletException((Throwable)e);
        }
        newUserFunction.initialize(applicationName, req.getQueryString(), userData, returnPath, returnParms, functionName, req, this);
        if (userFunction != null) {
            userFunction.suspend();
        }
        if ((functionStartupMode = req.getParameter("FUNCTIONSTARTUPMODE")) != null && functionStartupMode.equalsIgnoreCase("XFER") && functionStack.size() > 0) {
            functionStack.removeLast();
        }
        functionStack.addLast(newUserFunction);
        return newUserFunction;
    }

    private OnLinePresentationFunction processReturn(HttpServletRequest req, HttpServletResponse resp, UserSession userSession, PresentationFunctionStack functionStack) throws ServletException {
        OnLinePresentationFunction returnToUserFunction;
        OnLinePresentationFunction abandonedUserFunction = (OnLinePresentationFunction)functionStack.removeLast();
        if (functionStack.size() == 0) {
            returnToUserFunction = null;
        } else {
            returnToUserFunction = (OnLinePresentationFunction)functionStack.getLast();
            returnToUserFunction.saveInFunctionContext("__WRETURNFROM", abandonedUserFunction.getClass().getSimpleName());
            String backto = abandonedUserFunction.getReturnPath();
            String backparms = abandonedUserFunction.getReturnParms();
            if (backparms.indexOf("USERSESSIONID=") < 0) {
                backparms = backparms.length() > 0 ? String.valueOf(backparms) + "&USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken() : "USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken();
            }
            String erdurl = resp.encodeRedirectURL("/" + backto + "?" + backparms);
            try {
                resp.sendRedirect(erdurl);
            }
            catch (IOException e2) {
                this.log(e2.getMessage(), e2);
                req.getSession().invalidate();
                Architecture.dropUserSession(userSession.getSessionID());
                throw new ServletException(e2.getMessage());
            }
        }
        return returnToUserFunction;
    }

    public final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.process(req, resp);
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.process(req, resp);
    }

    public final String getServletInfo() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + " - " + ((Object)((Object)this)).toString();
    }

    public final void init() throws ServletException {
        super.init();
        this.architecture = Architecture.getInstance();
    }

    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        UserSession userSession;
        resp.setContentType("text/html;charset=UTF-8");
        resp.setCharacterEncoding("UTF-8");
        if (req.getCharacterEncoding() == null) {
            try {
                req.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace(System.err);
            }
        }
        String applicationName = req.getContextPath().substring(1);
        String functionName = req.getServletPath().substring(1);
        if (functionName.endsWith(".wfn")) {
            functionName = functionName.substring(0, functionName.length() - 4);
        }
        String userSessionIDText = req.getParameter("USERSESSIONID");
        String sessionToken = req.getParameter("USERSESSIONTOKEN");
        if (userSessionIDText == null) {
            userSession = this.architecture.newUserSession();
        } else {
            long userSessionID = Long.parseLong(userSessionIDText);
            userSession = Architecture.getUserSession(userSessionID);
            if (userSession == null) {
                this.log("User Session no longer active : " + req.getRequestURL());
                req.getSession().invalidate();
                throw new ServletException("User Session no longer active.");
            }
            if (Long.parseLong(sessionToken) != userSession.getSessionVerificationToken()) {
                this.log("Session token verification failed : " + req.getRequestURL());
                req.getSession().invalidate();
                Architecture.dropUserSession(userSession.getSessionID());
                throw new ServletException("Session token verification failed.");
            }
        }
        try {
            UserData userData = userSession.getUserdata();
            if (userData == null) {
                String erdurl = resp.encodeRedirectURL("/" + applicationName + "/Logon?USERSESSIONID=" + userSession.getSessionID() + "&return=" + req.getRequestURL());
                resp.sendRedirect(erdurl);
            } else {
                OnLinePresentationFunction userFunction = null;
                String action = req.getParameter("Action");
                userFunction = action == null ? this.processInitOrResume(req, applicationName, functionName, userSession, userData) : this.processAction(req, resp, userSession, action);
                if (userFunction != null) {
                    resp.getWriter().write(userFunction.getHTMLOutput());
                } else {
                    Architecture.dropUserSession(userSession.getSessionID());
                    String erdurl = resp.encodeRedirectURL("/" + applicationName);
                    resp.sendRedirect(erdurl);
                }
            }
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
            req.getSession().invalidate();
            Architecture.dropUserSession(userSession.getSessionID());
            throw new ServletException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.log(e.getMessage(), e);
            req.getSession().invalidate();
            Architecture.dropUserSession(userSession.getSessionID());
            throw new ServletException((Throwable)e);
        }
    }
}

