/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.ListValue;
import be.WAAR.PresentationLayer.NoColumnsInNonListFieldsException;
import be.WAAR.PresentationLayer.NotAnArchitectureFieldException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

final class ListRenderer
extends Renderer {
    private static Renderer instance = new ListRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private ListRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        return "";
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        ListValue listValue = (ListValue)presentationFieldValue;
        StringBuilder htmlFieldValue = new StringBuilder(30 * presentationField.getColumnCount() * listValue.getRowList().size());
        Iterator i_listValueRows = listValue.getRowList().iterator();
        String fldHtml = "";
        while (i_listValueRows.hasNext()) {
            HashMap<String, PresentationField> presentationFields;
            HashMap<String, WaarValue> presentationValues;
            PresentationField listPresentationFieldColumn;
            String rowFieldName;
            int replaceEndPos;
            int replaceBeginPos;
            HashMap rowValueMap = (HashMap)i_listValueRows.next();
            StringBuffer rowHtml = new StringBuffer(presentationField.getRowTemplateText().toString());
            do {
                if ((replaceBeginPos = rowHtml.toString().indexOf("[[")) < 0 || (replaceEndPos = (rowFieldName = rowHtml.substring(replaceBeginPos + 2)).indexOf("]]")) < 0) continue;
                rowFieldName = rowFieldName.substring(0, replaceEndPos);
                try {
                    fldHtml = Architecture.getArchitectureFieldValue(rowFieldName, userFunction);
                }
                catch (NotAnArchitectureFieldException notAnArchitectureFieldException) {
                    try {
                        listPresentationFieldColumn = presentationField.getColumn(rowFieldName, locale);
                        if (listPresentationFieldColumn != null) {
                            PresentationType listPresentationFieldColumnType = listPresentationFieldColumn.getType();
                            if (rowValueMap.keySet().contains(rowFieldName)) {
                                WaarValue colValue = (WaarValue)rowValueMap.get(rowFieldName);
                                fldHtml = listPresentationFieldColumnType.getNakedStringRepresentation(colValue, userFunction, listPresentationFieldColumn, locale);
                            } else {
                                fldHtml = listPresentationFieldColumnType.getEmptyNakedStringRepresentation(listPresentationFieldColumn, locale);
                            }
                        } else {
                            presentationValues = userFunction.getPresentation().getPresentationValues();
                            presentationFields = userFunction.getPresentation().getPresentationFields();
                            if (presentationFields.containsKey(rowFieldName)) {
                                listPresentationFieldColumn = presentationFields.get(rowFieldName);
                                PresentationType listPresentationFieldColumnType = listPresentationFieldColumn.getType();
                                if (presentationValues.keySet().contains(rowFieldName)) {
                                    WaarValue colValue = presentationValues.get(rowFieldName);
                                    fldHtml = listPresentationFieldColumnType.getNakedStringRepresentation(colValue, userFunction, listPresentationFieldColumn, locale);
                                } else {
                                    fldHtml = listPresentationFieldColumnType.getEmptyNakedStringRepresentation(listPresentationFieldColumn, locale);
                                }
                            } else {
                                fldHtml = "##" + rowFieldName + "##";
                            }
                        }
                    }
                    catch (NoColumnsInNonListFieldsException noColumnsInNonListFieldsException) {}
                }
                rowHtml.delete(replaceBeginPos, replaceBeginPos + replaceEndPos + 4);
                rowHtml.insert(replaceBeginPos, fldHtml);
            } while (replaceBeginPos >= 0);
            do {
                if ((replaceBeginPos = rowHtml.toString().indexOf("{{")) < 0 || (replaceEndPos = (rowFieldName = rowHtml.substring(replaceBeginPos + 2)).indexOf("}}")) < 0) continue;
                rowFieldName = rowFieldName.substring(0, replaceEndPos);
                try {
                    fldHtml = Architecture.getArchitectureFieldValue(rowFieldName, userFunction);
                }
                catch (NotAnArchitectureFieldException notAnArchitectureFieldException) {
                    try {
                        listPresentationFieldColumn = presentationField.getColumn(rowFieldName, locale);
                        if (listPresentationFieldColumn != null) {
                            if (rowValueMap.keySet().contains(rowFieldName)) {
                                WaarValue colValue = (WaarValue)rowValueMap.get(rowFieldName);
                                fldHtml = listPresentationFieldColumn.getPresentationRenderer().getHTML(colValue, userFunction, listPresentationFieldColumn, locale);
                            } else {
                                fldHtml = listPresentationFieldColumn.getPresentationRenderer().getEmptyHTML(listPresentationFieldColumn, locale);
                            }
                        } else {
                            presentationValues = userFunction.getPresentation().getPresentationValues();
                            presentationFields = userFunction.getPresentation().getPresentationFields();
                            if (presentationFields.containsKey(rowFieldName)) {
                                listPresentationFieldColumn = presentationFields.get(rowFieldName);
                                if (presentationValues.keySet().contains(rowFieldName)) {
                                    WaarValue colValue = presentationValues.get(rowFieldName);
                                    fldHtml = listPresentationFieldColumn.getPresentationRenderer().getHTML(colValue, userFunction, listPresentationFieldColumn, locale);
                                } else {
                                    fldHtml = listPresentationFieldColumn.getPresentationRenderer().getEmptyHTML(listPresentationFieldColumn, locale);
                                }
                            } else {
                                fldHtml = "##" + rowFieldName + "##";
                            }
                        }
                    }
                    catch (NoColumnsInNonListFieldsException noColumnsInNonListFieldsException) {}
                }
                rowHtml.delete(replaceBeginPos, replaceBeginPos + replaceEndPos + 4);
                rowHtml.insert(replaceBeginPos, fldHtml);
            } while (replaceBeginPos >= 0);
            htmlFieldValue.append(rowHtml);
        }
        return htmlFieldValue.toString();
    }
}

