/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.CheckBoxRenderer;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.LogicalValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Locale;

public class Logical
extends PresentationType {
    @Override
    public WaarValue encode(String stringValue, UserData userData, Locale locale) throws InvalidAttributeValueException {
        String localOnValue = I18N.getString(locale, "Logical.On");
        String localYValue = I18N.getString(locale, "Logical.Y");
        String localYesValue = I18N.getString(locale, "Logical.Yes");
        String localTrueValue = I18N.getString(locale, "Logical.True");
        String localOffValue = I18N.getString(locale, "Logical.Off");
        String localNValue = I18N.getString(locale, "Logical.N");
        String localNoValue = I18N.getString(locale, "Logical.No");
        String localFalseValue = I18N.getString(locale, "Logical.False");
        if (stringValue.equalsIgnoreCase(localYesValue) || stringValue.equalsIgnoreCase(localYValue) || stringValue.equalsIgnoreCase(localTrueValue) || stringValue.equalsIgnoreCase(localOnValue)) {
            return new LogicalValue(true);
        }
        if (stringValue.equalsIgnoreCase(localNoValue) || stringValue.equalsIgnoreCase(localNValue) || stringValue.equalsIgnoreCase(localFalseValue) || stringValue.equalsIgnoreCase(localOffValue)) {
            return new LogicalValue(false);
        }
        Locale architectureLocale = Architecture.getDefaultLocale();
        localOnValue = I18N.getString(architectureLocale, "Logical.On");
        localYValue = I18N.getString(architectureLocale, "Logical.Y");
        localYesValue = I18N.getString(architectureLocale, "Logical.Yes");
        localTrueValue = I18N.getString(architectureLocale, "Logical.True");
        localOffValue = I18N.getString(architectureLocale, "Logical.Off");
        localNValue = I18N.getString(architectureLocale, "Logical.N");
        localNoValue = I18N.getString(architectureLocale, "Logical.No");
        localFalseValue = I18N.getString(architectureLocale, "Logical.False");
        if (stringValue.equalsIgnoreCase(localYesValue) || stringValue.equalsIgnoreCase(localYValue) || stringValue.equalsIgnoreCase(localTrueValue) || stringValue.equalsIgnoreCase(localOnValue)) {
            return new LogicalValue(true);
        }
        if (stringValue.equalsIgnoreCase(localNoValue) || stringValue.equalsIgnoreCase(localNValue) || stringValue.equalsIgnoreCase(localFalseValue) || stringValue.equalsIgnoreCase(localOffValue)) {
            return new LogicalValue(false);
        }
        throw new InvalidAttributeValueException(stringValue, this.getClass().getSimpleName(), String.valueOf(localTrueValue) + '/' + localFalseValue + '/' + localYesValue + '/' + localNoValue + '/', locale);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return CheckBoxRenderer.getInstance();
    }

    @Override
    public String getEmptyNakedStringRepresentation(PresentationField presentationField, Locale locale) {
        return "";
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        return Boolean.toString(((LogicalValue)waarValue).getValue());
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        if (renderingStyleName.equals("TEXTBOX")) {
            return TextBoxRenderer.getInstance();
        }
        return CheckBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        return new LogicalValue(b);
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof LogicalValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

