/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.IdentifyUser;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationFunctionStack;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.UserSession;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogonServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 4763962818840118976L;

    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block15: {
            UserSession userSession = Architecture.getUserSession(Long.parseLong(req.getParameter("USERSESSIONID")));
            PresentationFunctionStack functionStack = userSession.getFunctionStack();
            String action = req.getParameter("Action");
            if (action == null) {
                IdentifyUser userFunction = new IdentifyUser();
                userFunction.initialize(req.getContextPath().substring(1), "", null, req.getParameter("return"), "", "IdentifyUser", req, this);
                userFunction.setPresentationMessage(I18N.getString(Architecture.getDefaultLocale(), "LogonServlet.Text"));
                functionStack.addLast(userFunction);
                try {
                    resp.getWriter().write(userFunction.getHTMLOutput());
                }
                catch (IOException e1) {
                    throw new ServletException(e1.getMessage());
                }
            }
            OnLinePresentationFunction userFunction = (OnLinePresentationFunction)functionStack.getLast();
            try {
                if (action.equalsIgnoreCase("OK")) {
                    userFunction.fillInPresentationValuesIgnoringDefaults(req);
                    userFunction.doPresentationLogic();
                    userFunction.endPresentationLogic();
                    HashMap<String, WaarValue> presentationValues = userFunction.getPresentation().getPresentationValues();
                    WaarValue userDateFormat_v = presentationValues.get("DATEFORMAT");
                    String userDateFormat = userDateFormat_v == null ? "yyyy'-'MM'-'dd" : ((GenericStringValue)userDateFormat_v).getString();
                    WaarValue userTimeFormat_v = presentationValues.get("TIMEFORMAT");
                    String userTimeFormat = userTimeFormat_v == null ? "HH':'mm':'ss" : ((GenericStringValue)userTimeFormat_v).getString();
                    String userID = "";
                    UserData userData = new UserData(userID, userDateFormat, userTimeFormat, (GenericStringValue)presentationValues.get("LANGUAGE"), userSession);
                    userSession.setUserData(userData);
                    String backto = userFunction.getReturnPath();
                    String backparms = userFunction.getQueryString();
                    backparms = backparms == null ? "USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken() : String.valueOf(backparms) + "&USERSESSIONID=" + userSession.getSessionID() + "&USERSESSIONTOKEN=" + userSession.getSessionVerificationToken();
                    functionStack.removeLast();
                    String erdurl = resp.encodeRedirectURL(String.valueOf(backto) + "?" + backparms);
                    try {
                        resp.sendRedirect(erdurl);
                        break block15;
                    }
                    catch (IOException e2) {
                        throw new ServletException(e2.getMessage());
                    }
                }
                if (action.equalsIgnoreCase("CANCEL")) {
                    Architecture.dropUserSession(userSession.getSessionID());
                    String erdurl = resp.encodeRedirectURL(req.getContextPath());
                    try {
                        resp.sendRedirect(erdurl);
                        break block15;
                    }
                    catch (IOException e) {
                        this.log(e.getMessage(), e);
                        req.getSession().invalidate();
                        Architecture.dropUserSession(userSession.getSessionID());
                        throw new ServletException(e.getMessage());
                    }
                }
                userFunction.fillInPresentationValuesIgnoringDefaults(req);
                userFunction.doActionLogic(action);
                try {
                    resp.getWriter().write(userFunction.getHTMLOutput());
                }
                catch (IOException e1) {
                    throw new ServletException(e1.getMessage());
                }
            }
            catch (WaarException e3) {
                userFunction.setPresentationMessage(e3);
                try {
                    resp.getWriter().write(userFunction.getHTMLOutput());
                }
                catch (IOException e1) {
                    throw new ServletException(e1.getMessage());
                }
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.process(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.process(req, resp);
    }
}

