/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.ComboBoxRenderer;
import be.WAAR.PresentationLayer.GenericEnumerationType;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.NumberedEnumerationValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.RadioButtonRenderer;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

public abstract class NumberedEnumerationType
extends GenericEnumerationType {
    private boolean caseSensitive = false;
    private String[] labels;

    public NumberedEnumerationType(String[] labels) {
        this.labels = labels;
        HashSet<String> s = new HashSet<String>();
        int i = 0;
        while (i < labels.length && !this.caseSensitive) {
            String ucLabel = labels[i].toUpperCase();
            if (s.contains(ucLabel)) {
                this.caseSensitive = true;
            } else {
                s.add(ucLabel);
            }
            ++i;
        }
    }

    final String[] getLabels() {
        return this.labels;
    }

    @Override
    public final WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        int c = 0;
        while (c < this.labels.length) {
            if (this.labels[c].equalsIgnoreCase(val) && !this.caseSensitive || this.labels[c].equals(val) && this.caseSensitive) {
                return new NumberedEnumerationValue(c + 1, this);
            }
            ++c;
        }
        try {
            int index = Integer.parseInt(val);
            if (index <= this.labels.length) {
                return new NumberedEnumerationValue(index, this);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(this.labels)).toString(), locale);
    }

    @Override
    public final Renderer getDefaultPresentationRenderingStyle() {
        return RadioButtonRenderer.getInstance();
    }

    @Override
    public final String getEmptyNakedStringRepresentation(PresentationField presentationField, Locale locale) {
        return "";
    }

    @Override
    public final String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        if (waarValue instanceof NumberedEnumerationValue) {
            int offsetValue = ((NumberedEnumerationValue)waarValue).getIntegerValue() - 1;
            return offsetValue >= 0 && offsetValue < this.labels.length ? this.labels[offsetValue] : "";
        }
        if (waarValue == null) {
            return "";
        }
        throw new IllegalArgumentException(waarValue.getClass().getName());
    }

    @Override
    public final Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        if (renderingStyleName.equalsIgnoreCase("TEXTBOX")) {
            return TextBoxRenderer.getInstance();
        }
        if (renderingStyleName.equalsIgnoreCase("COMBOBOX")) {
            return ComboBoxRenderer.getInstance();
        }
        return RadioButtonRenderer.getInstance();
    }

    @Override
    public final WaarValue getWaarValue(int v, Locale locale) throws InvalidAttributeValueException {
        if (v < 1 || v > this.labels.length) {
            throw new InvalidAttributeValueException(Integer.toString(v), this.getClass().getName(), new HashSet<String>(Arrays.asList(this.labels)).toString(), locale);
        }
        return new NumberedEnumerationValue(v, this);
    }

    public final String toString(int integer) {
        return this.labels[integer - 1];
    }

    public final NumberedEnumerationValue value(int i, Locale locale) throws InvalidAttributeValueException {
        if (i < 1 || i > this.labels.length) {
            throw new InvalidAttributeValueException(Integer.toString(i), this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(this.labels)).toString(), locale);
        }
        return new NumberedEnumerationValue(i, this);
    }

    @Override
    public final WaarValue getWaarValue(long v, Locale locale) throws InvalidAttributeValueException {
        if (v < 1L || v > (long)this.labels.length) {
            throw new InvalidAttributeValueException(Long.toString(v), this.getClass().getName(), new HashSet<String>(Arrays.asList(this.labels)).toString(), locale);
        }
        return new NumberedEnumerationValue((int)v, this);
    }

    @Override
    public final WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof NumberedEnumerationValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        int i = ((NumberedEnumerationValue)value).getIntegerValue();
        if (i < 1 || i > this.labels.length) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(Integer.toString(i), this.getClass().getSimpleName(), new HashSet<String>(Arrays.asList(this.labels)).toString(), locale);
        }
        return value;
    }
}

