/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.ActionUnknownException;
import be.WAAR.PresentationLayer.FunctionContextDoesNotHoldThisPropertyException;
import be.WAAR.PresentationLayer.HTMLPresentationHandler;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.MandatoryFieldMissingException;
import be.WAAR.PresentationLayer.NoStackedPresentationException;
import be.WAAR.PresentationLayer.NotFoundException;
import be.WAAR.PresentationLayer.Presentation;
import be.WAAR.PresentationLayer.PresentationFunction;
import be.WAAR.PresentationLayer.PresentationNotSetException;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;

public abstract class OnLinePresentationFunction
extends PresentationFunction {
    private HttpServlet callingServlet;
    private HashMap<String, Object> functionUserContext = new HashMap();
    private HTMLPresentationHandler htmlHandler;
    private Presentation presentation;
    private LinkedList<Presentation> presentationStack = new LinkedList();
    private String queryString;
    private String returnParms;
    private String returnPath;
    private String servletPath;
    private boolean suspended = false;

    private void setPresentation(Presentation presentation) {
        this.presentation = presentation;
        this.htmlHandler = new HTMLPresentationHandler(this);
    }

    final void endPresentationLogic() {
    }

    void fillInPresentationValuesIgnoringDefaults(HttpServletRequest req) throws InvalidAttributeValueException, MandatoryFieldMissingException {
        this.presentation.setPresentationValuesIgnoringDefaults(req, this.getUserData());
    }

    void fillInPresentationValuesIncludingDefaults(HttpServletRequest req) throws InvalidAttributeValueException {
        this.presentation.setPresentationValuesIncludingDefaults(req, this.getUserData());
    }

    HttpServlet getCallingServlet() {
        return this.callingServlet;
    }

    String getHTMLOutput() {
        return this.htmlHandler.createOutputData(this.getUserLocale());
    }

    String getQueryString() {
        return this.queryString;
    }

    String getReturnParms() {
        return this.returnParms;
    }

    String getReturnPath() {
        return this.returnPath;
    }

    String getServletPath() {
        return this.servletPath;
    }

    void initialize(String applicationName, String queryString_p, UserData userData, String returnPath_p, String returnParms_p, String functionName, HttpServletRequest req, HttpServlet servlet) {
        this.setApplicationName(applicationName);
        this.servletPath = String.valueOf(applicationName) + req.getServletPath();
        this.queryString = queryString_p;
        this.setUserData(userData);
        this.returnPath = returnPath_p;
        this.returnParms = returnParms_p;
        this.callingServlet = servlet;
        String presentationName = this.getInitialPresentationName();
        if (presentationName == null) {
            presentationName = functionName;
        }
        try {
            this.setPresentation(presentationName);
            this.fillInPresentationValuesIncludingDefaults(req);
            this.doInitialLogic();
        }
        catch (WaarException e) {
            this.setPresentationMessage(e);
        }
    }

    boolean isSuspended() {
        return this.suspended;
    }

    final void setPresentationMessage(WaarException e) {
        this.presentation.setMessage(e.getMessage());
    }

    void suspend() {
        this.suspended = true;
    }

    void unSuspend() {
        this.suspended = false;
        try {
            this.doResumeLogic();
        }
        catch (WaarException e) {
            this.setPresentationMessage(e);
        }
    }

    public void doActionLogic(String action) throws WaarException {
        throw new ActionUnknownException(action, this.getUserLocale());
    }

    public void doCancel() {
    }

    public abstract void doInitialLogic() throws WaarException;

    public abstract void doPresentationLogic() throws WaarException;

    public abstract void doResumeLogic() throws WaarException;

    public final Object getFromFunctionContextMandatory(String name) throws FunctionContextDoesNotHoldThisPropertyException {
        if (!this.functionUserContext.containsKey(name)) {
            throw new FunctionContextDoesNotHoldThisPropertyException(name, this.getUserLocale());
        }
        return this.functionUserContext.get(name);
    }

    public final Object getFromFunctionContext(String name) throws NotFoundException {
        if (!this.functionUserContext.containsKey(name)) {
            throw new NotFoundException();
        }
        return this.functionUserContext.get(name);
    }

    public final Object getFromSessionContext(String name) {
        return this.getUserData().getFromSessionContext(name);
    }

    public abstract String getInitialPresentationName();

    public final Presentation getPresentation() {
        return this.presentation;
    }

    public abstract String getPresentationFunctionDescription(String var1);

    public final WaarValue getPresentationValue(String presentationFieldName) {
        return this.presentation.getPresentationValues().get(presentationFieldName);
    }

    public boolean leaveFunctionOnExit() {
        return true;
    }

    public final void log(String msg) {
        this.callingServlet.log(msg);
    }

    public final void log(Throwable e) {
        this.callingServlet.log(e.getMessage(), e);
    }

    public final void popoffPresentation() throws NoStackedPresentationException {
        if (this.presentationStack.size() <= 0) {
            throw new NoStackedPresentationException(this.getUserLocale());
        }
        Presentation revertToPresentation = this.presentationStack.removeLast();
        this.setPresentation(revertToPresentation);
    }

    public final void popupPresentation(String presentationName) throws PresentationNotSetException {
        this.presentationStack.addLast(this.presentation);
        this.setPresentation(presentationName);
    }

    public final void saveInFunctionContext(String name, Object object) {
        this.functionUserContext.put(name, object);
    }

    public final void saveInSessionContext(String name, Object o) {
        this.getUserData().saveInSessionContext(name, o);
    }

    public final void setPresentation(String name) throws PresentationNotSetException {
        Locale locale = this.getUserLocale();
        try {
            this.presentation = new Presentation(this.getClass(), name, locale);
        }
        catch (WaarException e) {
            this.log(e);
            try {
                this.presentation = new Presentation(OnLinePresentationFunction.class, "PresentationProblem", locale);
            }
            catch (WaarException e1) {
                throw new RuntimeException("Neither the application's requested presentation, nor the architecture's presentation reporting this problem, could be set.  Problem with application's presentation was : " + e.getMessage() + ".  Problem with architecture's presentation was : " + e1.getMessage(), e);
            }
            this.htmlHandler = new HTMLPresentationHandler(this);
            throw new PresentationNotSetException(name, this.getApplicationName(), e.getMessage(), locale);
        }
        this.htmlHandler = new HTMLPresentationHandler(this);
    }

    public final void setPresentationMessage(String localizedMessage) {
        this.presentation.setMessage(localizedMessage);
    }

    public final void setPresentationValue(String presentationFieldName, boolean v) throws WaarException {
        this.setPresentationValue(presentationFieldName, this.getPresentation().getPresentationField(presentationFieldName, this.getUserLocale()).getType().getWaarValue(v, this.getUserLocale()));
    }

    public final void setPresentationValue(String presentationFieldName, char v) throws WaarException {
        this.setPresentationValue(presentationFieldName, Character.toString(v));
    }

    public final void setPresentationValue(String presentationFieldName, double v) throws WaarException {
        this.setPresentationValue(presentationFieldName, Double.toString(v));
    }

    public final void setPresentationValue(String presentationFieldName, float v) throws WaarException {
        this.setPresentationValue(presentationFieldName, Float.toString(v));
    }

    public final void setPresentationValue(String presentationFieldName, int v) throws WaarException {
        this.setPresentationValue(presentationFieldName, this.getPresentation().getPresentationField(presentationFieldName, this.getUserLocale()).getType().getWaarValue(v, this.getUserLocale()));
    }

    public final void setPresentationValue(String presentationFieldName, long v) throws WaarException {
        this.setPresentationValue(presentationFieldName, this.getPresentation().getPresentationField(presentationFieldName, this.getUserLocale()).getType().getWaarValue(v, this.getUserLocale()));
    }

    public final void setPresentationValue(String presentationFieldName, String v) throws WaarException {
        this.presentation.getPresentationValues().put(presentationFieldName, this.presentation.getPresentationField(presentationFieldName, this.getUserLocale()).getType().encode(v, this.getUserData(), this.getUserLocale()));
    }

    public final void setPresentationValue(String presentationFieldName, WaarValue value) throws WaarException {
        WaarValue checkedValue = this.presentation.getPresentationField(presentationFieldName, this.getUserLocale()).checkValidWaarValue(value, this.getUserData());
        this.presentation.getPresentationValues().put(presentationFieldName, checkedValue);
    }
}

