/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.DynamicColumnList;
import be.WAAR.PresentationLayer.HTMLEntityRefs;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InOutMode;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.List;
import be.WAAR.PresentationLayer.Logical;
import be.WAAR.PresentationLayer.MandatoryFieldMissingException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationDefinitionsIOException;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationFieldMissingException;
import be.WAAR.PresentationLayer.PresentationMissingException;
import be.WAAR.PresentationLayer.ResourceNotFoundException;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class Presentation {
    private static final String __LINK__ = "__LINK__";
    private static final String LABELSSUFFIX = ".labels";
    private static final String PRESENTATIONSUFFIX = ".pres";
    private Properties labelsForLanguageUnspecified;
    private String message;
    private String name;
    private HashMap<String, Properties> nlPresentationLabels;
    private LinkedList<String> presentationActions;
    private HashMap<String, PresentationField> presentationFields;
    private HashMap<String, WaarValue> presentationValues;

    public Presentation(Class<? extends OnLinePresentationFunction> presentationFunctionClass, String name, Locale locale) throws WaarException {
        block42: {
            BufferedReader in;
            this.labelsForLanguageUnspecified = new Properties();
            this.message = "";
            this.nlPresentationLabels = new HashMap();
            this.presentationActions = new LinkedList();
            this.presentationFields = new HashMap();
            this.presentationValues = new HashMap();
            this.name = name;
            try {
                in = Architecture.getResourceReader(String.valueOf(name) + PRESENTATIONSUFFIX, presentationFunctionClass);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                throw new PresentationMissingException(name, locale);
            }
            PresentationField currentListField = null;
            LinkedList<PresentationField> listFieldStack = new LinkedList<PresentationField>();
            try {
                try {
                    String w;
                    while ((w = in.readLine()) != null) {
                        PresentationField presentationField;
                        if ((w = w.trim()).length() <= 0 || w.startsWith("# ")) continue;
                        if (currentListField == null) {
                            if (w.length() > 6 && w.substring(0, 7).equalsIgnoreCase("ACTION ")) {
                                this.presentationActions.addLast(w.substring(7).trim());
                                continue;
                            }
                            presentationField = new PresentationField(w, presentationFunctionClass, locale);
                            this.presentationFields.put(presentationField.getName(), presentationField);
                            if (!(presentationField.getType() instanceof List) && !(presentationField.getType() instanceof DynamicColumnList)) continue;
                            listFieldStack.addLast(currentListField);
                            currentListField = presentationField;
                            if (!(currentListField.getType() instanceof List)) continue;
                            currentListField.setTableRowHtml(name, presentationFunctionClass);
                            continue;
                        }
                        if (w.equals("(")) continue;
                        if (w.equals(")")) {
                            if (listFieldStack.size() > 0) {
                                currentListField = (PresentationField)listFieldStack.removeLast();
                                continue;
                            }
                            currentListField = null;
                            continue;
                        }
                        presentationField = new PresentationField(w, presentationFunctionClass, locale);
                        currentListField.addColumn(presentationField);
                        if (!(presentationField.getType() instanceof List) && !(presentationField.getType() instanceof DynamicColumnList)) continue;
                        listFieldStack.addLast(currentListField);
                        currentListField = presentationField;
                        if (!(currentListField.getType() instanceof List)) continue;
                        currentListField.setTableRowHtml(name, presentationFunctionClass);
                    }
                }
                catch (IOException e) {
                    this.presentationFields.clear();
                    throw new PresentationDefinitionsIOException(e, locale);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                InputStream labelsForLanguageUnspecifiedInputStream = Architecture.getResourceInputStream(String.valueOf(name) + LABELSSUFFIX, presentationFunctionClass);
                try {
                    try {
                        this.labelsForLanguageUnspecified.load(labelsForLanguageUnspecifiedInputStream);
                    }
                    catch (IOException iOException) {
                        this.labelsForLanguageUnspecified.clear();
                        try {
                            labelsForLanguageUnspecifiedInputStream.close();
                        }
                        catch (IOException iOException2) {}
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        labelsForLanguageUnspecifiedInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    labelsForLanguageUnspecifiedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                this.labelsForLanguageUnspecified.clear();
            }
        }
        Set<String> languages = Architecture.supportedLanguages().keySet();
        for (String language : languages) {
            Properties labelsForLanguageSpecified;
            block44: {
                labelsForLanguageSpecified = new Properties(this.labelsForLanguageUnspecified);
                try {
                    InputStream labelsForLanguageSpecifiedInputStream = Architecture.getResourceInputStream(String.valueOf(name) + LABELSSUFFIX + '.' + language, presentationFunctionClass);
                    try {
                        try {
                            labelsForLanguageSpecified.load(labelsForLanguageSpecifiedInputStream);
                        }
                        catch (IOException iOException) {
                            labelsForLanguageSpecified.clear();
                            try {
                                labelsForLanguageSpecifiedInputStream.close();
                            }
                            catch (IOException iOException3) {}
                            break block44;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            labelsForLanguageSpecifiedInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        labelsForLanguageSpecifiedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    labelsForLanguageSpecified.clear();
                }
            }
            this.nlPresentationLabels.put(language, labelsForLanguageSpecified);
        }
    }

    private void eraseInputFields(Locale locale) {
        Locale useLocale = locale == null ? Architecture.getDefaultLocale() : locale;
        for (Map.Entry<String, PresentationField> me : this.presentationFields.entrySet()) {
            String attributeName = me.getKey();
            PresentationField presentationField = me.getValue();
            if (!presentationField.isInputEnabled()) continue;
            if (presentationField.getType().isTheBoolean()) {
                this.presentationValues.put(attributeName, presentationField.getType().getWaarValue(false, useLocale));
                continue;
            }
            this.presentationValues.remove(attributeName);
        }
    }

    private void setPresentationInputValuesFromLinkParameters(HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            Locale locale;
            String sanitizedPresentationFieldName;
            String presentationFieldName = (String)parameterNames.nextElement();
            if (!presentationFieldName.startsWith(__LINK__) || !this.presentationFields.containsKey(sanitizedPresentationFieldName = HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(presentationFieldName).substring(__LINK__.length()))) continue;
            PresentationField presentationField = this.presentationFields.get(sanitizedPresentationFieldName);
            String parameterValue = req.getParameter(presentationFieldName);
            Locale locale2 = locale = userData == null ? Architecture.getDefaultLocale() : userData.getLocale();
            if (locale == null) {
                locale = Architecture.getDefaultLocale();
            }
            if (presentationField.getType() instanceof Logical) {
                if (parameterValue != null && parameterValue.length() > 0) {
                    this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(parameterValue, userData, locale));
                    continue;
                }
                this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.False"), userData, locale));
                continue;
            }
            if (parameterValue == null || parameterValue.length() <= 0) continue;
            this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(parameterValue), userData, locale));
        }
    }

    private void setPresentationInputValuesFromReqParameters(HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            Locale locale;
            PresentationField presentationField;
            String presentationFieldName = (String)parameterNames.nextElement();
            String sanitizedPresentationFieldName = HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(presentationFieldName);
            if (!this.presentationFields.containsKey(sanitizedPresentationFieldName) || !(presentationField = this.presentationFields.get(sanitizedPresentationFieldName)).isInputEnabled()) continue;
            String parameterValue = req.getParameter(presentationFieldName);
            Locale locale2 = locale = userData == null ? Architecture.getDefaultLocale() : userData.getLocale();
            if (locale == null) {
                locale = Architecture.getDefaultLocale();
            }
            if (presentationField.getType() instanceof Logical) {
                if (parameterValue != null && parameterValue.length() > 0) {
                    this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(parameterValue, userData, locale));
                    continue;
                }
                this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(I18N.getString(locale, "Logical.False"), userData, locale));
                continue;
            }
            if (parameterValue == null || parameterValue.length() <= 0) continue;
            this.presentationValues.put(sanitizedPresentationFieldName, presentationField.getType().encode(HTMLEntityRefs.V4_0.fromEntityRefsToUnicodeString(parameterValue), userData, locale));
        }
    }

    Properties getLabels(Locale locale) {
        Properties labels = this.nlPresentationLabels.get(locale.getLanguage().toUpperCase());
        if (labels == null) {
            return this.labelsForLanguageUnspecified;
        }
        return labels;
    }

    LinkedList<String> getPresentationActions() {
        return this.presentationActions;
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setPresentationValuesIgnoringDefaults(HttpServletRequest req, UserData userData) throws MandatoryFieldMissingException, InvalidAttributeValueException {
        this.eraseInputFields(userData == null ? Architecture.getDefaultLocale() : userData.getLocale());
        this.setPresentationInputValuesFromReqParameters(req, userData);
        for (PresentationField presentationField : this.presentationFields.values()) {
            String attributeName = presentationField.getName();
            if (this.presentationValues.get(attributeName) != null || !presentationField.isInputEnabled() || !presentationField.isMandatory()) continue;
            throw new MandatoryFieldMissingException(attributeName, userData == null ? Architecture.getDefaultLocale() : userData.getLocale());
        }
    }

    void setPresentationValuesIncludingDefaults(HttpServletRequest req, UserData userData) throws InvalidAttributeValueException {
        this.eraseInputFields(userData == null ? Architecture.getDefaultLocale() : userData.getLocale());
        this.setPresentationInputValuesFromReqParameters(req, userData);
        this.setPresentationInputValuesFromLinkParameters(req, userData);
        for (PresentationField presentationField : this.getPresentationFields().values()) {
            if (presentationField.getDefaultValue() == null || this.presentationValues.containsKey(presentationField.getName())) continue;
            this.presentationValues.put(presentationField.getName(), presentationField.getDefaultValue());
        }
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getName() {
        return this.name;
    }

    public final PresentationField getPresentationField(String presentationFieldName, Locale locale) throws WaarException {
        if (this.presentationFields.containsKey(presentationFieldName)) {
            return this.presentationFields.get(presentationFieldName);
        }
        throw new PresentationFieldMissingException(presentationFieldName, this.name, locale);
    }

    public final HashMap<String, PresentationField> getPresentationFields() {
        return this.presentationFields;
    }

    public final HashMap<String, WaarValue> getPresentationValues() {
        return this.presentationValues;
    }

    public final void setPresentationFieldInOutMode(String presentationFieldName, InOutMode mode, Locale locale) throws WaarException {
        this.getPresentationField(presentationFieldName, locale).setInOutMode(mode);
    }

    public String toString() {
        return String.valueOf(this.name) + this.presentationFields;
    }
}

