/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.Architecture;
import be.WAAR.PresentationLayer.DynamicColumnList;
import be.WAAR.PresentationLayer.InOutMode;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.List;
import be.WAAR.PresentationLayer.NoColumnsInNonListFieldsException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.ResourceNotFoundException;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarException;
import be.WAAR.PresentationLayer.WaarValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class PresentationField {
    private static int QY_ATTRIBUTES_MAX = 8;
    private static final String TABLEROWHTML = ".tablerowhtml";
    private WaarValue defaultValue;
    private boolean inputEnabled;
    private HashMap<String, PresentationField> listFieldMap;
    private boolean mandatory;
    private String name = "";
    private Renderer presentationRenderer;
    private String presentationSizeSpec;
    private StringBuffer rowTemplateText;
    private int tabIndex = -1;
    private PresentationType type;

    PresentationField(String txt, Class<? extends OnLinePresentationFunction> presentationFunctionClass, Locale locale) throws WaarException {
        int ord = 0;
        String remain = txt;
        block10: do {
            String keyWord;
            int commaPos;
            if ((commaPos = remain.indexOf(",")) >= 0) {
                keyWord = remain.substring(0, commaPos).trim();
                remain = remain.substring(commaPos + 1);
            } else {
                keyWord = remain.trim();
                remain = "";
            }
            switch (ord) {
                case 0: {
                    this.name = keyWord;
                    break;
                }
                case 1: {
                    this.type = Architecture.getAttributeType(keyWord, presentationFunctionClass, locale);
                    if (!(this.type instanceof List) && !(this.type instanceof DynamicColumnList)) continue block10;
                    this.listFieldMap = new HashMap();
                    break;
                }
                case 2: {
                    if (keyWord.length() <= 0) break;
                    this.defaultValue = this.type.encode(keyWord, null, locale);
                    break;
                }
                case 3: {
                    if (this.type instanceof List || this.type instanceof DynamicColumnList || keyWord.equals("0") || keyWord.equalsIgnoreCase("OPTIONAL")) {
                        this.mandatory = false;
                        break;
                    }
                    if (keyWord.equals("") || keyWord.equals("1") || keyWord.equalsIgnoreCase("MANDATORY")) {
                        this.mandatory = true;
                        break;
                    }
                    throw new IllegalArgumentException(keyWord);
                }
                case 4: {
                    if (keyWord.length() > 0) {
                        this.tabIndex = Integer.parseInt(keyWord);
                        break;
                    }
                    this.tabIndex = -1;
                    break;
                }
                case 5: {
                    if (this.type instanceof List || this.type instanceof DynamicColumnList) {
                        this.inputEnabled = false;
                        break;
                    }
                    if (keyWord.length() == 0 || keyWord.equalsIgnoreCase("INPUT")) {
                        this.inputEnabled = true;
                        break;
                    }
                    if (keyWord.equalsIgnoreCase("OUTPUT")) {
                        this.inputEnabled = false;
                        break;
                    }
                    throw new IllegalArgumentException(keyWord);
                }
                case 6: {
                    if (keyWord.length() > 0) {
                        this.presentationRenderer = this.type.getPresentationRenderingStyle(keyWord);
                        break;
                    }
                    this.presentationRenderer = this.type.getDefaultPresentationRenderingStyle();
                    break;
                }
                case 7: {
                    this.presentationSizeSpec = keyWord.length() > 0 ? keyWord : "";
                }
            }
        } while (++ord < QY_ATTRIBUTES_MAX);
    }

    int getColumnCount() {
        return this.listFieldMap == null ? 0 : this.listFieldMap.size();
    }

    WaarValue getDefaultValue() {
        return this.defaultValue;
    }

    final Renderer getPresentationRenderer() {
        return this.presentationRenderer;
    }

    int getTabIndex() {
        return this.tabIndex;
    }

    final boolean isInputEnabled() {
        return this.inputEnabled;
    }

    boolean isMandatory() {
        return this.mandatory;
    }

    final void setInOutMode(InOutMode mode) {
        this.inputEnabled = mode == InOutMode.IN;
    }

    void setTableRowHtml(String presentationName, Class<? extends OnLinePresentationFunction> presentationFunctionClass) {
        this.rowTemplateText = new StringBuffer(8192);
        String tableRowHTMLResourceName = String.valueOf(presentationName) + "." + this.name + TABLEROWHTML;
        try {
            BufferedReader in = Architecture.getResourceReader(tableRowHTMLResourceName, presentationFunctionClass);
            try {
                try {
                    String w;
                    while ((w = in.readLine()) != null) {
                        this.rowTemplateText.append(w);
                    }
                }
                catch (IOException e1) {
                    this.rowTemplateText = new StringBuffer("Error while building table row template : " + e1.getMessage());
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace(System.err);
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace(System.err);
                }
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.rowTemplateText = new StringBuffer("Table row template HTML resource " + tableRowHTMLResourceName + "not found.");
        }
    }

    public void addColumn(PresentationField presentationField) {
        this.listFieldMap.put(presentationField.getName(), presentationField);
    }

    public PresentationField getColumn(String columnName, Locale locale) throws NoColumnsInNonListFieldsException {
        if (this.listFieldMap == null) {
            throw new NoColumnsInNonListFieldsException(this.name, this.type.getClass().getName(), columnName, locale);
        }
        return this.listFieldMap.get(columnName);
    }

    public String getName() {
        return this.name;
    }

    public String getPresentationSizeSpec() {
        return this.presentationSizeSpec;
    }

    public StringBuffer getRowTemplateText() {
        return this.rowTemplateText;
    }

    public PresentationType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.type;
    }

    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        return this.type.checkValidWaarValue(value, userData);
    }
}

