/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.NumberedEnumerationType;
import be.WAAR.PresentationLayer.NumberedEnumerationValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.Locale;

final class RadioButtonRenderer
extends Renderer {
    private static Renderer instance = new RadioButtonRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private RadioButtonRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        return this.getHTML(null, null, presentationField, locale);
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        String[] labels = ((NumberedEnumerationType)presentationField.getType()).getLabels();
        if (presentationFieldValue instanceof NumberedEnumerationValue) {
            NumberedEnumerationValue numberedEnumerationValue = (NumberedEnumerationValue)presentationFieldValue;
            int offsetValue = numberedEnumerationValue.getIntegerValue() - 1;
            StringBuilder htmlFieldValue = new StringBuilder(80 * labels.length);
            int c = 0;
            while (c < labels.length) {
                if (c > 0) {
                    htmlFieldValue.append("<BR>");
                }
                String cookedLabel = this.processEntityRefs(labels[c]);
                htmlFieldValue.append("<INPUT TYPE=\"RADIO\"").append(this.getHTMLControlNameSpec(presentationField)).append(this.getHTMLTabIndexSpec(presentationField)).append(" VALUE=\"").append(cookedLabel).append("\" ").append(c == offsetValue ? "CHECKED" : "").append(" >").append(cookedLabel).append("</INPUT>");
                ++c;
            }
            return htmlFieldValue.toString();
        }
        if (presentationFieldValue == null) {
            StringBuilder htmlFieldValue = new StringBuilder(80 * labels.length);
            int c = 0;
            while (c < labels.length) {
                if (c > 0) {
                    htmlFieldValue.append("<BR>");
                }
                String cookedLabel = this.processEntityRefs(labels[c]);
                htmlFieldValue.append("<INPUT TYPE=\"RADIO\"").append(this.getHTMLControlNameSpec(presentationField)).append(this.getHTMLTabIndexSpec(presentationField)).append(" VALUE=\"").append(cookedLabel).append("\" ").append(" >").append(cookedLabel).append("</INPUT>");
                ++c;
            }
            return htmlFieldValue.toString();
        }
        throw new IllegalArgumentException(presentationFieldValue.getClass().getName());
    }
}

