/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.Locale;

final class TextAreaRenderer
extends Renderer {
    private static Renderer instance = new TextAreaRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private TextAreaRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        if (presentationField.isInputEnabled()) {
            return "<TEXTAREA name=\"" + presentationField.getName() + "\" rows=\"5\" cols=\"80\" size=\"99%\"" + this.getHTMLTabIndexSpec(presentationField) + "></TEXTAREA>";
        }
        return "";
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        if (presentationField.isInputEnabled()) {
            return "<TEXTAREA name=\"" + presentationField.getName() + "\" rows=\"5\" cols=\"80\" size=\"99%\"" + this.getHTMLTabIndexSpec(presentationField) + ">" + presentationFieldValue.toWAARString(userFunction.getUserData()) + "</TEXTAREA>";
        }
        return "";
    }
}

