/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.ComboBoxRenderer;
import be.WAAR.PresentationLayer.GenericEnumerationType;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class TextsEnumerationType
extends GenericEnumerationType {
    private HashMap<String, String> caseInsensitiveValuesAndLabels;
    private boolean caseSensitive = false;
    private Map<String, String> valuesAndLabels = new HashMap<String, String>();

    public TextsEnumerationType(Map<String, String> valuesAndLabels) {
        this.valuesAndLabels.putAll(valuesAndLabels);
        HashSet<String> s = new HashSet<String>();
        for (String value : valuesAndLabels.keySet()) {
            String ucValue = value.toUpperCase();
            if (s.contains(ucValue)) {
                this.caseSensitive = true;
                continue;
            }
            s.add(ucValue);
        }
        if (!this.caseSensitive) {
            this.caseInsensitiveValuesAndLabels = new HashMap();
            for (String value : valuesAndLabels.keySet()) {
                this.caseInsensitiveValuesAndLabels.put(value.toUpperCase(), value);
            }
        }
    }

    final Map<String, String> getValuesAndLabels() {
        return this.valuesAndLabels;
    }

    @Override
    public final WaarValue encode(String val, UserData userData, Locale locale) throws InvalidAttributeValueException {
        if (this.caseSensitive) {
            String encodeKey = val;
            if (this.valuesAndLabels.containsKey(encodeKey)) {
                return new GenericStringValue(val);
            }
            throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), this.valuesAndLabels.keySet().toString(), locale);
        }
        String encodeKey = val.toUpperCase();
        if (this.caseInsensitiveValuesAndLabels.containsKey(encodeKey)) {
            return new GenericStringValue(this.caseInsensitiveValuesAndLabels.get(encodeKey));
        }
        throw new InvalidAttributeValueException(val, this.getClass().getSimpleName(), this.valuesAndLabels.keySet().toString(), locale);
    }

    @Override
    public final Renderer getDefaultPresentationRenderingStyle() {
        return ComboBoxRenderer.getInstance();
    }

    @Override
    public String getEmptyNakedStringRepresentation(PresentationField presentationField, Locale locale) {
        return "";
    }

    @Override
    public final String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        String stringValue = ((GenericStringValue)waarValue).getString();
        if (this.caseSensitive) {
            String label = this.valuesAndLabels.get(stringValue);
            return label == null ? "" : label;
        }
        String label = this.caseInsensitiveValuesAndLabels.get(stringValue.toUpperCase());
        return label == null ? "" : label;
    }

    @Override
    public final Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        if (renderingStyleName.equalsIgnoreCase("TEXTBOX")) {
            return TextBoxRenderer.getInstance();
        }
        return ComboBoxRenderer.getInstance();
    }

    @Override
    public final WaarValue getWaarValue(int v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final WaarValue getWaarValue(long v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof GenericStringValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return this.encode(((GenericStringValue)value).getString(), userData, userData.getLocale());
    }
}

