/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;

class UDBInputStream
extends FilterInputStream {
    private static final int[] mask;
    private int bits = 0;
    private int buffer = 0;
    private boolean EOF = false;

    static {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 15;
        mask = nArray;
    }

    UDBInputStream(File f) throws FileNotFoundException {
        super(new FileInputStream(f));
    }

    @Override
    public int available() throws IOException {
        return (6 * super.available() + this.bits) / 8;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int ret;
        while (this.bits < 8 && !this.EOF) {
            int b = super.read();
            if (b >= 0) {
                if (b < 32 || b > 95) {
                    throw new IOException("Invalid byte " + Integer.toHexString(b));
                }
                b = 95 - b;
                this.buffer = this.buffer << 6 | b;
                this.bits += 6;
                continue;
            }
            this.EOF = true;
        }
        if (this.bits >= 8) {
            this.bits -= 8;
            ret = this.buffer >> this.bits;
            this.buffer &= mask[this.bits >> 1];
        } else {
            ret = -1;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.EOF) {
            return -1;
        }
        if (len < 1) {
            return 0;
        }
        int wrkoff = off;
        boolean cont = true;
        int c = 0;
        do {
            byte byteRead;
            if ((byteRead = (byte)this.read()) >= 0) {
                b[wrkoff++] = byteRead;
                ++c;
                continue;
            }
            cont = false;
        } while (cont);
        return c > 0 ? c : -1;
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }
}

