/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.UserSession;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class UserData {
    private SimpleDateFormat preferredDateFormat;
    private SimpleDateFormat preferredDateTimeFormat;
    private SimpleDateFormat preferredTimeFormat;
    private String userID;
    private GenericStringValue userLanguage;
    private UserSession userSession;
    private Locale locale;

    UserData(String userid, String dateFormat, String timeFormat, GenericStringValue userLanguage) throws InvalidAttributeValueException {
        this.userID = userid;
        this.userLanguage = userLanguage;
        this.locale = new Locale(userLanguage.getString());
        try {
            this.preferredDateFormat = new SimpleDateFormat(dateFormat);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(dateFormat, e.getMessage(), this.locale);
        }
        try {
            this.preferredTimeFormat = new SimpleDateFormat(timeFormat);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(dateFormat, e.getMessage(), this.locale);
        }
        String dateTimeFormat = String.valueOf(dateFormat) + ' ' + timeFormat;
        try {
            this.preferredDateTimeFormat = new SimpleDateFormat(dateTimeFormat);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(dateTimeFormat, e.getMessage(), this.locale);
        }
    }

    UserData(String userid, String dateFormat, String timeFormat, GenericStringValue userLanguage, UserSession userSession) throws InvalidAttributeValueException {
        this(userid, dateFormat, timeFormat, userLanguage);
        this.userSession = userSession;
    }

    Object getFromSessionContext(String name) {
        if (this.userSession != null) {
            return this.userSession.getFromContext(name);
        }
        return null;
    }

    SimpleDateFormat getPreferredDateFormat() {
        return this.preferredDateFormat;
    }

    SimpleDateFormat getPreferredDateTimeFormat() {
        return this.preferredDateTimeFormat;
    }

    SimpleDateFormat getPreferredTimeFormat() {
        return this.preferredTimeFormat;
    }

    GenericStringValue getUserLanguage() {
        return this.userLanguage;
    }

    UserSession getUserSession() {
        return this.userSession;
    }

    void saveInSessionContext(String name, Object o) {
        if (this.userSession != null) {
            this.userSession.saveInContext(name, o);
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String toString() {
        return String.valueOf(this.userID) + "_" + this.userLanguage + "_" + this.preferredDateFormat.toPattern() + "_" + this.preferredTimeFormat.toPattern();
    }
}

