/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.I18N;
import be.WAAR.PresentationLayer.InvalidAttributeValueException;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PassWordRenderer;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.PresentationType;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.TextBoxRenderer;
import be.WAAR.PresentationLayer.UserData;
import be.WAAR.PresentationLayer.UserIDValue;
import be.WAAR.PresentationLayer.WaarValue;
import be.erwinsmout.MyMessageFormat;
import java.util.Locale;

public class UserID
extends PresentationType {
    @Override
    public WaarValue encode(String val, UserData userData, Locale locale) {
        return new UserIDValue(val);
    }

    @Override
    public Renderer getDefaultPresentationRenderingStyle() {
        return TextBoxRenderer.getInstance();
    }

    @Override
    public String getNakedStringRepresentation(WaarValue waarValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        return ((UserIDValue)waarValue).getUserID();
    }

    @Override
    public Renderer getPresentationRenderingStyle(String renderingStyleName) {
        if (renderingStyleName.equalsIgnoreCase("PASSWORD")) {
            return PassWordRenderer.getInstance();
        }
        return TextBoxRenderer.getInstance();
    }

    @Override
    public WaarValue getWaarValue(int v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(long v, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue getWaarValue(boolean b, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WaarValue checkValidWaarValue(WaarValue value, UserData userData) throws InvalidAttributeValueException {
        if (!(value instanceof UserIDValue)) {
            Locale locale = userData.getLocale();
            throw new InvalidAttributeValueException(value.toWAARString(userData), this.getClass().getSimpleName(), MyMessageFormat.format(I18N.getString(locale, "DynamicColumnList.InvalidValueClass"), new String[]{this.getClass().getName(), value.getClass().getName()}), locale);
        }
        return value;
    }
}

