/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.MaximumInvalidPasswordsExceededException;
import java.util.Iterator;
import java.util.TreeSet;

public class UserProperties {
    private static final int DISABLEPERIODMILLIS = 3600000;
    private static final int INVALIDATEUSERATATTEMPT = 3;
    private String language;
    private String password;
    private boolean passwordToBeChangedAtNextLogon;
    private TreeSet<Long> suspiciousLogonAttemptTimes = new TreeSet();

    UserProperties(String userData_tx) {
        String[] properties = userData_tx.split("#@#");
        this.password = properties[0].trim();
        String passwordChangeRequired = properties.length > 1 ? properties[1].trim() : "true";
        this.passwordToBeChangedAtNextLogon = Boolean.valueOf(passwordChangeRequired);
        String suspiciousLogonAttemptTimes_tx = properties.length > 2 ? properties[2].trim() : "[]";
        suspiciousLogonAttemptTimes_tx = suspiciousLogonAttemptTimes_tx.substring(1, suspiciousLogonAttemptTimes_tx.length() - 1).trim();
        while (suspiciousLogonAttemptTimes_tx.length() > 0) {
            String suspiciousLogonAttemptTime_tx;
            int i = suspiciousLogonAttemptTimes_tx.indexOf(44);
            if (i == -1) {
                suspiciousLogonAttemptTime_tx = suspiciousLogonAttemptTimes_tx.trim();
                suspiciousLogonAttemptTimes_tx = "";
            } else {
                suspiciousLogonAttemptTime_tx = suspiciousLogonAttemptTimes_tx.substring(0, i).trim();
                suspiciousLogonAttemptTimes_tx = suspiciousLogonAttemptTimes_tx.substring(i + 1);
            }
            long suspiciousLogonAttemptTime = Long.parseLong(suspiciousLogonAttemptTime_tx);
            this.suspiciousLogonAttemptTimes.add(new Long(suspiciousLogonAttemptTime));
        }
        this.language = properties.length > 3 ? properties[3].trim() : "EN";
    }

    private long removeOldPasswordFailures() {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<Long> i_suspiciousLogonAttemptTimes = this.suspiciousLogonAttemptTimes.iterator();
        while (i_suspiciousLogonAttemptTimes.hasNext()) {
            Long suspiciousLogonAttemptTime = i_suspiciousLogonAttemptTimes.next();
            if (suspiciousLogonAttemptTime >= currentTimeMillis - 3600000L) continue;
            i_suspiciousLogonAttemptTimes.remove();
        }
        return currentTimeMillis;
    }

    String getPassword() {
        return this.password;
    }

    void registerSuspiciousLogonAttempt() throws MaximumInvalidPasswordsExceededException {
        long currentTimeMillis = this.removeOldPasswordFailures();
        this.suspiciousLogonAttemptTimes.add(new Long(currentTimeMillis));
        if (this.suspiciousLogonAttemptTimes.size() > 3) {
            throw new MaximumInvalidPasswordsExceededException();
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public TreeSet<Long> getSuspiciousLogonAttemptTimes() {
        return this.suspiciousLogonAttemptTimes;
    }

    public boolean isDisabled() {
        long lastSuspiciousLogonAttemptTime;
        long currentTimeMillis = this.removeOldPasswordFailures();
        return this.suspiciousLogonAttemptTimes.size() > 3 && currentTimeMillis < (lastSuspiciousLogonAttemptTime = this.suspiciousLogonAttemptTimes.last().longValue()) + 3600000L;
    }

    public boolean isPasswordToBeChangedAtNextLogon() {
        return this.passwordToBeChangedAtNextLogon;
    }

    public String toString() {
        return String.valueOf(this.password) + "#@#" + this.passwordToBeChangedAtNextLogon + "#@#" + this.suspiciousLogonAttemptTimes + "#@#" + this.language;
    }
}

