/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

import be.WAAR.PresentationLayer.DynamicColumnListValue;
import be.WAAR.PresentationLayer.GenericStringValue;
import be.WAAR.PresentationLayer.OnLinePresentationFunction;
import be.WAAR.PresentationLayer.PresentationField;
import be.WAAR.PresentationLayer.Renderer;
import be.WAAR.PresentationLayer.WaarValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;

final class VariableColumnListRenderer
extends Renderer {
    private static Renderer instance = new VariableColumnListRenderer();

    static Renderer getInstance() {
        return instance;
    }

    private VariableColumnListRenderer() {
    }

    @Override
    String getEmptyHTML(PresentationField presentationField, Locale locale) {
        return "";
    }

    @Override
    String getHTML(WaarValue presentationFieldValue, OnLinePresentationFunction userFunction, PresentationField presentationField, Locale locale) {
        DynamicColumnListValue dynamicColumnListValue = (DynamicColumnListValue)presentationFieldValue;
        LinkedList<String> columnList = dynamicColumnListValue.getColumnList();
        StringBuilder fieldHtml = new StringBuilder(30 * dynamicColumnListValue.getRowList().size() * columnList.size());
        int columnCount = Math.max(columnList.size(), 1);
        int columnWidthPercent = 100 / columnCount;
        fieldHtml.append("<TR>");
        for (String columnName : columnList) {
            fieldHtml.append("<TH width=\"").append(columnWidthPercent).append("%\">").append(columnName).append("</TH>");
        }
        fieldHtml.append("</TR>");
        LinkedList<HashMap<String, WaarValue>> rowList = dynamicColumnListValue.getRowList();
        for (HashMap hashMap : rowList) {
            StringBuffer rowHtml = new StringBuffer("<TR>");
            for (String columnName : columnList) {
                WaarValue entryColumnValue = (WaarValue)hashMap.get(columnName);
                if (entryColumnValue != null) {
                    if (entryColumnValue instanceof GenericStringValue) {
                        rowHtml.append("<TD>" + ((GenericStringValue)entryColumnValue).getString() + "</TD>");
                        continue;
                    }
                    rowHtml.append("<TD><TABLE border=\"1\" width=\"100%\"><TBODY>" + this.getHTML(entryColumnValue, userFunction, presentationField, locale) + "</TBODY></TABLE></TD>");
                    continue;
                }
                rowHtml.append("<TD> </TD>");
            }
            rowHtml.append("</TR>");
            fieldHtml.append(rowHtml);
        }
        return fieldHtml.toString();
    }
}

