/*
 * Decompiled with CFR 0.152.
 */
package be.WAAR.PresentationLayer;

public class Version
implements Comparable<Version> {
    public static final Version ONE_ONE = new Version(1, 1);
    public static final Version ONE_THREE = new Version(1, 3);
    public static final Version ONE_TWO = new Version(1, 2);
    public static final Version ONE_ZERO = new Version(1, 0);
    private short majorVersion;
    private short minorVersion;

    public Version(int fullVersion) {
        this((short)(fullVersion >>> 16), (short)(fullVersion & 0xFFFF));
    }

    public Version(short majorVersion, short minorVersion) {
        if (majorVersion < 1 || minorVersion < 0) {
            throw new IllegalArgumentException();
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Override
    public int compareTo(Version o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.isBefore(o)) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version otherVersion = (Version)obj;
            return otherVersion.majorVersion == this.majorVersion && otherVersion.minorVersion == this.minorVersion;
        }
        return false;
    }

    public int getFullVersion() {
        return this.majorVersion << 16 | this.minorVersion;
    }

    public Version getLowest(Version otherVersion) {
        if (this.isBefore(otherVersion)) {
            return this;
        }
        return otherVersion;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public int hashCode() {
        return this.getFullVersion();
    }

    public boolean isBefore(short majorVersion2, short minorVersion2) {
        return this.majorVersion < majorVersion2 || this.majorVersion == majorVersion2 && this.minorVersion < minorVersion2;
    }

    public boolean isBefore(Version otherVersion) {
        return this.majorVersion < otherVersion.majorVersion || this.majorVersion == otherVersion.majorVersion && this.minorVersion < otherVersion.minorVersion;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.majorVersion)) + '.' + Integer.toString(this.minorVersion);
    }
}

