/*
 * Decompiled with CFR 0.152.
 */
package be.erwinsmout;

import be.erwinsmout.NotFoundException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public abstract class MyResource {
    private static String getResourceBaseName(String resourceTypeName, String resourceName) {
        String lowerCaseResourceTypeName = resourceTypeName.toLowerCase();
        String dotSuffix = String.valueOf('.') + lowerCaseResourceTypeName;
        if (resourceName.toLowerCase().endsWith(lowerCaseResourceTypeName)) {
            if (resourceName.length() > resourceTypeName.length() && resourceName.charAt(resourceName.length() - dotSuffix.length()) != '.') {
                return String.valueOf(resourceName.substring(0, resourceName.length() - resourceTypeName.length())) + dotSuffix;
            }
            return resourceName;
        }
        return String.valueOf(resourceName) + dotSuffix;
    }

    private static InputStream tryInUserHomeDirectory(String resourceName) throws NotFoundException {
        try {
            return new BufferedInputStream(new FileInputStream(new File(String.valueOf(System.getProperty("user.home")) + File.separatorChar + resourceName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotFoundException();
        }
        catch (SecurityException securityException) {
            throw new NotFoundException();
        }
    }

    public static String getPackageResourceBaseName(Class<? extends Object> clazz, String resourceTypeName) {
        return MyResource.getResourceBaseName(resourceTypeName, clazz.getPackage().getName());
    }

    public static String getResourceBaseName(Class<? extends Object> clazz, String resourceTypeName) {
        return MyResource.getResourceBaseName(resourceTypeName, clazz.getName());
    }

    public static InputStream getResourceInputStream(Class<?> clazz, String resourceName) throws NotFoundException {
        String clazzPackageName = clazz.getPackage().getName();
        String modifiedResourceName = resourceName.startsWith(clazzPackageName) ? String.valueOf('/') + clazzPackageName.replace('.', '/') + '/' + resourceName.substring(clazzPackageName.length() + 1) : resourceName;
        InputStream inputStream = clazz.getResourceAsStream(modifiedResourceName);
        if (inputStream == null) {
            inputStream = MyResource.getResourceInputStream(resourceName);
        }
        return inputStream;
    }

    public static InputStream getResourceInputStream(String resourceName) throws NotFoundException {
        InputStream inputStream = null;
        if (resourceName.charAt(0) != '/') {
            File resourceFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + resourceName);
            try {
                inputStream = new BufferedInputStream(new FileInputStream(resourceFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = MyResource.tryInUserHomeDirectory(resourceName);
            }
            catch (SecurityException securityException) {
                inputStream = MyResource.tryInUserHomeDirectory(resourceName);
            }
        }
        if (inputStream == null) {
            throw new NotFoundException();
        }
        return inputStream;
    }

    private MyResource() {
    }
}

