/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.security;

import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.security.ProprietaryOrJCECipherCallbackObject;
import be.SIRAPRISE.security.SPEKey;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class SPE
extends ProprietaryOrJCECipher {
    static final int VECTORSIZE = 1024;
    private SPEKey privateKey;
    private SPEKey publicKey;

    private void transform5Bytes(byte[] wrk, byte[] result, int[] transformationArray) {
        int i1 = (wrk[0] & 0xFF) << 2 | (wrk[1] & 0xC0) >> 6;
        int i2 = (wrk[1] & 0x3F) << 4 | (wrk[2] & 0xF0) >> 4;
        int i3 = (wrk[2] & 0xF) << 6 | (wrk[3] & 0xFC) >> 2;
        int i4 = (wrk[3] & 3) << 8 | wrk[4] & 0xFF;
        int r1 = transformationArray[i1];
        int r2 = transformationArray[i2];
        int r3 = transformationArray[i3];
        int r4 = transformationArray[i4];
        result[0] = (byte)(r1 >> 2);
        result[1] = (byte)(r1 << 6 & 0xFF | r2 >> 4);
        result[2] = (byte)(r2 << 4 & 0xFF | r3 >> 6);
        result[3] = (byte)(r3 << 2 & 0xFF | r4 >> 8);
        result[4] = (byte)(r4 & 0xFF);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] wrk = new byte[5];
        byte[] wrkres = new byte[5];
        wrk[0] = bytes[0];
        wrk[1] = bytes[1];
        wrk[2] = bytes[2];
        wrk[3] = bytes[3];
        wrk[4] = bytes[4];
        this.transform5Bytes(wrk, wrkres, this.privateKey.getTransformationArray());
        byte padByteCount = wrkres[0];
        int resultLength = bytes.length - padByteCount - 1;
        byte[] result = new byte[resultLength];
        if (resultLength > 0) {
            result[0] = wrkres[1];
        }
        if (resultLength > 1) {
            result[1] = wrkres[2];
        }
        if (resultLength > 2) {
            result[2] = wrkres[3];
        }
        if (resultLength > 3) {
            result[3] = wrkres[4];
        }
        int ix = 5;
        while (ix <= bytes.length - 5) {
            wrk[0] = bytes[ix];
            wrk[1] = bytes[ix + 1];
            wrk[2] = bytes[ix + 2];
            wrk[3] = bytes[ix + 3];
            wrk[4] = bytes[ix + 4];
            this.transform5Bytes(wrk, wrkres, this.privateKey.getTransformationArray());
            if (ix - 1 < resultLength) {
                result[ix - 1] = wrkres[0];
            }
            if (ix < resultLength) {
                result[ix] = wrkres[1];
            }
            if (ix + 1 < resultLength) {
                result[ix + 1] = wrkres[2];
            }
            if (ix + 2 < resultLength) {
                result[ix + 2] = wrkres[3];
            }
            if (ix + 3 < resultLength) {
                result[ix + 3] = wrkres[4];
            }
            ix += 5;
        }
        return result;
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        int bytesLength = bytes.length;
        int padByteQuantity = 4 - bytesLength % 5;
        byte[] wrk = new byte[5];
        byte[] wrkres = new byte[5];
        byte[] result = new byte[bytesLength + padByteQuantity + 1];
        wrk[0] = (byte)padByteQuantity;
        wrk[1] = bytesLength > 0 ? bytes[0] : 39;
        wrk[2] = bytesLength > 1 ? bytes[1] : 39;
        wrk[3] = bytesLength > 2 ? bytes[2] : 39;
        wrk[4] = bytesLength > 3 ? bytes[3] : 39;
        this.transform5Bytes(wrk, wrkres, this.publicKey.getTransformationArray());
        result[0] = wrkres[0];
        result[1] = wrkres[1];
        result[2] = wrkres[2];
        result[3] = wrkres[3];
        result[4] = wrkres[4];
        int ix = 4;
        while (ix <= bytesLength - 5) {
            wrk[0] = bytes[ix];
            wrk[1] = bytes[ix + 1];
            wrk[2] = bytes[ix + 2];
            wrk[3] = bytes[ix + 3];
            wrk[4] = bytes[ix + 4];
            this.transform5Bytes(wrk, wrkres, this.publicKey.getTransformationArray());
            result[ix + 1] = wrkres[0];
            result[ix + 2] = wrkres[1];
            result[ix + 3] = wrkres[2];
            result[ix + 4] = wrkres[3];
            result[ix + 5] = wrkres[4];
            ix += 5;
        }
        if (ix < bytesLength) {
            int saveix = ix + 1;
            wrk[0] = bytes[ix++];
            wrk[1] = ix < bytesLength ? bytes[ix++] : 39;
            wrk[2] = ix < bytesLength ? bytes[ix++] : 39;
            wrk[3] = ix < bytesLength ? bytes[ix++] : 39;
            wrk[4] = ix < bytesLength ? bytes[ix++] : 39;
            this.transform5Bytes(wrk, wrkres, this.publicKey.getTransformationArray());
            result[saveix++] = wrkres[0];
            result[saveix++] = wrkres[1];
            result[saveix++] = wrkres[2];
            result[saveix++] = wrkres[3];
            result[saveix++] = wrkres[4];
        }
        return result;
    }

    @Override
    public String getAlgorithm() {
        return "SPE";
    }

    @Override
    public void setPrivateAndPublicKey(ProprietaryOrJCECipherCallbackObject callbackObject) {
        LinkedList<Integer> l = new LinkedList<Integer>();
        int i = 0;
        while (i < 1024) {
            l.addLast(new Integer(i++));
        }
        LinkedList<Integer> forward = new LinkedList<Integer>();
        int[] backward = new int[1024];
        while (l.size() > 0) {
            int r = (int)(Math.random() * (double)l.size());
            Integer n = (Integer)l.get(r);
            l.remove(r);
            forward.addLast(n);
            backward[n.intValue()] = forward.size() - 1;
        }
        this.privateKey = new SPEKey(backward);
        this.publicKey = new SPEKey(forward);
    }

    @Override
    public void getPublishedKey(DataInputStream in) throws IOException {
        int[] forward = new int[1024];
        int c = 0;
        while (c < 1024) {
            short n = in.readShort();
            forward[c++] = n;
        }
        this.publicKey = new SPEKey(forward);
        int[] backward = new int[1024];
        c = 0;
        while (c < 1024) {
            short n = in.readShort();
            backward[c++] = n;
        }
        this.privateKey = new SPEKey(backward);
    }

    @Override
    public void publishKey(DataOutputStream outputStream) throws IOException {
        int[] publicTransformationArray = this.publicKey.getTransformationArray();
        int ix = 0;
        while (ix < publicTransformationArray.length) {
            outputStream.writeShort(publicTransformationArray[ix]);
            ++ix;
        }
        int[] privateTransformationArray = this.privateKey.getTransformationArray();
        int ix2 = 0;
        while (ix2 < privateTransformationArray.length) {
            outputStream.writeShort(privateTransformationArray[ix2]);
            ++ix2;
        }
    }
}

