/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.security;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.LinkedList;

public class SPEKey
implements PrivateKey,
PublicKey {
    private static final long serialVersionUID = -1997672767790061208L;
    private byte[] encoded = new byte[2048];
    private int[] transformationArray;

    public SPEKey(int[] transformationArray) {
        this.transformationArray = transformationArray;
        int encodedix = 0;
        int ix = 0;
        while (ix < transformationArray.length) {
            this.encoded[encodedix++] = (byte)((transformationArray[ix] & 0xFF00) >> 8);
            this.encoded[encodedix++] = (byte)(transformationArray[ix] & 0xFF);
            ++ix;
        }
    }

    public SPEKey(LinkedList<Integer> vectorElements) {
        this.transformationArray = new int[1024];
        int ix = 0;
        int encodedix = 0;
        for (Integer I : vectorElements) {
            int i = I;
            this.transformationArray[ix++] = i;
            this.encoded[encodedix++] = (byte)((i & 0xFF00) >> 8);
            this.encoded[encodedix++] = (byte)(i & 0xFF);
        }
    }

    int[] getTransformationArray() {
        return this.transformationArray;
    }

    @Override
    public String getAlgorithm() {
        return "SPE";
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    public String getFormat() {
        return "SPE";
    }
}

