/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.security;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SpsSignatureImplementation
extends SignatureSpi {
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private MessageDigest messageDigestAlgorithm;

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    @Override
    protected void engineInitSign(PrivateKey privKey) throws InvalidKeyException {
        try {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = MessageDigest.getInstance("SPMD");
            } else {
                this.messageDigestAlgorithm.reset();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException();
        }
        if (!(privKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (RSAPrivateKey)privKey;
    }

    @Override
    protected void engineInitVerify(PublicKey pubKey) throws InvalidKeyException {
        try {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = MessageDigest.getInstance("SPMD");
            } else {
                this.messageDigestAlgorithm.reset();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException();
        }
        if (!(pubKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (RSAPublicKey)pubKey;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    @Override
    protected byte[] engineSign() {
        byte[] digestBytes = this.messageDigestAlgorithm.digest();
        BigInteger digest = new BigInteger(digestBytes);
        BigInteger encryptedDigest = digest.modPow(this.privateKey.getPrivateExponent(), this.privateKey.getModulus());
        return encryptedDigest.toByteArray();
    }

    @Override
    protected void engineUpdate(byte b) {
        this.messageDigestAlgorithm.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.messageDigestAlgorithm.update(b, off, len);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        byte[] digestBytes = this.messageDigestAlgorithm.digest();
        BigInteger digest = new BigInteger(digestBytes);
        BigInteger encryptedDigest = new BigInteger(sigBytes);
        BigInteger decryptedDigest = encryptedDigest.modPow(this.publicKey.getPublicExponent(), this.publicKey.getModulus());
        return decryptedDigest.equals(digest);
    }
}

