/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.TupleContainer;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObjectFactory;
import be.SIRAPRISE.client.jsba.SetterMethod;
import be.erwinsmout.MyMessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTupleContainer
implements TupleContainer {
    private Heading heading;

    public AbstractTupleContainer(Heading heading) {
        this.heading = heading;
    }

    @Override
    public final void addTuplesWithHeadingCheck(TupleContainer tupleContainer) {
        for (Tuple tuple : tupleContainer) {
            this.addTupleWithHeadingCheck(tuple);
        }
    }

    @Override
    public final void addTuplesWithoutHeadingCheck(TupleContainer tupleContainer) {
        for (Tuple tuple : tupleContainer) {
            this.addTupleWithoutHeadingCheck(tuple);
        }
    }

    @Override
    public final void addTupleWithHeadingCheck(Tuple tuple) {
        if (!tuple.getHeading().keySet().equals(this.getHeading().keySet())) {
            throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("AbstractRelation.HeadingMismatch"), new Object[]{tuple, this.getHeading().keySet()}));
        }
        this.addTupleWithoutHeadingCheck(tuple);
    }

    @Override
    public abstract void addTupleWithoutHeadingCheck(Tuple var1);

    @Override
    public final Heading getHeading() {
        return this.heading;
    }

    @Override
    public abstract Iterator<Tuple> iterator();

    public final String printBodyEscapedWithBodyHeaderWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithoutTypeNames());
        }
        return sb.append(')').toString();
    }

    public final String printBodyEscapedWithBodyHeaderWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithTypeNames());
        }
        return sb.append(')').toString();
    }

    public final String printBodyEscapedWithoutBodyHeaderWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithoutTypeNames());
        }
        return sb.toString();
    }

    public final String printBodyEscapedWithoutBodyHeaderWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithTypeNames());
        }
        return sb.toString();
    }

    public final String printBodyWithBodyHeaderWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithoutTypeNames());
        }
        return sb.append(')').toString();
    }

    public final String printBodyWithBodyHeaderWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithTypeNames());
        }
        return sb.append(')').toString();
    }

    public final String printBodyWithoutBodyHeaderWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithoutTypeNames());
        }
        return sb.toString();
    }

    public final String printBodyWithoutBodyHeaderWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithTypeNames());
        }
        return sb.toString();
    }

    public final String printBodyXMLWithBodyHeader() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("<Body>");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueXML());
        }
        return sb.append("</Body>").toString();
    }

    public final String printBodyXMLWithoutBodyHeader() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        for (Tuple tuple : this) {
            sb.append(tuple.printValueXML());
        }
        return sb.toString();
    }

    @Override
    public final String printValueEscapedWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("RELATION").append("(").append(this.heading.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithoutTypeNames());
        }
        sb.append("))");
        return sb.toString();
    }

    @Override
    public final String printValueEscapedWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("RELATION").append("(").append(this.heading.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueEscapedWithTypeNames());
        }
        sb.append("))");
        return sb.toString();
    }

    @Override
    public final String printValueWithoutTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("RELATION(").append(this.heading.print()).append("BODY(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithoutTypeNames());
        }
        sb.append("))");
        return sb.toString();
    }

    @Override
    public final String printValueWithTypeNames() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("RELATION").append("(").append(this.heading.print()).append("BODY").append("(");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueWithTypeNames());
        }
        sb.append("))");
        return sb.toString();
    }

    @Override
    public final String printValueXML() {
        StringBuilder sb = new StringBuilder(256 * this.size());
        sb.append("<Relation>").append(this.heading.printXML()).append("<Body>");
        for (Tuple tuple : this) {
            sb.append(tuple.printValueXML());
        }
        sb.append("</Body></Relation>");
        return sb.toString();
    }

    @Override
    public abstract boolean removeTuple(Tuple var1);

    @Override
    public final int removeTuples(TupleContainer tupleContainer) {
        int i = 0;
        for (Tuple tuple : tupleContainer) {
            if (!this.removeTuple(tuple)) continue;
            ++i;
        }
        return i;
    }

    @Override
    public abstract int size();

    @Override
    public final <C> C[] toObjectArray(Class<C> objectClass) throws SettersMissingException, ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return DBObjectFactory.getObjectArray(this, objectClass);
    }

    @Override
    public final <C> C[] toObjectArrayIgnoringMissingSetters(Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return DBObjectFactory.getObjectArrayIgnoringMissingSetters(this, objectClass);
    }

    @Override
    public final <C> Collection<C> toObjectCollection(Class<C> objectClass) throws SettersMissingException, ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return DBObjectFactory.getObjectCollection(this, objectClass);
    }

    @Override
    public final <C> Collection<C> toObjectCollectionIgnoringMissingSetters(Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        DBObjectFactory.getPublicNoArgConstructor(objectClass);
        HashMap<String, SetterMethod> setterMethods = DBObjectFactory.getSetterMethods(objectClass, this.heading);
        ArrayList<C> objects = new ArrayList<C>();
        for (Tuple tuple : this) {
            objects.add(DBObjectFactory.getObject(tuple, objectClass, setterMethods));
        }
        return objects;
    }

    @Override
    public final Map<Class<?>, Object>[] toObjectsArray(Class<?>[] objectClass) throws SettersMissingException, ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return (Map[])this.toObjectsCollection(objectClass).toArray();
    }

    @Override
    public final Collection<Map<Class<?>, Object>> toObjectsCollection(Class<?>[] objectClass) throws SettersMissingException, ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        Set attributeNames = this.getHeading().keySet();
        HashSet unmatchedAttributeNames = new HashSet();
        unmatchedAttributeNames.addAll(attributeNames);
        HashMap processingMap = new HashMap();
        int i = 0;
        while (i < objectClass.length) {
            DBObjectFactory.getPublicNoArgConstructor(objectClass[i]);
            HashMap<String, SetterMethod> setterMethods = DBObjectFactory.getSetterMethods(objectClass[i], this.heading);
            processingMap.put(objectClass[i], setterMethods);
            unmatchedAttributeNames.removeAll(processingMap.keySet());
            ++i;
        }
        if (unmatchedAttributeNames.size() > 0) {
            throw new SettersMissingException(unmatchedAttributeNames.toString());
        }
        ArrayList maps = new ArrayList();
        for (Tuple tuple : this) {
            maps.add(DBObjectFactory.toObjects(tuple, processingMap));
        }
        return maps;
    }

    public final String toString() {
        return this.printValueWithoutTypeNames();
    }
}

