/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.AbstractTuple;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.InsertionOrderRelation;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.NonScalarTypeDeclaration;
import be.SIRAPRISE.client.TypeDeclaration;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.IntersectableHashMap;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.erwinsmout.MyMessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ClientTuple
extends AbstractTuple {
    private IntersectableMap<String, ?> attributeValueMap;
    private HashMap<String, String> unEscapedAttributeValueMap;

    public ClientTuple(IntersectableMap<String, ?> attributeValueMap, Heading heading) {
        super(heading);
        this.attributeValueMap = attributeValueMap;
        for (Map.Entry<String, ?> me : attributeValueMap.entrySet()) {
            String attributeValue = (String)me.getValue();
            try {
                String unEscapedAttributeValue = BracketParser.unMeta(attributeValue);
                if (unEscapedAttributeValue.equals(attributeValue)) continue;
                if (this.unEscapedAttributeValueMap == null) {
                    this.unEscapedAttributeValueMap = new HashMap();
                }
                String attributeName = me.getKey();
                this.unEscapedAttributeValueMap.put(attributeName, unEscapedAttributeValue);
            }
            catch (InvalidEscapedCharacterException e) {
                throw new IllegalArgumentException(String.valueOf(e.getClass().getName()) + " : " + e.getMessage());
            }
            catch (MissingEscapedCharacterException e) {
                throw new IllegalArgumentException(String.valueOf(e.getClass().getName()) + " : " + e.getMessage());
            }
        }
    }

    @Override
    public String escapedValue(String attributeName) {
        return (String)this.attributeValueMap.get(attributeName);
    }

    @Override
    public AbstractRelation rvaValue(String attributeName) {
        LinkedList<String> tupleList;
        Heading heading = this.getHeading();
        TypeDeclaration attributeTypeDeclaration = (TypeDeclaration)heading.get(attributeName);
        if (attributeTypeDeclaration == null || !(attributeTypeDeclaration instanceof NonScalarTypeDeclaration)) {
            throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("ClientTuple.NotNonScalar"), new String[]{attributeName, heading.toString()}));
        }
        NonScalarTypeDeclaration attributeNonScalarTypeDeclaration = (NonScalarTypeDeclaration)attributeTypeDeclaration;
        String escapedStringValue = this.escapedValue(attributeName).trim();
        try {
            NameValueResult x = BracketParser.getNameValueFromEscaped(escapedStringValue, 0);
            if (x.getNameValuePair().getName().equalsIgnoreCase("BODY")) {
                escapedStringValue = x.getNameValuePair().getValue().trim();
            }
        }
        catch (NoClosingBracketException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        try {
            tupleList = BracketParser.createListFromEscaped(escapedStringValue);
        }
        catch (NoClosingBracketException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (NoOpeningBracketException e) {
            throw new RuntimeException(e);
        }
        Heading rvaHeading = attributeNonScalarTypeDeclaration.getHeading();
        InsertionOrderRelation r = new InsertionOrderRelation(rvaHeading);
        for (String tupleValueBody : tupleList) {
            IntersectableHashMap<String, String> m = new IntersectableHashMap<String, String>();
            try {
                int scanned = 0;
                while (scanned < tupleValueBody.length()) {
                    NameValueResult nvr = BracketParser.getNameAndMandatoryValueFromEscaped(tupleValueBody, scanned);
                    String rvaAttributeName = nvr.getNameValuePair().getName();
                    String attributeValue = nvr.getNameValuePair().getValue();
                    scanned = nvr.getNextParsePos();
                    m.put(rvaAttributeName, attributeValue);
                }
            }
            catch (NoClosingBracketException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidEscapedCharacterException e) {
                throw new RuntimeException(e);
            }
            catch (MissingEscapedCharacterException e) {
                throw new RuntimeException(e);
            }
            catch (NoOpeningBracketException e) {
                throw new RuntimeException(e);
            }
            r.addTupleWithHeadingCheck(new ClientTuple(m, rvaHeading));
        }
        return r;
    }

    @Override
    public String value(String attributeName) {
        return this.unEscapedAttributeValueMap == null ? this.escapedValue(attributeName) : (this.unEscapedAttributeValueMap.containsKey(attributeName) ? this.unEscapedAttributeValueMap.get(attributeName) : this.escapedValue(attributeName));
    }

    @Override
    public IntersectableMap<?, ?> values() {
        return this.attributeValueMap;
    }
}

