/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.CommunicationProtocolException;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnectionProperties;
import be.SIRAPRISE.client.DBException;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.DDLCapture;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.IllegalConnectionStateException;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.AuthenticationOKMessage;
import be.SIRAPRISE.messages.AuthenticationOKMessageType;
import be.SIRAPRISE.messages.ClientAuthenticationMessage;
import be.SIRAPRISE.messages.ClientAuthenticationMessageType;
import be.SIRAPRISE.messages.ClientHelloMessage;
import be.SIRAPRISE.messages.ClientHelloMessageType;
import be.SIRAPRISE.messages.CommitRollbackMessage;
import be.SIRAPRISE.messages.CommitRollbackMessageType;
import be.SIRAPRISE.messages.CommittedMessage;
import be.SIRAPRISE.messages.CommittedMessageType;
import be.SIRAPRISE.messages.DmlExecutedMessage;
import be.SIRAPRISE.messages.DmlExecutedMessageType;
import be.SIRAPRISE.messages.EndTransactionMessageType;
import be.SIRAPRISE.messages.ExecuteDMLMessageType;
import be.SIRAPRISE.messages.ExecuteDMLMessageTypesV14;
import be.SIRAPRISE.messages.ServerHelloMessage;
import be.SIRAPRISE.messages.ServerHelloMessageType;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.ServerMessageTypes;
import be.SIRAPRISE.messages.StartSubTransactionMessageType;
import be.SIRAPRISE.messages.StartTransactionMessageType;
import be.SIRAPRISE.messages.TransactionEndedMessage;
import be.SIRAPRISE.messages.TransactionEndedMessageType;
import be.SIRAPRISE.messages.TransactionStartedMessage;
import be.SIRAPRISE.messages.TransactionStartedMessageType;
import be.SIRAPRISE.security.ProprietaryOrJCECipher;
import be.SIRAPRISE.util.MyDataOutputStream;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public abstract class DBConnection {
    private static long defaultConnectionIdleTime;
    private static DDLCapture defaultDDLCapture;
    private static boolean defaultInitialAutoCommitForTransactions;
    private static Set<String> defaultSupportedEncryptionAlgorithmNames;
    private static Set<String> defaultSupportedSignatureAlgorithmNames;
    private static TransactionMode defaultTransactionMode;
    private Set<String> alternativeSigningProtocols;
    private ProprietaryOrJCECipher cryptoProtocol;
    private boolean initialAutoCommitForTransactions;
    private boolean open;
    private Signer signer;
    private Signature signingProtocol;
    private Socket socket;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private Version specificationVersionForServer;
    private DBTransaction transaction;

    static {
        String defaultCipherNameList;
        defaultInitialAutoCommitForTransactions = false;
        defaultSupportedEncryptionAlgorithmNames = new HashSet<String>();
        defaultSupportedSignatureAlgorithmNames = new HashSet<String>();
        Properties dbConnectionProperties = DBConnectionProperties.getInstance();
        String defaultConnectionIdleTime_tx = dbConnectionProperties.getProperty("DEFAULTCONNECTIONIDLETIME");
        if (defaultConnectionIdleTime_tx != null) {
            defaultConnectionIdleTime = Long.parseLong(defaultConnectionIdleTime_tx);
        }
        String defaultInitialAutoCommitForTransactions_tx = dbConnectionProperties.getProperty("DEFAULTAUTOCOMMITFORTRANSACTIONS", "FALSE");
        defaultInitialAutoCommitForTransactions = Boolean.valueOf(defaultInitialAutoCommitForTransactions_tx);
        String defaultTransactionMode_tx = dbConnectionProperties.getProperty("TRANSACTIONSREADONLY", "FALSE");
        defaultTransactionMode = TransactionMode.getTransactionMode(Boolean.valueOf(defaultTransactionMode_tx));
        String defaultDDLCapture_tx = dbConnectionProperties.getProperty("DDLCAPTURE", "FALSE");
        defaultDDLCapture = DDLCapture.getDDLCapture(Boolean.valueOf(defaultDDLCapture_tx));
        String defaultSigningAlgorithmNameList = dbConnectionProperties.getProperty("DEFAULTSIGNATUREALGORITHMNAMES", "SPS, MD5WITHRSA, MD2WITHRSA, SHA1WITHRSA, SHA1WITHDSA");
        if (defaultSigningAlgorithmNameList != null) {
            String[] defaultSigningProtocolNames = defaultSigningAlgorithmNameList.split(",");
            int i = 0;
            while (i < defaultSigningProtocolNames.length) {
                String defaultSigningProtocolName = defaultSigningProtocolNames[i++].trim().toUpperCase();
                try {
                    Signature.getInstance(defaultSigningProtocolName);
                    defaultSupportedSignatureAlgorithmNames.add(defaultSigningProtocolName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
        }
        if ((defaultCipherNameList = dbConnectionProperties.getProperty("DEFAULTENCRYPTIONALGORITHMNAMES", "SPE")) != null) {
            String[] defaultCipherNames = defaultCipherNameList.split(",");
            int i = 0;
            while (i < defaultCipherNames.length) {
                String defaultCipherName;
                if ((defaultCipherName = defaultCipherNames[i++].trim().toUpperCase()).equalsIgnoreCase("SPE")) {
                    defaultSupportedEncryptionAlgorithmNames.add(defaultCipherName);
                    continue;
                }
                try {
                    Cipher.getInstance(defaultCipherName);
                    defaultSupportedEncryptionAlgorithmNames.add(defaultCipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (NoSuchPaddingException noSuchPaddingException) {}
            }
        }
    }

    public static final boolean isDefaultInitialAutoCommitForTransactions() {
        return defaultInitialAutoCommitForTransactions;
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws DBException, IOException, CommunicationProtocolException {
        block12: {
            this.initialAutoCommitForTransactions = false;
            this.open = true;
            this.initialAutoCommitForTransactions = initialAutoCommitForTransactions;
            this.signer = signer;
            this.socket = new Socket(host, port);
            try {
                ClientHelloMessageType clientHelloMessageType;
                this.socket.setKeepAlive(true);
                this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.socketInputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                try {
                    clientHelloMessageType = (ClientHelloMessageType)ServerMessageTypes.getInstance().getServerMessageType(-1413809458);
                }
                catch (NotFoundException e2) {
                    throw new CommunicationProtocolException(Messages.getString("DBConnection.ClientHelloMessagetypeNotFound"), e2);
                }
                ClientHelloMessage clientHelloMessage = clientHelloMessageType.message(signatureAlgorithmNames, encryptionAlgorithmNames, requestConnectionIdleTime, ServerMessageTypes.getInstance().getThisPackagesSiraPriseVersion());
                clientHelloMessage.sendMessage(this.socketOutputStream, null, null, null);
                ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, null, null, null);
                if (!(serverMessage instanceof ServerHelloMessage)) {
                    throw new CommunicationProtocolException(serverMessage.getClass().getName(), ServerHelloMessageType.class.getName());
                }
                ServerHelloMessage serverHelloMessage = (ServerHelloMessage)serverMessage;
                this.signingProtocol = serverHelloMessage.getSigningProtocol();
                this.cryptoProtocol = serverHelloMessage.getCryptoProtocol();
                this.specificationVersionForServer = serverHelloMessage.getVersion();
                this.alternativeSigningProtocols = serverHelloMessage.getAlternativeSigningProtocols();
                Iterator<String> i_alternativeSigningProtocols = this.alternativeSigningProtocols.iterator();
                while (i_alternativeSigningProtocols.hasNext()) {
                    String alternativeSigningProtocolName = i_alternativeSigningProtocols.next();
                    if (defaultSupportedSignatureAlgorithmNames.contains(alternativeSigningProtocolName.toUpperCase())) continue;
                    i_alternativeSigningProtocols.remove();
                }
                if (this.signingProtocol == null) break block12;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    MyDataOutputStream.writeSmallUTF(clientID, new DataOutputStream(byteArrayOutputStream));
                    byte[] signMessage = byteArrayOutputStream.toByteArray();
                    byte[] signature = signer.sign(this.signingProtocol, signMessage);
                    ClientAuthenticationMessageType clientAuthenticationMessageType = (ClientAuthenticationMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(404034958, this.specificationVersionForServer);
                    ClientAuthenticationMessage clientAuthenticationMessage = clientAuthenticationMessageType.message(clientID, signature);
                    clientAuthenticationMessage.sendMessage(this.socketOutputStream, null, null, this.cryptoProtocol);
                }
                catch (Exception e1) {
                    this.closeSockets();
                    throw new CommunicationProtocolException(Messages.getString("DBConnection.SigningFailed"), e1);
                }
                serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
                if (!(serverMessage instanceof AuthenticationOKMessage)) {
                    throw new CommunicationProtocolException(serverMessage.getClass().getName(), AuthenticationOKMessageType.class.getName());
                }
            }
            catch (ErrorMessageException e) {
                this.closeSockets();
                throw new DBException(e);
            }
            catch (RuntimeException e) {
                this.closeSockets();
                throw e;
            }
            catch (IOException e) {
                this.closeSockets();
                throw e;
            }
            catch (CommunicationProtocolException e) {
                this.closeSockets();
                throw e;
            }
        }
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, defaultConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, boolean initialAutoCommitForTransactions, Signer privateKeyProvider) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, initialAutoCommitForTransactions, defaultConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, privateKeyProvider);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, requestConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, defaultConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, Set<String> signatureAlgorithmNames, String clientID, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, signatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, defaultConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, boolean initialAutoCommitForTransactions, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, initialAutoCommitForTransactions, requestConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, boolean initialAutoCommitForTransactions, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, initialAutoCommitForTransactions, defaultConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, boolean initialAutoCommitForTransactions, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, initialAutoCommitForTransactions, defaultConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, long requestConnectionIdleTime, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, requestConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, long requestConnectionIdleTime, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, requestConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, Set<String> encryptionAlgorithmNames, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, defaultConnectionIdleTime, encryptionAlgorithmNames, signer);
    }

    public DBConnection(String host, int port, String clientID, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this(host, port, defaultSupportedSignatureAlgorithmNames, clientID, defaultInitialAutoCommitForTransactions, defaultConnectionIdleTime, defaultSupportedEncryptionAlgorithmNames, signer);
    }

    void closeSockets() {
        if (this.open) {
            try {
                try {
                    this.socketInputStream.close();
                    this.socketOutputStream.close();
                    this.socket.close();
                }
                catch (IOException iOException) {
                    this.open = false;
                    this.socket = null;
                    this.socketInputStream = null;
                    this.socketOutputStream = null;
                    this.cryptoProtocol = null;
                    this.signingProtocol = null;
                    this.signer = null;
                    this.specificationVersionForServer = null;
                }
            }
            finally {
                this.open = false;
                this.socket = null;
                this.socketInputStream = null;
                this.socketOutputStream = null;
                this.cryptoProtocol = null;
                this.signingProtocol = null;
                this.signer = null;
                this.specificationVersionForServer = null;
            }
        }
    }

    /*
     * Loose catch block
     */
    void endAnyTransaction() {
        block11: {
            if (this.transaction != null) {
                try {
                    try {
                        long rootTransactionID = -1L;
                        while (this.transaction != null) {
                            rootTransactionID = this.transaction.getTransactionID();
                            this.transaction = this.transaction.getParentTransaction();
                        }
                        ((EndTransactionMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(-523138475, this.specificationVersionForServer)).message(false, rootTransactionID).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
                    }
                    catch (IOException iOException) {
                        this.transaction = null;
                    }
                    catch (CommunicationProtocolException communicationProtocolException) {
                        this.transaction = null;
                    }
                    catch (NotFoundException notFoundException) {
                        this.transaction = null;
                        break block11;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    this.transaction = null;
                }
            }
        }
    }

    final ProprietaryOrJCECipher getCryptoProtocol() {
        return this.cryptoProtocol;
    }

    final Signer getSigner() {
        return this.signer;
    }

    final Signature getSigningProtocol() {
        return this.signingProtocol;
    }

    final DataOutputStream getSocketOutputStream() {
        return this.socketOutputStream;
    }

    void sendCommitMessage() throws ConnectionClosedException {
        try {
            ((CommitRollbackMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(-1070395000, this.specificationVersionForServer)).message(true, -1L).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof CommittedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), CommittedMessageType.class.getName());
            }
        }
        catch (IOException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (CommunicationProtocolException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (NotFoundException notFoundException) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(new CommunicationProtocolException(-1070395000, this.specificationVersionForServer.getFullVersion()));
        }
        catch (ErrorMessageException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    void sendEndTransactionMessage(boolean commit, long transactionID) throws ConnectionClosedException {
        try {
            try {
                try {
                    ((EndTransactionMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(-523138475, this.specificationVersionForServer)).message(commit, transactionID).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
                }
                catch (NotFoundException v0) {
                    throw new CommunicationProtocolException(-523138475, this.specificationVersionForServer.getFullVersion());
                }
                serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
                if (!(serverMessage instanceof TransactionEndedMessage)) {
                    throw new CommunicationProtocolException(serverMessage.getClass().getName(), TransactionEndedMessageType.class.getName());
                }
                ** GOTO lbl32
            }
            catch (IOException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (CommunicationProtocolException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (ErrorMessageException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
        }
        catch (Throwable var5_7) {
            ** while (this.transaction != null && this.transaction.getTransactionID() != transactionID)
        }
lbl-1000:
        // 1 sources

        {
            this.transaction = this.transaction.getParentTransaction();
            continue;
        }
lbl28:
        // 1 sources

        if (this.transaction != null) {
            this.transaction = this.transaction.getParentTransaction();
        }
        throw var5_7;
lbl-1000:
        // 1 sources

        {
            this.transaction = this.transaction.getParentTransaction();
lbl32:
            // 2 sources

            ** while (this.transaction != null && this.transaction.getTransactionID() != transactionID)
        }
lbl33:
        // 1 sources

        if (this.transaction != null) {
            this.transaction = this.transaction.getParentTransaction();
        }
    }

    void sendRollbackMessage(long transactionID) throws ConnectionClosedException {
        try {
            ((CommitRollbackMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(-1070395000, this.specificationVersionForServer)).message(false, transactionID).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof CommittedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), CommittedMessageType.class.getName());
            }
        }
        catch (IOException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (CommunicationProtocolException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (NotFoundException notFoundException) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(new CommunicationProtocolException(-1070395000, this.specificationVersionForServer.getFullVersion()));
        }
        catch (ErrorMessageException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
    }

    void verifyStateAndSendCommitMessage() throws ConnectionClosedException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoTransaction"));
        }
        if (!this.transaction.isAutoCommit()) {
            this.sendCommitMessage();
        }
    }

    void verifyStateAndSendEndTransactionMessage(boolean commit, long transactionID) throws ConnectionClosedException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoTransaction"));
        }
        this.sendEndTransactionMessage(commit, transactionID);
    }

    AbstractRelation verifyStateAndSendExecDmlCommandMessage(String cmd) throws ConnectionClosedException, ErrorMessageException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoTransaction"));
        }
        try {
            ((ExecuteDMLMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(241094017, this.specificationVersionForServer)).message(cmd).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof DmlExecutedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), DmlExecutedMessageType.class.getName());
            }
            return ((DmlExecutedMessage)serverMessage).getRelation();
        }
        catch (IOException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (CommunicationProtocolException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (NotFoundException notFoundException) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(new CommunicationProtocolException(241094017, this.specificationVersionForServer.getFullVersion()));
        }
        catch (ErrorMessageException e) {
            if (this.specificationVersionForServer.isBefore(Version.ONE_TWO)) {
                this.transaction = null;
            }
            throw e;
        }
    }

    AbstractRelation verifyStateAndSendExecDmlCommandMessage(ServerCommand cmd) throws ConnectionClosedException, ErrorMessageException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoTransaction"));
        }
        try {
            ((ExecuteDMLMessageTypesV14)((Object)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(cmd.getCorrespondingMessagetypeid(), this.specificationVersionForServer))).message(cmd).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof DmlExecutedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), DmlExecutedMessageType.class.getName());
            }
            return ((DmlExecutedMessage)serverMessage).getRelation();
        }
        catch (IOException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (CommunicationProtocolException e) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e);
        }
        catch (NotFoundException notFoundException) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(new CommunicationProtocolException(241094017, this.specificationVersionForServer.getFullVersion()));
        }
        catch (ErrorMessageException e) {
            if (this.specificationVersionForServer.isBefore(Version.ONE_TWO)) {
                this.transaction = null;
            }
            throw e;
        }
    }

    final DBTransaction verifyStateAndSendStartNestedTransactionMessage(boolean autoCommit, TransactionMode transactionMode) throws ConnectionClosedException, ErrorMessageException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoMainTransaction"));
        }
        try {
            ((StartSubTransactionMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(1344375413, this.specificationVersionForServer)).message(transactionMode.isReadOnly(), autoCommit).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof TransactionStartedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), TransactionStartedMessageType.class.getName());
            }
            this.transaction = new DBTransaction(this.transaction, autoCommit, ((TransactionStartedMessage)serverMessage).getTransactionID(), transactionMode);
            return this.transaction;
        }
        catch (IOException e1) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e1);
        }
        catch (CommunicationProtocolException e1) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e1);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("DBConnection.IncompatibleServerVersion"), this.specificationVersionForServer.toString()));
        }
    }

    public abstract void close();

    public void commit() throws ConnectionClosedException {
        this.verifyStateAndSendCommitMessage();
    }

    public AbstractRelation compileAndCacheQuery(String query) throws DBException, ConnectionClosedException {
        return this.execDmlCommand("CACHE " + query);
    }

    public AbstractRelation compileQuery(String query) throws DBException, ConnectionClosedException {
        return this.execDmlCommand("COMPILE " + query);
    }

    public void endTransaction(boolean commit) throws ConnectionClosedException {
        this.verifyStateAndSendEndTransactionMessage(commit, -1L);
    }

    public AbstractRelation execDmlCommand(String cmd) throws DBException, ConnectionClosedException {
        try {
            AbstractRelation result = this.verifyStateAndSendExecDmlCommandMessage(cmd);
            if (!(!this.transaction.isAutoCommit() || cmd.length() > 7 && cmd.substring(0, 8).equalsIgnoreCase("ROLLBACK") || cmd.length() > 5 && cmd.substring(0, 6).equalsIgnoreCase("COMMIT"))) {
                this.sendCommitMessage();
            }
            return result;
        }
        catch (ErrorMessageException e) {
            if (this.specificationVersionForServer.isBefore(Version.ONE_TWO)) {
                this.transaction = null;
            }
            throw new DBException(e);
        }
    }

    public AbstractRelation execDmlCommandAndEndTransaction(String cmd) throws DBException, ConnectionClosedException {
        AbstractRelation r = this.execDmlCommand(cmd);
        this.endTransaction(true);
        return r;
    }

    public AbstractRelation execMultipleStatement(Collection<?> commands) throws DBException, ConnectionClosedException {
        Iterator<?> i_commands = commands.iterator();
        String multipleAssignmentCommand = "";
        while (i_commands.hasNext()) {
            multipleAssignmentCommand = String.valueOf(multipleAssignmentCommand) + "CMD(" + i_commands.next() + ")";
        }
        if (multipleAssignmentCommand.length() > 0) {
            return this.execDmlCommand(multipleAssignmentCommand);
        }
        return null;
    }

    public AbstractRelation execMultipleStatement(String[] commands) throws DBException, ConnectionClosedException {
        int c = commands.length;
        int i = 0;
        if (c > 0) {
            String multipleAssignmentCommand = "";
            while (i < c) {
                multipleAssignmentCommand = String.valueOf(multipleAssignmentCommand) + "CMD(" + commands[i++] + ")";
            }
            return this.execDmlCommand(multipleAssignmentCommand);
        }
        return null;
    }

    public AbstractRelation execMultipleStatementAndEndTransaction(Collection<?> commands) throws DBException, ConnectionClosedException {
        AbstractRelation response = this.execMultipleStatement(commands);
        this.endTransaction(true);
        return response;
    }

    public AbstractRelation execMultipleStatementAndEndTransaction(String[] commands) throws DBException, ConnectionClosedException {
        AbstractRelation response = this.execMultipleStatement(commands);
        this.endTransaction(true);
        return response;
    }

    public AbstractRelation[] execQueries(String[] expression) throws DBException, ConnectionClosedException {
        AbstractRelation[] rsp = new AbstractRelation[expression.length];
        int i = 0;
        while (i < expression.length) {
            rsp[i] = this.execQuery(expression[i]);
            ++i;
        }
        return rsp;
    }

    public AbstractRelation[] execQueriesAndEndTransaction(String[] expression) throws DBException, ConnectionClosedException {
        AbstractRelation[] rsp = this.execQueries(expression);
        this.endTransaction(true);
        return rsp;
    }

    public AbstractRelation execQuery(String expression) throws DBException, ConnectionClosedException {
        return this.execDmlCommand("INQUIRE " + expression);
    }

    public AbstractRelation execQueryAndEndTransaction(String expression) throws DBException, ConnectionClosedException {
        AbstractRelation rsp = this.execQuery(expression);
        this.endTransaction(true);
        return rsp;
    }

    public boolean getDefaultTransactionAutoCommit() {
        return this.initialAutoCommitForTransactions;
    }

    public final Version getSpecificationVersionForServer() {
        return this.specificationVersionForServer;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void rollback() throws DBException, ConnectionClosedException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction == null) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.NoTransaction"));
        }
        if (!this.transaction.isAutoCommit()) {
            ServerMessage serverMessage;
            try {
                CommitRollbackMessageType commitRollbackMessageType = (CommitRollbackMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(-1070395000, this.specificationVersionForServer);
                CommitRollbackMessage commitRollbackMessage = commitRollbackMessageType.message(false);
                commitRollbackMessage.sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            }
            catch (IOException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (CommunicationProtocolException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (NotFoundException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            try {
                serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            }
            catch (IOException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (ErrorMessageException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            catch (CommunicationProtocolException e) {
                this.transaction = null;
                this.closeSockets();
                throw new ConnectionClosedException(e);
            }
            if (!(serverMessage instanceof CommittedMessage)) {
                throw new DBException(MyMessageFormat.format(Messages.getString("DBConnection.UnexpectedMessageType"), new String[]{serverMessage.getClass().getName(), Long.toHexString(531345901L)}));
            }
        }
    }

    public void setDefaultTransactionAutoCommit(boolean autoCommit) {
        this.initialAutoCommitForTransactions = autoCommit;
    }

    public final DBTransaction startTransaction() throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], this.initialAutoCommitForTransactions, defaultTransactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(boolean autoCommit) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], autoCommit, defaultTransactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(boolean autoCommit, DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], autoCommit, defaultTransactionMode, ddlCapture);
    }

    public final DBTransaction startTransaction(boolean autoCommit, TransactionMode transactionMode) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], autoCommit, transactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(boolean autoCommit, TransactionMode transactionMode, DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], autoCommit, transactionMode, ddlCapture);
    }

    public final DBTransaction startTransaction(DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], this.initialAutoCommitForTransactions, defaultTransactionMode, ddlCapture);
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userAuthenticatedByClient, signatureAlgorithm, signature, this.initialAutoCommitForTransactions, defaultTransactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean autoCommit, TransactionMode transactionMode) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userAuthenticatedByClient, signatureAlgorithm, signature, autoCommit, transactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, boolean autoCommit, TransactionMode transactionMode, DDLCapture captureDDL) throws ConnectionClosedException, ErrorMessageException {
        if (!this.open) {
            throw new IllegalConnectionStateException(Messages.getString("DBConnection.Closed"));
        }
        if (this.transaction != null) {
            throw new IllegalConnectionStateException(MyMessageFormat.format(Messages.getString("DBConnection.DuplicateTransaction"), new String[]{this.transaction.toString()}));
        }
        try {
            ((StartTransactionMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(1367873380, this.specificationVersionForServer)).message(userID, userAuthenticatedByClient, signatureAlgorithm, signature, transactionMode.isReadOnly(), autoCommit, captureDDL).sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, this.cryptoProtocol);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, this.cryptoProtocol, null, null);
            if (!(serverMessage instanceof TransactionStartedMessage)) {
                throw new CommunicationProtocolException(serverMessage.getClass().getName(), TransactionStartedMessageType.class.getName());
            }
            this.transaction = new DBTransaction(userID, autoCommit, this, ((TransactionStartedMessage)serverMessage).getTransactionID(), transactionMode);
            return this.transaction;
        }
        catch (IOException e1) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e1);
        }
        catch (CommunicationProtocolException e1) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(e1);
        }
        catch (NotFoundException notFoundException) {
            this.transaction = null;
            this.closeSockets();
            throw new ConnectionClosedException(new CommunicationProtocolException(1367873380, this.specificationVersionForServer.getFullVersion()));
        }
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userAuthenticatedByClient, signatureAlgorithm, signature, this.initialAutoCommitForTransactions, defaultTransactionMode, ddlCapture);
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, TransactionMode transactionMode) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userAuthenticatedByClient, signatureAlgorithm, signature, this.initialAutoCommitForTransactions, transactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(String userID, boolean userAuthenticatedByClient, String signatureAlgorithm, byte[] signature, TransactionMode transactionMode, DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userAuthenticatedByClient, signatureAlgorithm, signature, this.initialAutoCommitForTransactions, transactionMode, ddlCapture);
    }

    public final DBTransaction startTransaction(String userID, Signer userIDSigner) throws DBException, ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userIDSigner, this.initialAutoCommitForTransactions);
    }

    public final DBTransaction startTransaction(String userID, Signer userIDSigner, boolean autoCommit) throws DBException, ConnectionClosedException, ErrorMessageException {
        String signatureAlgorithmName = "";
        byte[] signature = null;
        Iterator<String> i_alternativeSigningProtocols = this.alternativeSigningProtocols.iterator();
        boolean signatureComputed = false;
        while (i_alternativeSigningProtocols.hasNext() & !signatureComputed) {
            signatureAlgorithmName = i_alternativeSigningProtocols.next();
            try {
                Signature signatureAlgorithm = Signature.getInstance(signatureAlgorithmName);
                ByteArrayOutputStream w = new ByteArrayOutputStream();
                MyDataOutputStream.writeSmallUTF(userID, new DataOutputStream(w));
                byte[] signMessage = w.toByteArray();
                signature = userIDSigner.sign(signatureAlgorithm, signMessage);
                signatureComputed = true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeyException invalidKeyException) {
            }
            catch (NotFoundException notFoundException) {
            }
            catch (IOException e) {
                throw new DBException(e);
            }
            catch (SignatureException e) {
                throw new DBException(e);
            }
        }
        if (!signatureComputed) {
            throw new DBException(MyMessageFormat.format(Messages.getString("DBConnection.UserIdentitySigningFailed"), new Object[]{this.alternativeSigningProtocols}));
        }
        return this.startTransaction(userID, false, signatureAlgorithmName, signature, autoCommit, defaultTransactionMode);
    }

    public final DBTransaction startTransaction(String userID, Signer userIDSigner, boolean autoCommit, TransactionMode transactionMode) throws DBException, ConnectionClosedException, ErrorMessageException {
        String signatureAlgorithmName = "";
        byte[] signature = null;
        Iterator<String> i_alternativeSigningProtocols = this.alternativeSigningProtocols.iterator();
        boolean signatureComputed = false;
        while (i_alternativeSigningProtocols.hasNext() & !signatureComputed) {
            signatureAlgorithmName = i_alternativeSigningProtocols.next();
            try {
                Signature signatureAlgorithm = Signature.getInstance(signatureAlgorithmName);
                ByteArrayOutputStream w = new ByteArrayOutputStream();
                MyDataOutputStream.writeSmallUTF(userID, new DataOutputStream(w));
                byte[] signMessage = w.toByteArray();
                signature = userIDSigner.sign(signatureAlgorithm, signMessage);
                signatureComputed = true;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeyException invalidKeyException) {
            }
            catch (NotFoundException notFoundException) {
            }
            catch (IOException e) {
                throw new DBException(e);
            }
            catch (SignatureException e) {
                throw new DBException(e);
            }
        }
        if (!signatureComputed) {
            throw new DBException(MyMessageFormat.format(Messages.getString("DBConnection.UserIdentitySigningFailed"), new Object[]{this.alternativeSigningProtocols}));
        }
        return this.startTransaction(userID, false, signatureAlgorithmName, signature, autoCommit, transactionMode);
    }

    public final DBTransaction startTransaction(String userID, Signer userIDSigner, TransactionMode transactionMode) throws DBException, ConnectionClosedException, ErrorMessageException {
        return this.startTransaction(userID, userIDSigner, transactionMode);
    }

    public final DBTransaction startTransaction(TransactionMode transactionMode) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], this.initialAutoCommitForTransactions, transactionMode, defaultDDLCapture);
    }

    public final DBTransaction startTransaction(TransactionMode transactionMode, DDLCapture ddlCapture) throws ConnectionClosedException, ErrorMessageException {
        return this.startTransaction("", false, "", new byte[0], this.initialAutoCommitForTransactions, transactionMode, ddlCapture);
    }
}

