/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DmlAddCommand;
import be.SIRAPRISE.client.DmlAssertCommand;
import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.DmlCommand;
import be.SIRAPRISE.client.DmlDeleteCommand;
import be.SIRAPRISE.client.DmlUnassertCommand;
import be.SIRAPRISE.client.DmlUpdateCommand;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.IllegalTransactionStateException;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import java.util.Collection;

public class DBTransaction {
    private boolean autoCommit;
    private DBConnection dbConnection;
    private DBTransaction nestedTransaction;
    private DBTransaction parentTransaction;
    private long transactionID;
    private TransactionMode transactionMode;
    private String userID;

    DBTransaction(DBTransaction parentTransaction, boolean autoCommit, long transactionID, TransactionMode transactionMode) {
        this.parentTransaction = parentTransaction;
        this.userID = parentTransaction.userID;
        this.dbConnection = parentTransaction.dbConnection;
        this.autoCommit = autoCommit;
        this.transactionID = transactionID;
        this.transactionMode = transactionMode;
    }

    DBTransaction(String userID, boolean autoCommit, DBConnection dbConnection, long transactionID, TransactionMode transactionMode) {
        this.userID = userID;
        this.autoCommit = autoCommit;
        this.dbConnection = dbConnection;
        this.transactionID = transactionID;
        this.transactionMode = transactionMode;
    }

    private void checkConnectionPresent() {
        if (this.dbConnection == null) {
            throw new IllegalTransactionStateException();
        }
    }

    private AbstractRelation execDmlCommandWithoutConnectionCheck(ServerCommand serverCommand) throws ConnectionClosedException, ErrorMessageException {
        try {
            return this.dbConnection.verifyStateAndSendExecDmlCommandMessage(serverCommand);
        }
        catch (ConnectionClosedException e) {
            this.dbConnection = null;
            throw e;
        }
    }

    private AbstractRelation execDmlCommandWithoutConnectionCheck(String cmd) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.dbConnection.verifyStateAndSendExecDmlCommandMessage(cmd);
            if (!(!this.autoCommit || !this.dbConnection.getSpecificationVersionForServer().isBefore(Version.ONE_TWO) || cmd.length() > 7 && cmd.substring(0, 8).equalsIgnoreCase("ROLLBACK") || cmd.length() > 5 && cmd.substring(0, 6).equalsIgnoreCase("COMMIT"))) {
                this.dbConnection.sendCommitMessage();
            }
            return result;
        }
        catch (ConnectionClosedException e) {
            this.dbConnection = null;
            throw e;
        }
        catch (ErrorMessageException e) {
            if (this.dbConnection.getSpecificationVersionForServer().isBefore(Version.ONE_TWO)) {
                this.dbConnection = null;
            }
            throw e;
        }
    }

    public final void commit() throws ConnectionClosedException {
        this.checkConnectionPresent();
        if (!this.autoCommit || this.dbConnection.getSpecificationVersionForServer().isBefore(Version.ONE_TWO)) {
            try {
                this.dbConnection.verifyStateAndSendCommitMessage();
            }
            catch (ConnectionClosedException e) {
                this.dbConnection = null;
                throw e;
            }
        }
    }

    public final AbstractRelation compileAndCacheQuery(String query) throws ConnectionClosedException, ErrorMessageException {
        return this.execDmlCommand("CACHE " + query);
    }

    public final AbstractRelation compileQuery(String query) throws ConnectionClosedException, ErrorMessageException {
        return this.execDmlCommand("COMPILE " + query);
    }

    public final void dbAdd(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        this.execDmlCommand(this.dbAddCommand(relvarName, o));
    }

    public final void dbAddAndEndTransaction(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.dbAdd(relvarName, o);
            this.end(true);
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DmlAddCommand dbAddCommand(String relvarName, DBObject o) {
        return new DmlAddCommand(relvarName, o);
    }

    public final void dbAssert(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        this.execDmlCommand(this.dbAssertCommand(relvarName, o));
    }

    public final void dbAssertAndEndTransaction(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.dbAssert(relvarName, o);
            this.end(true);
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DmlAssertCommand dbAssertCommand(String relvarName, DBObject o) {
        return new DmlAssertCommand(relvarName, o);
    }

    public final void dbDelete(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        this.execDmlCommand(this.dbDeleteCommand(relvarName, o));
    }

    public final void dbDeleteAndEndTransaction(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.dbDelete(relvarName, o);
            this.end(true);
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DmlDeleteCommand dbDeleteCommand(String relvarName, DBObject o) {
        return new DmlDeleteCommand(relvarName, o);
    }

    public final void dbUnAssert(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        this.execDmlCommand(this.dbUnAssertCommand(relvarName, o));
    }

    public final void dbUnAssertAndEndTransaction(String relvarName, DBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.dbUnAssert(relvarName, o);
            this.end(true);
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DmlUnassertCommand dbUnAssertCommand(String relvarName, DBObject o) {
        return new DmlUnassertCommand(relvarName, o);
    }

    public final void dbUpdate(String relvarName, UpdatableDBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.execDmlCommand(this.dbUpdateCommand(relvarName, o));
        }
        catch (NoUpdatesException noUpdatesException) {}
    }

    public final void dbUpdateAndEndTransaction(String relvarName, UpdatableDBObject o) throws ConnectionClosedException, ErrorMessageException {
        try {
            this.dbUpdate(relvarName, o);
            this.end(true);
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DmlUpdateCommand dbUpdateCommand(String relvarName, UpdatableDBObject o) throws NoUpdatesException {
        return new DmlUpdateCommand(relvarName, o);
    }

    public final void end(boolean commit) throws ConnectionClosedException {
        this.checkConnectionPresent();
        try {
            this.dbConnection.verifyStateAndSendEndTransactionMessage(commit, this.transactionID);
        }
        finally {
            this.dbConnection = null;
        }
    }

    public final AbstractRelation execDmlCommand(DmlCommand command) throws ConnectionClosedException, ErrorMessageException {
        this.checkConnectionPresent();
        AbstractRelation result = this.dbConnection.getSpecificationVersionForServer().isBefore(Version.ONE_FOUR) ? this.execDmlCommandWithoutConnectionCheck(command.getCommand()) : this.execDmlCommand(command.getServerCommand());
        command.success();
        return result;
    }

    public final AbstractRelation execDmlCommand(ServerCommand serverCommand) throws ConnectionClosedException, ErrorMessageException {
        this.checkConnectionPresent();
        return this.execDmlCommandWithoutConnectionCheck(serverCommand);
    }

    public final AbstractRelation execDmlCommand(String cmd) throws ConnectionClosedException, ErrorMessageException {
        this.checkConnectionPresent();
        return this.execDmlCommandWithoutConnectionCheck(cmd);
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(DmlCommand command) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execDmlCommand(command.getCommand());
            command.success();
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(ServerCommand serverCommand) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execDmlCommand(serverCommand);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execDmlCommandAndEndTransaction(String cmd) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execDmlCommand(cmd);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execMultipleStatement(Collection<? extends Object> commands) throws ConnectionClosedException, ErrorMessageException {
        boolean feedback = true;
        String multipleAssignmentCommand = "";
        for (Object object : commands) {
            if (!(object instanceof DmlCommand)) {
                feedback = false;
            }
            multipleAssignmentCommand = String.valueOf(multipleAssignmentCommand) + "CMD(" + object + ")";
        }
        if (multipleAssignmentCommand.length() > 0) {
            AbstractRelation abstractRelation = this.execDmlCommand(multipleAssignmentCommand);
            if (feedback) {
                for (DmlCommand dmlCommand : commands) {
                    dmlCommand.success();
                }
            }
            return abstractRelation;
        }
        return null;
    }

    public final AbstractRelation execMultipleStatement(DmlAssignmentCommand[] commands) throws ConnectionClosedException, ErrorMessageException {
        int c = commands.length;
        int i = 0;
        if (c > 0) {
            String multipleAssignmentCommand = "";
            while (i < c) {
                multipleAssignmentCommand = String.valueOf(multipleAssignmentCommand) + "CMD(" + commands[i++].getCommand() + ")";
            }
            AbstractRelation result = this.execDmlCommand(multipleAssignmentCommand);
            DmlAssignmentCommand[] dmlAssignmentCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                DmlAssignmentCommand command = dmlAssignmentCommandArray[n2];
                command.success();
                ++n2;
            }
            return result;
        }
        return null;
    }

    public final AbstractRelation execMultipleStatement(String[] commands) throws ConnectionClosedException, ErrorMessageException {
        int c = commands.length;
        int i = 0;
        if (c > 0) {
            String multipleAssignmentCommand = "";
            while (i < c) {
                multipleAssignmentCommand = String.valueOf(multipleAssignmentCommand) + "CMD(" + commands[i++] + ")";
            }
            return this.execDmlCommand(multipleAssignmentCommand);
        }
        return null;
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(Collection<? extends Object> commands) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execMultipleStatement(commands);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(DmlAssignmentCommand[] commands) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execMultipleStatement(commands);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execMultipleStatementAndEndTransaction(String[] commands) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execMultipleStatement(commands);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation[] execQueries(String[] expression) throws ConnectionClosedException, ErrorMessageException {
        AbstractRelation[] rsp = new AbstractRelation[expression.length];
        int i = 0;
        StringBuilder cmd = new StringBuilder("EXTEND(TABLE_DEE,(");
        i = 0;
        while (i < expression.length) {
            cmd.append(Integer.toString(i)).append('(').append(expression[i]).append(')');
            ++i;
        }
        cmd.append(')').append(')');
        AbstractRelation r = this.execQuery(cmd.toString());
        i = 0;
        while (i < expression.length) {
            rsp[i] = r.iterator().next().rvaValue(Integer.toString(i));
            ++i;
        }
        return rsp;
    }

    public final AbstractRelation[] execQueriesAndEndTransaction(String[] expression) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation[] result = this.execQueries(expression);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final AbstractRelation execQuery(String expression) throws ConnectionClosedException, ErrorMessageException {
        return this.execDmlCommand("INQUIRE " + expression);
    }

    public final AbstractRelation execQueryAndEndTransaction(String expression) throws ConnectionClosedException, ErrorMessageException {
        try {
            AbstractRelation result = this.execQuery(expression);
            this.end(true);
            return result;
        }
        catch (ErrorMessageException e) {
            this.end(false);
            throw e;
        }
        catch (RuntimeException e) {
            this.end(false);
            throw e;
        }
        catch (Error e) {
            this.end(false);
            throw e;
        }
    }

    public final DBTransaction getParentTransaction() {
        return this.parentTransaction;
    }

    public final long getTransactionID() {
        return this.transactionID;
    }

    public final boolean isAutoCommit() {
        return this.autoCommit;
    }

    public final boolean isReadOnly() {
        return this.transactionMode.isReadOnly();
    }

    public final void rollback() throws ConnectionClosedException {
        this.checkConnectionPresent();
        if (!this.autoCommit) {
            try {
                this.dbConnection.sendRollbackMessage(this.transactionID);
            }
            catch (ConnectionClosedException e) {
                this.dbConnection = null;
                throw e;
            }
        }
    }

    public final DBTransaction savePoint() throws ErrorMessageException, ConnectionClosedException {
        return this.startNestedTransaction(this.autoCommit, this.isReadOnly());
    }

    public final DBTransaction startNestedTransaction(boolean newAutoCommit, boolean readOnly) throws ErrorMessageException, ConnectionClosedException {
        if (this.nestedTransaction == null) {
            try {
                this.nestedTransaction = this.dbConnection.verifyStateAndSendStartNestedTransactionMessage(newAutoCommit, TransactionMode.getTransactionMode(readOnly));
                return this.nestedTransaction;
            }
            catch (ConnectionClosedException e) {
                this.dbConnection = null;
                throw e;
            }
        }
        return this.nestedTransaction.startNestedTransaction(newAutoCommit, readOnly);
    }

    public String toString() {
        return "Transaction " + super.toString() + "with server-side ID " + this.transactionID + " owned by " + this.userID + "on " + this.dbConnection;
    }
}

