/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.DmlAssignmentCommand;
import be.SIRAPRISE.client.jsba.GetterMethodCache;
import be.SIRAPRISE.client.jsba.JSBAMethodInvoker;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class DmlSingleAssignmentCommand
extends DmlAssignmentCommand {
    private Map<String, JSBAMethodInvoker> getterMethods = new HashMap<String, JSBAMethodInvoker>();
    private String relationText;
    private String relvarName;
    private UpdatableDBObject updatableObject;

    public DmlSingleAssignmentCommand(String relvarName, Object o) {
        if (relvarName == null || relvarName.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.relvarName = String.valueOf(Character.toUpperCase(relvarName.charAt(0))) + relvarName.substring(1).toLowerCase();
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (o instanceof UpdatableDBObject) {
            this.updatableObject = (UpdatableDBObject)o;
        }
        this.getterMethods = GetterMethodCache.getInstance().getGetterMethods(o.getClass(), this.relvarName);
        StringBuilder relation = new StringBuilder(String.valueOf(relvarName.toUpperCase()) + "(TUPLE(");
        for (Map.Entry<String, JSBAMethodInvoker> me : this.getterMethods.entrySet()) {
            try {
                relation.append(me.getKey()).append('(').append(me.getValue().invoke(o, null)).append(')');
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        relation.append(')').append(')');
        this.relationText = relation.toString();
    }

    final Map<String, JSBAMethodInvoker> getGetterMethods() {
        return this.getterMethods;
    }

    @Override
    final void success() {
        if (this.updatableObject != null) {
            this.updatableObject.setPreUpdateState();
        }
    }

    public final String getRelationText() {
        return this.relationText;
    }

    public final String getRelvarName() {
        return this.relvarName;
    }
}

