/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.DmlSingleAssignmentCommand;
import be.SIRAPRISE.client.NoUpdatesException;
import be.SIRAPRISE.client.ServerCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.client.jsba.JSBAMethodInvoker;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public final class DmlUpdateCommand
extends DmlSingleAssignmentCommand {
    public static final byte ASSIGNMENTTYPE = 3;
    private String command;
    private String updatedTuple;
    private String updateList;

    public DmlUpdateCommand(String relvarName, UpdatableDBObject o) throws NoUpdatesException {
        super(relvarName, o);
        StringBuilder updatedTupleBuilder = new StringBuilder(String.valueOf(relvarName.toUpperCase()) + "(TUPLE(");
        StringBuilder updateListBuilder = new StringBuilder();
        UpdatableDBObject oldO = o.getPreUpdateState();
        if (oldO == null || oldO.getClass() != o.getClass() || o == oldO) {
            throw new IllegalArgumentException();
        }
        Map<String, JSBAMethodInvoker> getterMethods = this.getGetterMethods();
        boolean anyUpdates = false;
        for (Map.Entry<String, JSBAMethodInvoker> me : getterMethods.entrySet()) {
            String newObjectAttributeValue;
            String oldObjectAttributeValue;
            String attributeName = me.getKey();
            JSBAMethodInvoker attributeGetterMethod = me.getValue();
            try {
                oldObjectAttributeValue = attributeGetterMethod.invoke(oldO, null);
                newObjectAttributeValue = attributeGetterMethod.invoke(o, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            updatedTupleBuilder.append(attributeName).append('(').append(oldObjectAttributeValue).append(')');
            if (oldObjectAttributeValue.equals(newObjectAttributeValue)) continue;
            updateListBuilder.append(attributeName).append('(').append(newObjectAttributeValue).append(')');
            anyUpdates = true;
        }
        updatedTupleBuilder.append("))");
        if (!anyUpdates) {
            throw new NoUpdatesException();
        }
        this.updatedTuple = updatedTupleBuilder.toString();
        this.updateList = updateListBuilder.toString();
    }

    @Override
    public String getCommand() {
        if (this.command == null) {
            this.command = "UPDATE " + this.getRelvarName() + ',' + this.updatedTuple + ',' + '(' + this.updateList + ')';
        }
        return this.command;
    }

    @Override
    public ServerCommand getServerCommand() {
        return new ServerUpdateCommand(this.getRelvarName(), this.updatedTuple, this.updateList);
    }

    public String toString() {
        return this.getCommand();
    }
}

