/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.Version;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EntityRefs {
    private static final Version FOUR_NIL = new Version(4, 0);
    private static HashMap<String, String> html20Map;
    private static HashMap<String, String> html32Map;
    private static HashMap<String, String> html40Map;
    private static Version THREE_TWO;
    private static Version TWO_NIL;
    private static HashMap<String, String> xhtml10Map;

    static {
        THREE_TWO = new Version(3, 2);
        TWO_NIL = new Version(2, 0);
        html20Map = new HashMap();
        html20Map.put("&quot;", "U+0022");
        html20Map.put("&amp;", "U+0026");
        html20Map.put("&lt;", "U+003C");
        html20Map.put("&gt;", "U+003E");
        html20Map.put("&Agrave;", "U+00C0");
        html20Map.put("&Aacute;", "U+00C1");
        html20Map.put("&Acirc;", "U+00C2");
        html20Map.put("&Atilde;", "U+00C3");
        html20Map.put("&Auml;", "U+00C4");
        html20Map.put("&Aring;", "U+00C5");
        html20Map.put("&AElig;", "U+00C6");
        html20Map.put("&Ccedil;", "U+00C7");
        html20Map.put("&Egrave;", "U+00C8");
        html20Map.put("&Eacute;", "U+00C9");
        html20Map.put("&Ecirc;", "U+00CA");
        html20Map.put("&Euml;", "U+00CB");
        html20Map.put("&Igrave;", "U+00CC");
        html20Map.put("&Iacute;", "U+00CD");
        html20Map.put("&Icirc;", "U+00CE");
        html20Map.put("&Iuml;", "U+00CF");
        html20Map.put("&ETH;", "U+00D0");
        html20Map.put("&Ntilde;", "U+00D1");
        html20Map.put("&Ograve;", "U+00D2");
        html20Map.put("&Oacute;", "U+00D3");
        html20Map.put("&Ocirc;", "U+00D4");
        html20Map.put("&Otilde;", "U+00D5");
        html20Map.put("&Ouml;", "U+00D6");
        html20Map.put("&Oslash;", "U+00D8");
        html20Map.put("&Ugrave;", "U+00D9");
        html20Map.put("&Uacute;", "U+00DA");
        html20Map.put("&Ucirc;", "U+00DB");
        html20Map.put("&Uuml;", "U+00DC");
        html20Map.put("&Yacute;", "U+00DD");
        html20Map.put("&THORN;", "U+00DE");
        html20Map.put("&szlig;", "U+00DF");
        html20Map.put("&agrave;", "U+00E0");
        html20Map.put("&aacute;", "U+00E1");
        html20Map.put("&acirc;", "U+00E2");
        html20Map.put("&atilde;", "U+00E3");
        html20Map.put("&auml;", "U+00E4");
        html20Map.put("&aring;", "U+00E5");
        html20Map.put("&aelig;", "U+00E6");
        html20Map.put("&ccedil;", "U+00E7");
        html20Map.put("&egrave;", "U+00E8");
        html20Map.put("&eacute;", "U+00E9");
        html20Map.put("&ecirc;", "U+00EA");
        html20Map.put("&euml;", "U+00EB");
        html20Map.put("&igrave;", "U+00EC");
        html20Map.put("&iacute;", "U+00ED");
        html20Map.put("&icirc;", "U+00EE");
        html20Map.put("&iuml;", "U+00EF");
        html20Map.put("&eth;", "U+00F0");
        html20Map.put("&ntilde;", "U+00F1");
        html20Map.put("&ograve;", "U+00F2");
        html20Map.put("&oacute;", "U+00F3");
        html20Map.put("&ocirc;", "U+00F4");
        html20Map.put("&otilde;", "U+00F5");
        html20Map.put("&ouml;", "U+00F6");
        html20Map.put("&oslash;", "U+00F8");
        html20Map.put("&ugrave;", "U+00F9");
        html20Map.put("&uacute;", "U+00FA");
        html20Map.put("&ucirc;", "U+00FB");
        html20Map.put("&uuml;", "U+00FC");
        html20Map.put("&yacute;", "U+00FD");
        html20Map.put("&thorn;", "U+00FE");
        html20Map.put("&yuml;", "U+00FF");
        html32Map = new HashMap();
        html32Map.put("&Otimes;", "U+00D7");
        html32Map.put("&divide;", "U+00F7");
        html32Map.put("&nbsp;", "U+00A0");
        html32Map.put("&iexcl;", "U+00A1");
        html32Map.put("&cent;", "U+00A2");
        html32Map.put("&pound;", "U+00A3");
        html32Map.put("&curren;", "U+00A4");
        html32Map.put("&yen;", "U+00A5");
        html32Map.put("&brvbar;", "U+00A6");
        html32Map.put("&sect;", "U+00A7");
        html32Map.put("&uml;", "U+00A8");
        html32Map.put("&copy;", "U+00A9");
        html32Map.put("&ordf;", "U+00AA");
        html32Map.put("&laquo;", "U+00AB");
        html32Map.put("&not;", "U+00AC");
        html32Map.put("&shy;", "U+00AD");
        html32Map.put("&reg;", "U+00AE");
        html32Map.put("&macr;", "U+00AF");
        html32Map.put("&deg;", "U+00B0");
        html32Map.put("&plusmn;", "U+00B1");
        html32Map.put("&sup2;", "U+00B2");
        html32Map.put("&sup3;", "U+00B3");
        html32Map.put("&acute;", "U+00B4");
        html32Map.put("&micro;", "U+00B5");
        html32Map.put("&para;", "U+00B6");
        html32Map.put("&middot;", "U+00B7");
        html32Map.put("&cedil;", "U+00B8");
        html32Map.put("&sup1;", "U+00B9");
        html32Map.put("&ordm;", "U+00BA");
        html32Map.put("&raquo;", "U+00BB");
        html32Map.put("&frac14;", "U+00BC");
        html32Map.put("&frac12;", "U+00BD");
        html32Map.put("&frac34;", "U+00BE");
        html32Map.put("&iquest;", "U+00BF");
        html40Map = new HashMap();
        html40Map.put("&OElig;", "U+0152");
        html40Map.put("&oelig;", "U+0153");
        html40Map.put("&Scaron;", "U+0160");
        html40Map.put("&scaron;", "U+0161");
        html40Map.put("&Yuml;", "U+0178");
        html40Map.put("&fnof;", "U+0192");
        html40Map.put("&circ;", "U+02C6");
        html40Map.put("&tilde;", "U+02DC");
        html40Map.put("&Alpha;", "U+0391");
        html40Map.put("&Beta;", "U+0392");
        html40Map.put("&Gamma;", "U+0393");
        html40Map.put("&Delta;", "U+0394");
        html40Map.put("&Epsilon;", "U+0395");
        html40Map.put("&Zeta;", "U+0396");
        html40Map.put("&Eta;", "U+0397");
        html40Map.put("&Theta;", "U+0398");
        html40Map.put("&Iota;", "U+0399");
        html40Map.put("&Kappa;", "U+039A");
        html40Map.put("&Lambda;", "U+039B");
        html40Map.put("&Mu;", "U+039C");
        html40Map.put("&Nu;", "U+039D");
        html40Map.put("&Xi;", "U+039E");
        html40Map.put("&Omicron;", "U+039F");
        html40Map.put("&Pi;", "U+03A0");
        html40Map.put("&Rho;", "U+03A1");
        html40Map.put("&Sigma;", "U+03A3");
        html40Map.put("&Tau;", "U+03A4");
        html40Map.put("&Upsilon;", "U+03A5");
        html40Map.put("&Phi;", "U+03A6");
        html40Map.put("&Chi;", "U+03A7");
        html40Map.put("&Psi;", "U+03A8");
        html40Map.put("&Omega;", "U+03A9");
        html40Map.put("&alpha;", "U+03B1");
        html40Map.put("&beta;", "U+03B2");
        html40Map.put("&gamma;", "U+03B3");
        html40Map.put("&delta;", "U+03B4");
        html40Map.put("&epsilon;", "U+03B5");
        html40Map.put("&zeta;", "U+03B6");
        html40Map.put("&eta;", "U+03B7");
        html40Map.put("&theta;", "U+03B8");
        html40Map.put("&iota;", "U+03B9");
        html40Map.put("&kappa;", "U+03BA");
        html40Map.put("&lambda;", "U+03BB");
        html40Map.put("&mu;", "U+03BC");
        html40Map.put("&nu;", "U+03BD");
        html40Map.put("&xi;", "U+03BE");
        html40Map.put("&omicron;", "U+03BF");
        html40Map.put("&pi;", "U+03C0");
        html40Map.put("&rho;", "U+03C1");
        html40Map.put("&sigmaf;", "U+03C2");
        html40Map.put("&sigma;", "U+03C3");
        html40Map.put("&tau;", "U+03C4");
        html40Map.put("&upsilon;", "U+03C5");
        html40Map.put("&phi;", "U+03C6");
        html40Map.put("&chi;", "U+03C7");
        html40Map.put("&psi;", "U+03C8");
        html40Map.put("&omega;", "U+03C9");
        html40Map.put("&thetasym;", "U+03D1");
        html40Map.put("&upsih;", "U+03D2");
        html40Map.put("&piv;", "U+03D6");
        html40Map.put("&ensp;", "U+2002");
        html40Map.put("&emsp;", "U+2003");
        html40Map.put("&thinsp;", "U+2009");
        html40Map.put("&zwnj;", "U+200C");
        html40Map.put("&zwj;", "U+200D");
        html40Map.put("&lrm;", "U+200E");
        html40Map.put("&rlm;", "U+200F");
        html40Map.put("&ndash;", "U+2013");
        html40Map.put("&mdash;", "U+2014");
        html40Map.put("&lsquo;", "U+2018");
        html40Map.put("&rsquo;", "U+2019");
        html40Map.put("&sbquo;", "U+201A");
        html40Map.put("&ldquo;", "U+201C");
        html40Map.put("&rdquo;", "U+201D");
        html40Map.put("&bdquo;", "U+201E");
        html40Map.put("&dagger;", "U+2020");
        html40Map.put("&Dagger;", "U+2021");
        html40Map.put("&bull;", "U+2022");
        html40Map.put("&hellip;", "U+2026");
        html40Map.put("&permil;", "U+2030");
        html40Map.put("&prime;", "U+2040");
        html40Map.put("&Prime;", "U+2033");
        html40Map.put("&lsaquo;", "U+2039");
        html40Map.put("&rsaquo;", "U+203A");
        html40Map.put("&oline;", "U+203E");
        html40Map.put("&frasl;", "U+2044");
        html40Map.put("&euro;", "U+20AC");
        html40Map.put("&image;", "U+2111");
        html40Map.put("&weierp;", "U+2118");
        html40Map.put("&real;", "U+211C");
        html40Map.put("&trade;", "U+2122");
        html40Map.put("&alefsym;", "U+2135");
        html40Map.put("&larr;", "U+2190");
        html40Map.put("&uarr;", "U+2191");
        html40Map.put("&rarr;", "U+2192");
        html40Map.put("&darr;", "U+2193");
        html40Map.put("&harr;", "U+2194");
        html40Map.put("&crarr;", "U+21B5");
        html40Map.put("&lArr;", "U+21D0");
        html40Map.put("&uArr;", "U+21D1");
        html40Map.put("&rArr;", "U+21D2");
        html40Map.put("&dArr;", "U+21D3");
        html40Map.put("&hArr;", "U+21D4");
        html40Map.put("&forall;", "U+2200");
        html40Map.put("&part;", "U+2202");
        html40Map.put("&exist;", "U+2203");
        html40Map.put("&empty;", "U+2205");
        html40Map.put("&nabla;", "U+2207");
        html40Map.put("&isin;", "U+2208");
        html40Map.put("&notin;", "U+2209");
        html40Map.put("&ni;", "U+220B");
        html40Map.put("&prod;", "U+220F");
        html40Map.put("&sum;", "U+2211");
        html40Map.put("&minus;", "U+2212");
        html40Map.put("&lowast;", "U+2217");
        html40Map.put("&radic;", "U+221A");
        html40Map.put("&prop;", "U+221D");
        html40Map.put("&infin;", "U+221E");
        html40Map.put("&ang;", "U+2220");
        html40Map.put("&and;", "U+2227");
        html40Map.put("&or;", "U+2228");
        html40Map.put("&cap;", "U+2229");
        html40Map.put("&cup;", "U+222A");
        html40Map.put("&int;", "U+222B");
        html40Map.put("&there4;", "U+2234");
        html40Map.put("&sim;", "U+223C");
        html40Map.put("&cong;", "U+2245");
        html40Map.put("&asymp;", "U+2248");
        html40Map.put("&ne;", "U+2260");
        html40Map.put("&equiv;", "U+2261");
        html40Map.put("&le;", "U+2264");
        html40Map.put("&ge;", "U+2265");
        html40Map.put("&sub;", "U+2282");
        html40Map.put("&sup;", "U+2283");
        html40Map.put("&nsub;", "U+2284");
        html40Map.put("&sube;", "U+2286");
        html40Map.put("&supe;", "U+2287");
        html40Map.put("&oplus;", "U+2295");
        html40Map.put("&otimes;", "U+2297");
        html40Map.put("&perp;", "U+22A5");
        html40Map.put("&sdot;", "U+22C5");
        html40Map.put("&lceil;", "U+2308");
        html40Map.put("&rceil;", "U+2309");
        html40Map.put("&lfloor;", "U+230A");
        html40Map.put("&rfloor;", "U+230B");
        html40Map.put("&lang;", "U+2329");
        html40Map.put("&rang;", "U+232A");
        html40Map.put("&loz;", "U+25CA");
        html40Map.put("&spades;", "U+2660");
        html40Map.put("&clubs;", "U+2663");
        html40Map.put("&hearts;", "U+2665");
        html40Map.put("&diams;", "U+2666");
        xhtml10Map = new HashMap();
        xhtml10Map.put("&apos;", "U+0027");
    }

    private static StringBuilder applyMap(HashMap<String, String> htmlMap, StringBuilder stringBuilder) {
        int p = 0;
        while (p < stringBuilder.length()) {
            if (stringBuilder.charAt(p) == '&') {
                boolean matched = false;
                Iterator<Map.Entry<String, String>> i_htmlMap = htmlMap.entrySet().iterator();
                while (i_htmlMap.hasNext() && !matched) {
                    Map.Entry<String, String> me = i_htmlMap.next();
                    String entityRefSyntax = me.getKey();
                    String entityRefValue = me.getValue();
                    if (!stringBuilder.substring(p, p + entityRefSyntax.length()).equals(entityRefSyntax)) continue;
                    stringBuilder.replace(p, p + entityRefSyntax.length(), entityRefValue);
                    matched = true;
                }
            }
            ++p;
        }
        return stringBuilder;
    }

    private static StringBuilder applyNumerals(StringBuilder string) {
        int p = 0;
        int sLength = string.length();
        while (p < sLength - 1) {
            if (string.charAt(p) == '&' && string.charAt(p + 1) == '#') {
                boolean hexmode;
                int e = p + 2;
                if (e < sLength && string.charAt(e) == 'x') {
                    hexmode = true;
                    ++e;
                } else {
                    hexmode = false;
                }
                StringBuilder numeral = new StringBuilder(16);
                while (e < sLength && string.charAt(e) != ';') {
                    numeral.append(string.charAt(e++));
                }
                ++e;
                int number = hexmode ? Integer.parseInt(numeral.toString(), 16) : Integer.parseInt(numeral.toString());
                if (Character.isValidCodePoint(number)) {
                    string.delete(p, e);
                    string.insert(p, Character.valueOf((char)number));
                }
            }
            ++p;
        }
        return string;
    }

    public static String fromHtml(String string, Version htmlVersion) {
        if (htmlVersion.equals(FOUR_NIL)) {
            return EntityRefs.applyMap(html40Map, new StringBuilder(EntityRefs.fromHtml(string, THREE_TWO))).toString();
        }
        if (htmlVersion.equals(THREE_TWO)) {
            return EntityRefs.applyMap(html32Map, new StringBuilder(EntityRefs.fromHtml(string, TWO_NIL))).toString();
        }
        if (htmlVersion.equals(TWO_NIL)) {
            return EntityRefs.applyMap(html20Map, EntityRefs.applyNumerals(new StringBuilder(string))).toString();
        }
        return string;
    }

    public static String fromXHtml(String string, Version xhtmlVersion) {
        if (xhtmlVersion.equals(Version.ONE_ZERO)) {
            return EntityRefs.applyMap(xhtml10Map, new StringBuilder(EntityRefs.fromHtml(string, FOUR_NIL))).toString();
        }
        return string;
    }

    public static String toXML(String string) {
        int length = string.length();
        StringBuilder w = new StringBuilder(length + length >>> 3);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i++);
            switch (c) {
                case '<': {
                    w.append("&lt;");
                    break;
                }
                case '>': {
                    w.append("&gt;");
                    break;
                }
                case '&': {
                    w.append("&amp;");
                    break;
                }
                case '\"': {
                    w.append("&quot;");
                    break;
                }
                case '\'': {
                    w.append("&apos;");
                    break;
                }
                default: {
                    w.append(c);
                }
            }
        }
        return w.toString();
    }

    private EntityRefs() {
    }
}

