/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.DuplicateException;
import be.SIRAPRISE.client.NonScalarTypeDeclaration;
import be.SIRAPRISE.client.ScalarTypeDeclaration;
import be.SIRAPRISE.client.TypeDeclaration;
import be.SIRAPRISE.client.TypeIsScalarException;
import be.SIRAPRISE.util.IntersectableLinkedHashMap;
import be.SIRAPRISE.util.IntersectableMap;
import be.SIRAPRISE.util.MyDataOutputStream;
import be.erwinsmout.NotFoundException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class Heading
extends IntersectableLinkedHashMap<String, TypeDeclaration> {
    @Override
    protected IntersectableMap<String, TypeDeclaration> getClone() {
        Heading h = new Heading();
        h.putAll(this);
        return h;
    }

    public final void add(String attributeName, Heading heading) throws DuplicateException {
        this.add(attributeName, new NonScalarTypeDeclaration(heading));
    }

    public final void add(String attributeName, String typeName) throws DuplicateException {
        this.add(attributeName, new ScalarTypeDeclaration(typeName));
    }

    public final void add(String attributeName, TypeDeclaration typeDeclaration) throws DuplicateException {
        if (this.containsKey(attributeName)) {
            throw new DuplicateException(attributeName);
        }
        this.put(attributeName, typeDeclaration);
    }

    public final Set<String> getAttributeNames() {
        return this.keySet();
    }

    public final Heading getHeading(String attributeName) throws NotFoundException, TypeIsScalarException {
        if (this.containsKey(attributeName)) {
            return ((TypeDeclaration)this.get(attributeName)).getHeading();
        }
        throw new NotFoundException(attributeName);
    }

    public final String getTypeName(String attributeName) throws NotFoundException {
        if (this.containsKey(attributeName)) {
            return ((TypeDeclaration)this.get(attributeName)).getTypeName();
        }
        throw new NotFoundException(attributeName);
    }

    public final boolean isStrictUnionCompatibleWith(Heading other) {
        if (this.keySet().equals(other.keySet())) {
            for (String attributeName : this.keySet()) {
                try {
                    if (this.getTypeName(attributeName).equals(other.getTypeName(attributeName))) continue;
                    return false;
                }
                catch (NotFoundException impossible) {
                    throw new RuntimeException(impossible);
                }
            }
            return true;
        }
        return false;
    }

    public final String print() {
        StringBuilder sb = new StringBuilder(60 * this.size());
        sb.append("HEADING(");
        for (Map.Entry me : this.entrySet()) {
            String attributeName = (String)me.getKey();
            String typeName = ((TypeDeclaration)me.getValue()).getTypeName();
            sb.append(attributeName).append('(').append(typeName);
            if (typeName.equalsIgnoreCase("RELATION")) {
                try {
                    sb.append('(').append(this.getHeading(attributeName).print()).append(')');
                }
                catch (NotFoundException impossible) {
                    throw new RuntimeException(impossible);
                }
                catch (TypeIsScalarException impossible) {
                    throw new RuntimeException(impossible);
                }
            }
            sb.append(')');
        }
        sb.append(')');
        return sb.toString();
    }

    public final String printXML() {
        StringBuilder sb = new StringBuilder(60 * this.size());
        sb.append("<Heading>");
        for (Map.Entry me : this.entrySet()) {
            String attributeName = (String)me.getKey();
            String typeName = ((TypeDeclaration)me.getValue()).getTypeName();
            sb.append('<').append(attributeName).append('>');
            if (typeName.equalsIgnoreCase("RELATION")) {
                try {
                    sb.append("<Relation>").append(this.getHeading(attributeName).printXML()).append("</Relation>");
                }
                catch (NotFoundException impossible) {
                    throw new RuntimeException(impossible);
                }
                catch (TypeIsScalarException impossible) {
                    throw new RuntimeException(impossible);
                }
            } else {
                sb.append(typeName);
            }
            sb.append("</").append(attributeName).append('>');
        }
        sb.append("</Heading>");
        return sb.toString();
    }

    public final Heading subHeadingExcluding(Set<String> attributeNames) {
        Heading newHeadingType;
        try {
            newHeadingType = (Heading)this.minus(attributeNames, Heading.class);
        }
        catch (InstantiationException impossible) {
            throw new RuntimeException(impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new RuntimeException(impossible);
        }
        return newHeadingType;
    }

    public final Heading subHeadingIncluding(Set<String> attributeNames) {
        Heading newHeadingType;
        try {
            newHeadingType = (Heading)this.intersect(attributeNames, Heading.class);
        }
        catch (InstantiationException impossible) {
            throw new RuntimeException(impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new RuntimeException(impossible);
        }
        return newHeadingType;
    }

    public final void toStream1_0(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.size());
        for (Map.Entry me : this.entrySet()) {
            String attributeName = (String)me.getKey();
            String typeName = ((TypeDeclaration)me.getValue()).getTypeName();
            MyDataOutputStream.writeSmallUTF(attributeName, outputStream);
            MyDataOutputStream.writeSmallUTF(typeName, outputStream);
            if (!typeName.equalsIgnoreCase("RELATION")) continue;
            try {
                this.getHeading(attributeName).toStream1_0(outputStream);
            }
            catch (NotFoundException impossible) {
                throw new RuntimeException(impossible);
            }
            catch (TypeIsScalarException impossible) {
                throw new RuntimeException(impossible);
            }
        }
    }
}

