/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.CommunicationProtocolException;
import be.SIRAPRISE.client.DBException;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.messages.AuthenticationOKMessage;
import be.SIRAPRISE.messages.AuthenticationOKMessageType;
import be.SIRAPRISE.messages.ClientAuthenticationMessage;
import be.SIRAPRISE.messages.ClientAuthenticationMessageType;
import be.SIRAPRISE.messages.ClientHelloMessage;
import be.SIRAPRISE.messages.ClientHelloMessageType;
import be.SIRAPRISE.messages.DmlExecutedMessage;
import be.SIRAPRISE.messages.EndConnectionMessageType;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessage;
import be.SIRAPRISE.messages.ExecuteMonitorCommandMessageType;
import be.SIRAPRISE.messages.ServerHelloMessage;
import be.SIRAPRISE.messages.ServerHelloMessageType;
import be.SIRAPRISE.messages.ServerMessage;
import be.SIRAPRISE.messages.ServerMessageTypes;
import be.SIRAPRISE.util.MyDataOutputStream;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class MonitorConnection {
    private Set<String> alternativeSigningProtocols;
    private Signer signer;
    private Signature signingProtocol;
    private Socket socket;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private Version specificationVersionForServer;

    public MonitorConnection(InetAddress netAddress, int monitorPort) throws CommunicationProtocolException, IOException, DBException {
        this(netAddress, monitorPort, new HashSet<String>(), "", null);
    }

    public MonitorConnection(InetAddress netAddress, int monitorPort, Set<String> signatureAlgorithmNames, String clientID, Signer signer) throws CommunicationProtocolException, IOException, DBException {
        this.signer = signer;
        this.socket = new Socket(netAddress, monitorPort);
        this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.socketInputStream = new DataInputStream(this.socket.getInputStream());
        this.handShake(signatureAlgorithmNames, clientID);
    }

    public MonitorConnection(String host, int monitorPort) throws IOException, CommunicationProtocolException, DBException {
        this(host, monitorPort, new HashSet<String>(), "", null);
    }

    public MonitorConnection(String host, int monitorPort, Set<String> signatureAlgorithmNames, String clientID, Signer signer) throws IOException, CommunicationProtocolException, DBException {
        this.signer = signer;
        this.socket = new Socket(host, monitorPort);
        this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.socketInputStream = new DataInputStream(this.socket.getInputStream());
        this.handShake(signatureAlgorithmNames, clientID);
    }

    private void closeSockets() {
        try {
            this.socketInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.socketOutputStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    private void handShake(Set<String> signatureAlgorithmNames, String clientID) throws CommunicationProtocolException, IOException, DBException {
        block8: {
            ClientHelloMessageType clientHelloMessageType;
            try {
                clientHelloMessageType = (ClientHelloMessageType)ServerMessageTypes.getInstance().getServerMessageType(-1413809458);
            }
            catch (NotFoundException e2) {
                throw new CommunicationProtocolException(Messages.getString("DBConnection.ClientHelloMessagetypeNotFound"), e2);
            }
            ClientHelloMessage clientHelloMessage = clientHelloMessageType.message(signatureAlgorithmNames, new HashSet<String>(), 0L, ServerMessageTypes.getInstance().getThisPackagesSiraPriseVersion());
            clientHelloMessage.sendMessage(this.socketOutputStream, null, null, null);
            try {
                ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, null, null, null);
                if (!(serverMessage instanceof ServerHelloMessage)) {
                    throw new CommunicationProtocolException(serverMessage.getClass().getName(), ServerHelloMessageType.class.getName());
                }
                ServerHelloMessage serverHelloMessage = (ServerHelloMessage)serverMessage;
                this.signingProtocol = serverHelloMessage.getSigningProtocol();
                this.specificationVersionForServer = serverHelloMessage.getVersion();
                this.alternativeSigningProtocols = serverHelloMessage.getAlternativeSigningProtocols();
                if (this.signingProtocol == null) break block8;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    MyDataOutputStream.writeSmallUTF(clientID, new DataOutputStream(byteArrayOutputStream));
                    byte[] signMessage = byteArrayOutputStream.toByteArray();
                    byte[] signature = this.signer.sign(this.signingProtocol, signMessage);
                    ClientAuthenticationMessageType clientAuthenticationMessageType = (ClientAuthenticationMessageType)ServerMessageTypes.getInstance().getServerMessageTypeForSiraPriseVersion(404034958, this.specificationVersionForServer);
                    ClientAuthenticationMessage clientAuthenticationMessage = clientAuthenticationMessageType.message(clientID, signature);
                    clientAuthenticationMessage.sendMessage(this.socketOutputStream, null, null, null);
                }
                catch (Exception e1) {
                    this.closeSockets();
                    throw new CommunicationProtocolException(Messages.getString("DBConnection.SigningFailed"), e1);
                }
                serverMessage = ServerMessage.readMessage(this.socketInputStream, null, null, null);
                if (!(serverMessage instanceof AuthenticationOKMessage)) {
                    throw new CommunicationProtocolException(serverMessage.getClass().getName(), AuthenticationOKMessageType.class.getName());
                }
            }
            catch (ErrorMessageException e) {
                this.closeSockets();
                throw new DBException(e);
            }
        }
    }

    public void end() throws DBException {
        try {
            try {
                ((EndConnectionMessageType)ServerMessageTypes.getInstance().getServerMessageType(238927923)).message().sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, null);
            }
            catch (IOException e) {
                throw new DBException(e);
            }
            catch (NotFoundException e) {
                throw new DBException(e);
            }
            catch (CommunicationProtocolException e) {
                throw new DBException(e);
            }
        }
        finally {
            this.closeSockets();
        }
    }

    public AbstractRelation execCommand(String command, String userID, Signer userIDSigner, boolean userIDAuthenticatedByClient) throws DBException {
        String signatureAlgorithmName = "";
        byte[] signature = new byte[]{};
        if (userID.length() > 0 && userIDSigner != null) {
            Iterator<String> i_alternativeSigningProtocols = this.alternativeSigningProtocols.iterator();
            boolean signatureComputed = false;
            while (i_alternativeSigningProtocols.hasNext() & !signatureComputed) {
                signatureAlgorithmName = i_alternativeSigningProtocols.next();
                try {
                    Signature signatureAlgorithm = Signature.getInstance(signatureAlgorithmName);
                    ByteArrayOutputStream w = new ByteArrayOutputStream();
                    MyDataOutputStream.writeSmallUTF(userID, new DataOutputStream(w));
                    byte[] signMessage = w.toByteArray();
                    signature = userIDSigner.sign(signatureAlgorithm, signMessage);
                    signatureComputed = true;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (InvalidKeyException invalidKeyException) {
                }
                catch (NotFoundException notFoundException) {
                }
                catch (IOException e) {
                    throw new DBException(e);
                }
                catch (SignatureException e) {
                    throw new DBException(e);
                }
            }
            if (!signatureComputed) {
                signatureAlgorithmName = "";
            }
        }
        try {
            ExecuteMonitorCommandMessageType executeMonitorCommandMessageType = (ExecuteMonitorCommandMessageType)ServerMessageTypes.getInstance().getServerMessageType(241092620);
            ExecuteMonitorCommandMessage executeMonitorCommandMessage = executeMonitorCommandMessageType.message(command, signature, signatureAlgorithmName, userIDAuthenticatedByClient, userID);
            executeMonitorCommandMessage.sendMessage(this.socketOutputStream, this.signingProtocol, this.signer, null);
            ServerMessage serverMessage = ServerMessage.readMessage(this.socketInputStream, null, null, null);
            if (!(serverMessage instanceof DmlExecutedMessage)) {
                throw new DBException(MyMessageFormat.format(Messages.getString("DBConnection.UnexpectedMessageType"), new String[]{serverMessage.getClass().getName(), Long.toHexString(531345901L)}));
            }
            AbstractRelation abstractRelation = ((DmlExecutedMessage)serverMessage).getRelation();
            return abstractRelation;
        }
        catch (IOException e) {
            throw new DBException(e);
        }
        catch (NotFoundException e) {
            throw new DBException(e);
        }
        catch (CommunicationProtocolException e) {
            throw new DBException(e);
        }
        catch (ErrorMessageException e) {
            throw new DBException(e);
        }
        finally {
            this.closeSockets();
        }
    }
}

