/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBConnectionProperties;
import be.SIRAPRISE.client.DBException;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.OneShotDBConnection;
import be.SIRAPRISE.client.ProcessScriptProperties;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.client.TransactionMode;
import be.SIRAPRISE.client.Version;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.CRLFInputStream;
import be.SIRAPRISE.util.CommandLineParameters;
import be.SIRAPRISE.util.MyKeyStore;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.UserPrivateKeyProvider;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class ProcessScript
implements Runnable,
Signer {
    public static final String CLIENTID = "SIRAPRISESCRIPTPROCESSOR";
    public static final String FILE = "FILE";
    public static final String OUTFILE = "OUTFILE";
    public static final String SCRIPTSDIRECTORY = "SCRIPTSDIRECTORY";
    public static final String SPS = ".SPS";
    static final String OUTPUTDIRECTORY = "OUTPUTDIRECTORY";
    private Set<String> cryptoAlgorithmNames;
    private CRLFInputStream fin;
    private String host;
    private PrintWriter out;
    private int port;
    private Set<String> signingAlgorithmNames;
    private LinkedList<DBTransaction> transactionChain = new LinkedList();
    private HashMap<String, DBTransaction> transactionsByName = new HashMap();
    private String user;

    private static String getCommand(CRLFInputStream fin, Charset charSet) throws IOException {
        String cmd = "|>";
        while (cmd.endsWith("|>")) {
            String t = fin.readLine(charSet);
            if (t == null) {
                if (cmd.length() < 3) {
                    throw new EOFException();
                }
                throw new IOException(Messages.getString("ProcessScript.ExpectedContinuationNotFound"));
            }
            cmd = String.valueOf(cmd.substring(0, cmd.length() - 2).trim()) + t;
        }
        return cmd;
    }

    private static SetContent getSetContent(String string) {
        String w = string;
        String host = null;
        String port = null;
        String user = null;
        try {
            while (w.length() > 0) {
                NameValueResult result = BracketParser.getNameValueFromNonEscaped(w, 0);
                NameValuePair nameValuePair = result.getNameValuePair();
                String name = nameValuePair.getName();
                w = w.substring(result.getNextParsePos());
                if (name.equalsIgnoreCase("HOST")) {
                    host = nameValuePair.getValue();
                    continue;
                }
                if (name.equalsIgnoreCase("PORT")) {
                    port = nameValuePair.getValue();
                    continue;
                }
                if (name.equalsIgnoreCase("USER")) {
                    user = nameValuePair.getValue();
                    continue;
                }
                throw new RuntimeException("Invalid keyword " + name);
            }
        }
        catch (NoClosingBracketException noClosingBracketException) {
            throw new RuntimeException("Invalid syntax " + w);
        }
        return new SetContent(host, port, user);
    }

    public static void main(String[] args) throws IOException {
        new ProcessScript(args).run();
    }

    ProcessScript(String[] args) throws IOException {
        String outputDirectoryName;
        CommandLineParameters commandLineParameters = CommandLineParameters.getCommandLineParameters(args, FILE, ProcessScriptProperties.getInstance());
        String scriptFileName = commandLineParameters.getProperty(FILE);
        if (scriptFileName == null) {
            System.out.println(Messages.getString("ProcessScript.FilenameRequired"));
            BufferedReader conin = new BufferedReader(new InputStreamReader(System.in));
            scriptFileName = conin.readLine();
        }
        this.user = commandLineParameters.getProperty("USER", "");
        this.host = commandLineParameters.getProperty("HOST", "127.0.0.1");
        this.port = Integer.parseInt(commandLineParameters.getProperty("PORT", "50000"));
        String baseScriptFileName = !scriptFileName.toUpperCase().endsWith(SPS) ? String.valueOf(scriptFileName) + SPS : scriptFileName;
        String fullScriptFileName = baseScriptFileName;
        File scriptFile = null;
        while (this.fin == null) {
            scriptFile = new File(fullScriptFileName);
            try {
                this.fin = new CRLFInputStream(new BufferedInputStream(new FileInputStream(scriptFile)));
            }
            catch (FileNotFoundException e) {
                if (scriptFile.isAbsolute() || fullScriptFileName.charAt(0) == File.separatorChar) {
                    throw e;
                }
                String scriptsDirectory = commandLineParameters.getProperty(SCRIPTSDIRECTORY);
                if (scriptsDirectory == null) {
                    throw e;
                }
                if (!scriptsDirectory.endsWith(File.separator)) {
                    scriptsDirectory = String.valueOf(scriptsDirectory) + File.separatorChar;
                }
                fullScriptFileName = String.valueOf(scriptsDirectory) + fullScriptFileName;
            }
        }
        String outputFileName = commandLineParameters.getProperty(OUTFILE);
        if (outputFileName == null) {
            outputFileName = String.valueOf(baseScriptFileName) + ".out.txt";
        }
        if ((outputDirectoryName = commandLineParameters.getProperty(OUTPUTDIRECTORY)) != null) {
            File outputDirectory = new File(outputDirectoryName);
            if (!outputDirectory.isAbsolute() && outputDirectoryName.charAt(0) != File.separatorChar) {
                outputDirectoryName = String.valueOf(File.separatorChar) + outputDirectoryName;
            }
            if (outputDirectory.exists()) {
                if (!outputDirectory.isDirectory()) {
                    throw new FileNotFoundException(String.valueOf(outputDirectoryName) + Messages.getString("RunAllScripts.NotADirectory"));
                }
            } else {
                outputDirectory.mkdirs();
            }
            outputFileName = new File(outputFileName).isAbsolute() || outputFileName.charAt(0) == File.separatorChar ? String.valueOf(outputDirectoryName) + File.separatorChar + new File(outputFileName).getName() : String.valueOf(outputDirectoryName) + File.separatorChar + outputFileName;
            new File(outputFileName).getParentFile().mkdirs();
        } else if (!new File(outputFileName).isAbsolute() && outputFileName.charAt(0) != File.separatorChar) {
            outputFileName = String.valueOf(scriptFile.getParentFile().getAbsolutePath()) + File.separatorChar + outputFileName;
        }
        this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(outputFileName)));
        String signingAlgorithmNameList = commandLineParameters.getProperty("SIGNINGALGORITHMS");
        if (signingAlgorithmNameList == null) {
            signingAlgorithmNameList = commandLineParameters.getProperty("SIGNINGALGORITHMS", "");
        }
        this.signingAlgorithmNames = DBConnectionProperties.getSigningAlgorithmNameSet(signingAlgorithmNameList);
        String cryptoAlgorithmNameList = commandLineParameters.getProperty("CRYPTOALGORITHMS");
        if (cryptoAlgorithmNameList == null) {
            cryptoAlgorithmNameList = commandLineParameters.getProperty("CRYPTOALGORITHMS", "");
        }
        this.cryptoAlgorithmNames = DBConnectionProperties.getCryptoAlgorithmNameSet(cryptoAlgorithmNameList);
    }

    private PrivateKey getPrivateKey(String algorithm) throws NotFoundException {
        try {
            KeyStore jks = MyKeyStore.getKeyStore(this.getClass());
            return (PrivateKey)jks.getKey(CLIENTID + algorithm, this.getClass().getSimpleName().toCharArray());
        }
        catch (KeyStoreException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (CertificateException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (IOException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (UnrecoverableKeyException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    private DBTransaction startNestedTransaction(DBTransaction transaction, boolean autoCommit, boolean readOnlyTransaction, String transactionSymbolicName) throws ConnectionClosedException, ErrorMessageException {
        if (this.transactionsByName.containsKey(transactionSymbolicName)) {
            throw new IllegalArgumentException("Duplicate transaction name " + transactionSymbolicName);
        }
        DBTransaction startedTransaction = transaction.startNestedTransaction(autoCommit, readOnlyTransaction);
        this.transactionChain.addLast(startedTransaction);
        this.transactionsByName.put(transactionSymbolicName, startedTransaction);
        return startedTransaction;
    }

    private DBTransaction startTransaction(DBConnection dbc, boolean autoCommit, boolean readOnlyTransaction, String transactionSymbolicName, String explicitTransactionUser) throws DBException, ConnectionClosedException, ErrorMessageException {
        DBTransaction startedTransaction;
        String transactionUser;
        String string = transactionUser = explicitTransactionUser == null ? this.user : explicitTransactionUser;
        if (transactionUser.length() > 0) {
            try {
                UserPrivateKeyProvider userPrivateKeyProvider = new UserPrivateKeyProvider(transactionUser);
                startedTransaction = dbc.startTransaction(transactionUser, userPrivateKeyProvider, autoCommit, TransactionMode.getTransactionMode(readOnlyTransaction));
            }
            catch (NotFoundException notFoundException) {
                this.out.println(String.valueOf(Messages.getString("ProcessScript.WarningTag")) + MyMessageFormat.format(Messages.getString("ProcessScript.UserNotAuthenticable"), new String[]{transactionUser}));
                startedTransaction = dbc.startTransaction(autoCommit, TransactionMode.getTransactionMode(readOnlyTransaction));
            }
        } else {
            startedTransaction = dbc.startTransaction(autoCommit, TransactionMode.getTransactionMode(readOnlyTransaction));
        }
        this.transactionChain.addLast(startedTransaction);
        this.transactionsByName.put(transactionSymbolicName, startedTransaction);
        return startedTransaction;
    }

    @Override
    public void run() {
        block69: {
            Charset charSet = Charset.defaultCharset();
            String replyprompt = Messages.getString("ProcessScript.ReplyPrompt");
            try {
                try {
                    OneShotDBConnection dbc = new OneShotDBConnection(this.host, this.port, this.signingAlgorithmNames, CLIENTID, this.cryptoAlgorithmNames, (Signer)this);
                    try {
                        boolean serverVersionBeforeONE_TWO = dbc.getSpecificationVersionForServer().isBefore(Version.ONE_TWO);
                        if (serverVersionBeforeONE_TWO) {
                            this.startTransaction(dbc, false, false, "", null);
                        }
                        boolean proceed = true;
                        do {
                            try {
                                String cmd = ProcessScript.getCommand(this.fin, charSet);
                                if (cmd.startsWith("* ")) {
                                    this.out.println(String.valueOf(Messages.getString("ProcessScript.CommentTag")) + cmd.substring(2));
                                    String w = cmd.substring(2).trim();
                                    if (!w.toUpperCase().startsWith("CHARSET=")) continue;
                                    charSet = Charset.forName(w.substring(8).trim());
                                    continue;
                                }
                                if (cmd.length() > 0) {
                                    String reply;
                                    block67: {
                                        DBTransaction transaction;
                                        String transactionSymbolicName;
                                        String transactionSymbolicName2;
                                        String cmdContent;
                                        this.out.println(String.valueOf(Messages.getString("ProcessScript.RequestTag")) + cmd);
                                        cmd = cmd.trim();
                                        if (cmd.toUpperCase().startsWith("SET ")) {
                                            SetContent setContent = ProcessScript.getSetContent(cmd.substring(4).trim());
                                            this.host = setContent.getHost() == null ? this.host : setContent.getHost();
                                            this.port = setContent.getPort() == null ? this.port : Integer.parseInt(setContent.getPort());
                                            this.user = setContent.getUser() == null ? this.user : setContent.getUser();
                                        }
                                        boolean readOnlyTransaction = false;
                                        boolean autoCommit = false;
                                        if (cmd.toUpperCase().startsWith("STARTTRANSACTION ")) {
                                            if (serverVersionBeforeONE_TWO) continue;
                                            cmdContent = cmd.substring(17).trim().toUpperCase();
                                            int i = cmdContent.indexOf(44);
                                            transactionSymbolicName2 = null;
                                            if (i >= 0) {
                                                transactionSymbolicName2 = cmdContent.substring(0, i).trim();
                                                cmdContent = cmdContent.substring(i + 1).trim();
                                            } else {
                                                transactionSymbolicName2 = cmdContent.trim();
                                                cmdContent = "";
                                            }
                                            String explicitTransactionUser = null;
                                            while (cmdContent.length() > 0) {
                                                String optionValue;
                                                i = cmdContent.indexOf(44);
                                                if (i >= 0) {
                                                    optionValue = cmdContent.substring(0, i).trim();
                                                    cmdContent = cmdContent.substring(i + 1).trim();
                                                } else {
                                                    optionValue = cmdContent;
                                                    cmdContent = "";
                                                }
                                                if (optionValue.equals("READONLY")) {
                                                    readOnlyTransaction = true;
                                                    continue;
                                                }
                                                if (optionValue.equals("AUTOCOMMIT")) {
                                                    autoCommit = true;
                                                    continue;
                                                }
                                                if (optionValue.startsWith("USER")) {
                                                    NameValueResult result = BracketParser.getNameValueFromNonEscaped(optionValue, 0);
                                                    explicitTransactionUser = result.getNameValuePair().getValue();
                                                    continue;
                                                }
                                                throw new IllegalArgumentException(optionValue);
                                            }
                                            this.startTransaction(dbc, autoCommit, readOnlyTransaction, transactionSymbolicName2, explicitTransactionUser);
                                            this.out.println(replyprompt);
                                            continue;
                                        }
                                        if (cmd.toUpperCase().startsWith("STARTNESTEDTRANSACTION ")) {
                                            if (serverVersionBeforeONE_TWO) {
                                                throw new UnsupportedOperationException(Messages.getString("ProcessScript.NestedTransactionsWithPre12Server"));
                                            }
                                            cmdContent = cmd.substring(22).trim().toUpperCase();
                                            int i = cmdContent.indexOf(44);
                                            transactionSymbolicName2 = null;
                                            if (i >= 0) {
                                                transactionSymbolicName2 = cmdContent.substring(0, i).trim();
                                                cmdContent = cmdContent.substring(i + 1).trim();
                                            } else {
                                                transactionSymbolicName2 = cmdContent.trim();
                                                cmdContent = "";
                                            }
                                            while (cmdContent.length() > 0) {
                                                String optionValue;
                                                i = cmdContent.indexOf(44);
                                                if (i >= 0) {
                                                    optionValue = cmdContent.substring(0, i).trim();
                                                    cmdContent = cmdContent.substring(i + 1).trim();
                                                } else {
                                                    optionValue = cmdContent;
                                                    cmdContent = "";
                                                }
                                                if (optionValue.equals("READONLY")) {
                                                    readOnlyTransaction = true;
                                                    continue;
                                                }
                                                if (optionValue.equals("AUTOCOMMIT")) {
                                                    autoCommit = true;
                                                    continue;
                                                }
                                                throw new IllegalArgumentException(optionValue);
                                            }
                                            this.startNestedTransaction(this.transactionChain.getLast(), autoCommit, readOnlyTransaction, transactionSymbolicName2);
                                            this.out.println(replyprompt);
                                            continue;
                                        }
                                        if (cmd.toUpperCase().startsWith("ENDTRANSACTION ") || cmd.equalsIgnoreCase("ENDTRANSACTION")) {
                                            if (serverVersionBeforeONE_TWO) continue;
                                            if (cmd.trim().length() > 15) {
                                                transactionSymbolicName = cmd.substring(15).trim().toUpperCase();
                                                if (!this.transactionsByName.containsKey(transactionSymbolicName)) {
                                                    throw new IllegalArgumentException(transactionSymbolicName);
                                                }
                                                DBTransaction endTransaction = this.transactionsByName.get(transactionSymbolicName);
                                                do {
                                                    transaction = this.transactionChain.removeLast();
                                                    transaction.end(true);
                                                } while (transaction != endTransaction);
                                            } else {
                                                DBTransaction transaction2 = this.transactionChain.removeLast();
                                                transaction2.end(true);
                                            }
                                            this.out.println(replyprompt);
                                            continue;
                                        }
                                        if (cmd.toUpperCase().startsWith("COMMIT ") || cmd.equalsIgnoreCase("COMMIT")) {
                                            if (!serverVersionBeforeONE_TWO) {
                                                if (cmd.trim().length() > 6) {
                                                    transactionSymbolicName = cmd.substring(6).trim().toUpperCase();
                                                    if (!this.transactionsByName.containsKey(transactionSymbolicName)) {
                                                        throw new IllegalArgumentException(transactionSymbolicName);
                                                    }
                                                    DBTransaction commitTransaction = this.transactionsByName.get(transactionSymbolicName);
                                                    do {
                                                        if ((transaction = this.transactionChain.getLast()) != commitTransaction) {
                                                            transaction.end(true);
                                                            this.transactionChain.removeLast();
                                                            continue;
                                                        }
                                                        transaction.commit();
                                                    } while (transaction != commitTransaction);
                                                } else {
                                                    this.transactionChain.getLast().commit();
                                                }
                                                this.out.println(replyprompt);
                                                continue;
                                            }
                                            if (cmd.trim().length() > 6) {
                                                throw new IllegalArgumentException(cmd);
                                            }
                                            try {
                                                AbstractRelation rsp = this.transactionChain.getLast().execDmlCommand(cmd);
                                                reply = rsp == null ? "" : rsp.printValueEscapedWithoutTypeNames();
                                            }
                                            catch (ErrorMessageException e) {
                                                reply = e.getMessage();
                                                this.transactionChain.clear();
                                                this.startTransaction(dbc, autoCommit, readOnlyTransaction, "", null);
                                            }
                                            this.out.println(String.valueOf(replyprompt) + reply);
                                            continue;
                                        }
                                        if (cmd.toUpperCase().startsWith("ROLLBACK ") || cmd.equalsIgnoreCase("ROLLBACK")) {
                                            if (!serverVersionBeforeONE_TWO) {
                                                if (cmd.trim().length() > 8) {
                                                    transactionSymbolicName = cmd.substring(8).trim().toUpperCase();
                                                    if (!this.transactionsByName.containsKey(transactionSymbolicName)) {
                                                        throw new IllegalArgumentException(transactionSymbolicName);
                                                    }
                                                    DBTransaction commitTransaction = this.transactionsByName.get(transactionSymbolicName);
                                                    do {
                                                        if ((transaction = this.transactionChain.getLast()) != commitTransaction) {
                                                            transaction.end(false);
                                                            this.transactionChain.removeLast();
                                                            continue;
                                                        }
                                                        transaction.rollback();
                                                    } while (transaction != commitTransaction);
                                                } else {
                                                    this.transactionChain.getLast().rollback();
                                                }
                                                this.out.println(replyprompt);
                                                continue;
                                            }
                                            if (cmd.trim().length() > 8) {
                                                throw new IllegalArgumentException(cmd);
                                            }
                                            try {
                                                AbstractRelation rsp = this.transactionChain.getLast().execDmlCommand(cmd);
                                                reply = rsp == null ? "" : rsp.printValueEscapedWithoutTypeNames();
                                            }
                                            catch (ErrorMessageException e) {
                                                reply = e.getMessage();
                                                this.transactionChain.clear();
                                                this.startTransaction(dbc, autoCommit, readOnlyTransaction, "", null);
                                            }
                                            this.out.println(String.valueOf(replyprompt) + reply);
                                            continue;
                                        }
                                        try {
                                            AbstractRelation rsp;
                                            if (this.transactionChain.size() == 0) {
                                                this.startTransaction(dbc, autoCommit, readOnlyTransaction, "", null);
                                            }
                                            reply = (rsp = this.transactionChain.getLast().execDmlCommand(cmd)) == null ? "" : rsp.printValueEscapedWithoutTypeNames();
                                        }
                                        catch (ErrorMessageException e) {
                                            reply = e.getMessage();
                                            if (!serverVersionBeforeONE_TWO) break block67;
                                            this.transactionChain.clear();
                                            this.startTransaction(dbc, autoCommit, readOnlyTransaction, "", null);
                                        }
                                    }
                                    this.out.println(String.valueOf(replyprompt) + reply);
                                    continue;
                                }
                                this.out.println();
                            }
                            catch (EOFException eOFException) {
                                proceed = false;
                            }
                        } while (proceed);
                        while (this.transactionChain.size() > 0) {
                            this.transactionChain.removeLast().end(true);
                        }
                        this.out.println("END");
                    }
                    finally {
                        ((DBConnection)dbc).close();
                    }
                }
                catch (Exception e) {
                    String formattedMessage = MyMessageFormat.format(Messages.getString("ProcessScript.Exception"), new String[]{e.getClass().getName(), e.getMessage()});
                    e.printStackTrace(this.out);
                    this.out.println(formattedMessage);
                    e.printStackTrace(System.err);
                    System.err.println(formattedMessage);
                    this.out.close();
                    try {
                        this.fin.close();
                    }
                    catch (IOException iOException) {}
                    break block69;
                }
            }
            catch (Throwable throwable) {
                this.out.close();
                try {
                    this.fin.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            this.out.close();
            try {
                this.fin.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public byte[] sign(Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
        signature.initSign(this.getPrivateKey(signature.getAlgorithm()));
        signature.update(signMessage);
        return signature.sign();
    }

    static class SetContent {
        private String host;
        private String port;
        private String user;

        public SetContent(String host, String port, String user) {
            this.host = host;
            this.port = port;
            this.user = user;
        }

        String getHost() {
            return this.host;
        }

        String getPort() {
            return this.port;
        }

        String getUser() {
            return this.user;
        }
    }
}

