/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.ProcessScript;
import be.SIRAPRISE.util.CommandLineParameters;
import be.SIRAPRISE.util.SiraPriseConjunctFileNameFilterSet;
import be.SIRAPRISE.util.SiraPriseRegexFilter;
import be.SIRAPRISE.util.SiraPriseSuffixFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

public class RunAllScripts {
    public static void main(String[] args) {
        try {
            File outputDirectory;
            File scriptsDirectory;
            CommandLineParameters commandLineParameters = CommandLineParameters.getCommandLineParameters(args, "SCRIPTSDIRECTORY", null);
            String scriptsDirectoryName = commandLineParameters.getProperty("SCRIPTSDIRECTORY");
            if (scriptsDirectoryName == null) {
                System.out.println(Messages.getString("RunAllScripts.DirectorynameRequired"));
                BufferedReader conin = new BufferedReader(new InputStreamReader(System.in));
                scriptsDirectoryName = conin.readLine();
            }
            if (!(scriptsDirectory = new File(scriptsDirectoryName)).isDirectory()) {
                throw new FileNotFoundException(String.valueOf(scriptsDirectoryName) + Messages.getString("RunAllScripts.NotADirectory"));
            }
            String fullScriptsDirectoryName = scriptsDirectory.getAbsolutePath();
            String outputDirectoryName = commandLineParameters.getProperty("OUTPUTDIRECTORY");
            if (outputDirectoryName == null) {
                System.out.println(Messages.getString("RunAllScripts.OutputDirectorynameRequired"));
                BufferedReader conin = new BufferedReader(new InputStreamReader(System.in));
                outputDirectoryName = conin.readLine();
            }
            if (!(outputDirectory = new File(outputDirectoryName)).exists()) {
                outputDirectory.mkdirs();
            } else if (!outputDirectory.isDirectory()) {
                throw new FileNotFoundException(String.valueOf(outputDirectoryName) + Messages.getString("RunAllScripts.NotADirectory"));
            }
            String fullOutputDirectoryName = outputDirectory.getAbsolutePath();
            TreeSet<String> scriptFileNames = new TreeSet<String>(Arrays.asList(scriptsDirectory.list(new SiraPriseConjunctFileNameFilterSet(Arrays.asList(new SiraPriseSuffixFilter(".SPS"), new SiraPriseRegexFilter(commandLineParameters.getProperty("SCRIPTS", ".*")))))));
            for (String scriptFileName : scriptFileNames) {
                String[] processScriptArgs = new String[commandLineParameters.size() + 2];
                int i = 1;
                for (Map.Entry<Object, Object> entry : commandLineParameters.entrySet()) {
                    processScriptArgs[i++] = String.valueOf((String)entry.getKey()) + '(' + (String)entry.getValue() + ')';
                }
                System.out.println(scriptFileName);
                processScriptArgs[0] = String.valueOf(fullScriptsDirectoryName) + File.separatorChar + scriptFileName;
                processScriptArgs[i] = "OUTFILE(" + fullOutputDirectoryName + File.separatorChar + scriptFileName + ".out.txt)";
                new ProcessScript(processScriptArgs).run();
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private RunAllScripts() {
        throw new RuntimeException();
    }
}

