/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.IllegalServerCommandException;
import be.SIRAPRISE.client.Messages;
import be.SIRAPRISE.client.ServerAddCommand;
import be.SIRAPRISE.client.ServerAssertCommand;
import be.SIRAPRISE.client.ServerDeleteCommand;
import be.SIRAPRISE.client.ServerInquireCommand;
import be.SIRAPRISE.client.ServerMultipleAssignmentCommand;
import be.SIRAPRISE.client.ServerSingleAssignmentCommand;
import be.SIRAPRISE.client.ServerUnassertCommand;
import be.SIRAPRISE.client.ServerUpdateCommand;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;
import be.SIRAPRISE.util.NameValuePair;
import be.SIRAPRISE.util.NameValueResult;
import be.SIRAPRISE.util.NoClosingBracketException;
import be.SIRAPRISE.util.NoOpeningBracketException;
import be.SIRAPRISE.util.RelationValueSelectorFactory;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class ServerCommand {
    private static final List<String> commandNames = Arrays.asList("ADD", "ASSERT", "DELETE", "UNASSERT", "UPDATE", "INQUIRE", "INSERT", "CREATE", "REMOVE", "MODIFY");

    private static ServerSingleAssignmentCommand getIndividualAssignmentCommandObjectFrom(String commandText) throws IllegalServerCommandException {
        ServerCommand serverCommand;
        try {
            serverCommand = ServerCommand.getCommandObjectFrom(commandText);
        }
        catch (NotFoundException e) {
            throw new IllegalServerCommandException(e);
        }
        if (!(serverCommand instanceof ServerSingleAssignmentCommand)) {
            throw new IllegalServerCommandException(Messages.getString("ServerCommand.IndividualAssignmentsOnly"));
        }
        return (ServerSingleAssignmentCommand)serverCommand;
    }

    public static ServerCommand getCommandObjectFor(String commandName, String commandContent) throws NotFoundException, IllegalServerCommandException {
        int x = commandNames.indexOf(commandName.toUpperCase());
        switch (x) {
            case 0: 
            case 6: 
            case 7: {
                int i1 = commandContent.indexOf(44);
                if (i1 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{commandContent}));
                }
                String targetRelvarName = commandContent.substring(0, i1).trim();
                String addRelation = commandContent.substring(i1 + 1).trim();
                if (addRelation.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{commandContent}));
                }
                return new ServerAddCommand(targetRelvarName, addRelation);
            }
            case 1: {
                int i1 = commandContent.indexOf(44);
                if (i1 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{commandContent}));
                }
                String targetRelvarName = commandContent.substring(0, i1).trim();
                String assertRelation = commandContent.substring(i1 + 1).trim();
                if (assertRelation.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{commandContent}));
                }
                return new ServerAssertCommand(targetRelvarName, assertRelation);
            }
            case 2: 
            case 8: {
                int i1 = commandContent.indexOf(44);
                if (i1 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{commandContent}));
                }
                String targetRelvarName = commandContent.substring(0, i1).trim();
                String deleteRelation = commandContent.substring(i1 + 1).trim();
                if (deleteRelation.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{commandContent}));
                }
                return new ServerDeleteCommand(targetRelvarName, deleteRelation);
            }
            case 3: {
                int i1 = commandContent.indexOf(44);
                if (i1 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{commandContent}));
                }
                String targetRelvarName = commandContent.substring(0, i1).trim();
                String unassertRelation = commandContent.substring(i1 + 1).trim();
                if (unassertRelation.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{commandContent}));
                }
                return new ServerUnassertCommand(targetRelvarName, unassertRelation);
            }
            case 4: 
            case 9: {
                String updates;
                String relationalExpression;
                int i1 = commandContent.indexOf(44);
                if (i1 < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relvarNameMissing"), new String[]{commandContent}));
                }
                String targetRelvarName = commandContent.substring(0, i1).trim();
                String deleteRelationAndUpdates = commandContent.substring(i1 + 1).trim();
                if (deleteRelationAndUpdates.length() < 1) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.relationalExpressionMissing"), new String[]{commandContent}));
                }
                int c1 = deleteRelationAndUpdates.indexOf(44);
                if (c1 == 0) {
                    deleteRelationAndUpdates = String.valueOf(targetRelvarName) + deleteRelationAndUpdates;
                    c1 = deleteRelationAndUpdates.indexOf(44);
                }
                int ob1 = deleteRelationAndUpdates.indexOf(40);
                if (c1 < 1 || c1 == deleteRelationAndUpdates.length() - 1 || ob1 < 0) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.scalarExpressionsMissing"), new String[]{deleteRelationAndUpdates}));
                }
                if (c1 < ob1) {
                    relationalExpression = deleteRelationAndUpdates.substring(0, c1).trim();
                    updates = deleteRelationAndUpdates.substring(c1 + 1).trim();
                } else {
                    try {
                        NameValueResult nvr = BracketParser.getNameAndMandatoryValueFromEscaped(deleteRelationAndUpdates, 0);
                        relationalExpression = deleteRelationAndUpdates.substring(0, nvr.getNextParsePos());
                        updates = deleteRelationAndUpdates.substring(nvr.getNextParsePos()).trim();
                        if (updates.length() < 1 || updates.charAt(0) != ',') {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.scalarExpressionsMissing"), new String[]{deleteRelationAndUpdates}));
                        }
                        updates = updates.substring(1).trim();
                    }
                    catch (NoOpeningBracketException noOpeningBracketException) {
                        throw new RuntimeException();
                    }
                    catch (NoClosingBracketException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{deleteRelationAndUpdates}), e);
                    }
                    catch (InvalidEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{deleteRelationAndUpdates}), e);
                    }
                    catch (MissingEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.syntaxError"), new String[]{deleteRelationAndUpdates}), e);
                    }
                }
                return new ServerUpdateCommand(targetRelvarName, relationalExpression, BracketParser.removeSuperfluousOuterBrackets(updates));
            }
            case 5: {
                LinkedList<String> orderByAttributeNames;
                String queryExpression;
                String commandParameters = commandContent;
                int cp = commandParameters.indexOf(44);
                String orderingAttributesList = "";
                if (cp < 0) {
                    return new ServerInquireCommand(commandContent);
                }
                int obp = commandParameters.indexOf(40);
                if (obp < 0) {
                    throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.MissingParenthesesAroundOrderingSpec"), new String[]{commandParameters.substring(cp + 1)}));
                }
                if (obp < cp) {
                    NameValueResult nvr;
                    try {
                        nvr = BracketParser.getNameAndMandatoryValueFromEscaped(commandParameters, 0);
                    }
                    catch (NoOpeningBracketException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{commandParameters}), e);
                    }
                    catch (NoClosingBracketException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{commandParameters}), e);
                    }
                    catch (InvalidEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{commandParameters}), e);
                    }
                    catch (MissingEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{commandParameters}), e);
                    }
                    queryExpression = commandParameters.substring(0, nvr.getNextParsePos()).trim();
                    String orderingSpec = commandParameters.substring(nvr.getNextParsePos()).trim();
                    if (orderingSpec.length() == 0) {
                        orderByAttributeNames = new LinkedList();
                    } else {
                        if (!orderingSpec.startsWith(",")) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.MissingCommaBeforeOrderingSpec"), new String[]{orderingSpec}));
                        }
                        try {
                            NameValuePair nameValuePair = BracketParser.getNameAndMandatoryValueFromEscaped(orderingSpec, 0).getNameValuePair();
                            orderingAttributesList = nameValuePair.getValue();
                            orderByAttributeNames = RelationValueSelectorFactory.getNamesInEntryOrder(orderingAttributesList.toUpperCase());
                        }
                        catch (NoOpeningBracketException e1) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e1);
                        }
                        catch (NoClosingBracketException e1) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e1);
                        }
                        catch (InvalidEscapedCharacterException e) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e);
                        }
                        catch (MissingEscapedCharacterException e) {
                            throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e);
                        }
                    }
                } else {
                    queryExpression = commandParameters.substring(0, cp);
                    String orderingSpec = commandParameters.substring(cp + 1);
                    try {
                        NameValuePair nameValuePair = BracketParser.getNameAndMandatoryValueFromEscaped(orderingSpec, 0).getNameValuePair();
                        orderingAttributesList = nameValuePair.getValue();
                        orderByAttributeNames = RelationValueSelectorFactory.getNamesInEntryOrder(orderingAttributesList.toUpperCase());
                    }
                    catch (NoOpeningBracketException e1) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e1);
                    }
                    catch (NoClosingBracketException e1) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e1);
                    }
                    catch (InvalidEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e);
                    }
                    catch (MissingEscapedCharacterException e) {
                        throw new IllegalServerCommandException(MyMessageFormat.format(Messages.getString("ServerCommand.SyntaxError"), new String[]{orderingSpec}), e);
                    }
                }
                return new ServerInquireCommand(queryExpression, orderByAttributeNames);
            }
        }
        throw new NotFoundException(MyMessageFormat.format(Messages.getString("ServerCommand.invalidCommand"), new String[]{commandNames.toString(), commandName}));
    }

    public static ServerCommand getCommandObjectFrom(String commandText) throws NotFoundException, IllegalServerCommandException {
        String commandContent;
        String commandName;
        if (commandText.length() > 2 && commandText.substring(0, 3).equalsIgnoreCase("CMD")) {
            LinkedList<String> commandList;
            try {
                commandList = BracketParser.createListFromEscaped(commandText);
            }
            catch (NoClosingBracketException e) {
                throw new IllegalServerCommandException(commandText, e);
            }
            catch (InvalidEscapedCharacterException e) {
                throw new IllegalServerCommandException(commandText, e);
            }
            catch (MissingEscapedCharacterException e) {
                throw new IllegalServerCommandException(commandText, e);
            }
            catch (NoOpeningBracketException e) {
                throw new IllegalServerCommandException(commandText, e);
            }
            int i = 0;
            ServerSingleAssignmentCommand[] serverAssignmentCommands = new ServerSingleAssignmentCommand[commandList.size()];
            for (String individualCommandText : commandList) {
                serverAssignmentCommands[i++] = ServerCommand.getIndividualAssignmentCommandObjectFrom(individualCommandText);
            }
            if (serverAssignmentCommands.length == 1) {
                return serverAssignmentCommands[0];
            }
            return new ServerMultipleAssignmentCommand(serverAssignmentCommands);
        }
        int bp = commandText.indexOf(32);
        if (bp < 0) {
            commandName = commandText;
            commandContent = "";
        } else {
            commandName = commandText.substring(0, bp).trim();
            commandContent = commandText.substring(bp + 1).trim();
        }
        return ServerCommand.getCommandObjectFor(commandName, commandContent);
    }

    public abstract String getFullCommandText();

    public abstract String getCommandParametersText();

    abstract int getCorrespondingMessagetypeid();

    public String toString() {
        return this.getFullCommandText();
    }
}

