/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client;

import be.SIRAPRISE.client.Messages;

public class Version
implements Comparable<Version> {
    public static final Version ONE_FOUR = new Version(1, 4);
    public static final Version ONE_ONE = new Version(1, 1);
    public static final Version ONE_THREE = new Version(1, 3);
    public static final Version ONE_TWO = new Version(1, 2);
    public static final Version ONE_ZERO = new Version(1, 0);
    private short majorVersion;
    private short minorVersion;

    public Version(int fullVersion) {
        this((short)(fullVersion >>> 16), (short)(fullVersion & 0xFFFF));
    }

    public Version(short majorVersion, short minorVersion) {
        if (majorVersion < 1 || minorVersion < 0) {
            throw new IllegalArgumentException(Messages.getString("Version.NegativeComponent"));
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Override
    public final int compareTo(Version o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.isBefore(o)) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version otherVersion = (Version)obj;
            return otherVersion.majorVersion == this.majorVersion && otherVersion.minorVersion == this.minorVersion;
        }
        return false;
    }

    public final int getFullVersion() {
        return this.majorVersion << 16 | this.minorVersion;
    }

    public final Version getLowest(Version otherVersion) {
        if (this.isBefore(otherVersion)) {
            return this;
        }
        return otherVersion;
    }

    public final short getMajorVersion() {
        return this.majorVersion;
    }

    public final short getMinorVersion() {
        return this.minorVersion;
    }

    public final int hashCode() {
        return this.getFullVersion();
    }

    public final boolean isAtLeast(short majorVersion2, short minorVersion2) {
        return this.majorVersion > majorVersion2 || this.majorVersion == majorVersion2 && this.minorVersion >= minorVersion2;
    }

    public final boolean isAtLeast(Version otherVersion) {
        return this.majorVersion > otherVersion.majorVersion || this.majorVersion == otherVersion.majorVersion && this.minorVersion >= otherVersion.minorVersion;
    }

    public final boolean isBefore(short majorVersion2, short minorVersion2) {
        return this.majorVersion < majorVersion2 || this.majorVersion == majorVersion2 && this.minorVersion < minorVersion2;
    }

    public final boolean isBefore(Version otherVersion) {
        return this.majorVersion < otherVersion.majorVersion || this.majorVersion == otherVersion.majorVersion && this.minorVersion < otherVersion.minorVersion;
    }

    public final String toString() {
        return String.valueOf(Integer.toString(this.majorVersion)) + '.' + Integer.toString(this.minorVersion);
    }
}

