/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.GetterMethod;
import be.SIRAPRISE.client.jsba.JSBAMethodInvoker;
import be.SIRAPRISE.util.BracketParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class AnnotatedMethodInvoker
extends JSBAMethodInvoker {
    StringProducerFromNative stringProducer;
    boolean escapingWrapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AnnotatedMethodInvoker(Method method, GetterMethod jsbaGetterMethodAnnotation, int relvarNameIndexInAnnotation) {
        Class<?> methodReturnType = method.getReturnType();
        if (methodReturnType.isPrimitive()) {
            if (methodReturnType == Byte.TYPE) {
                this.stringProducer = new StringProducerFromByte(method);
            } else if (methodReturnType == Character.TYPE) {
                this.stringProducer = new StringProducerFromChar(method);
            } else if (methodReturnType == Short.TYPE) {
                this.stringProducer = new StringProducerFromShort(method);
            } else if (methodReturnType == Integer.TYPE) {
                this.stringProducer = new StringProducerFromInt(method);
            } else if (methodReturnType == Long.TYPE) {
                this.stringProducer = new StringProducerFromLong(method);
            } else if (methodReturnType == Float.TYPE) {
                this.stringProducer = new StringProducerFromFloat(method);
            } else {
                if (methodReturnType != Double.TYPE) throw new IllegalArgumentException(methodReturnType.getName());
                this.stringProducer = new StringProducerFromDouble(method);
            }
        } else {
            this.stringProducer = methodReturnType == String.class ? new StringProducerFromString(method) : new StringProducerFromObject(method);
        }
        boolean[] requiresEscaping = jsbaGetterMethodAnnotation.requiresEscaping();
        this.escapingWrapper = requiresEscaping.length == 1 ? requiresEscaping[0] : requiresEscaping[relvarNameIndexInAnnotation];
    }

    @Override
    public String invoke(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String s = this.stringProducer.produce(o, objects);
        return this.escapingWrapper ? BracketParser.meta(s) : s;
    }

    static final class StringProducerFromByte
    extends StringProducerFromNative {
        StringProducerFromByte(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Byte)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromChar
    extends StringProducerFromNative {
        StringProducerFromChar(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Character)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromDouble
    extends StringProducerFromNative {
        StringProducerFromDouble(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Double)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromFloat
    extends StringProducerFromNative {
        StringProducerFromFloat(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Float)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromInt
    extends StringProducerFromNative {
        StringProducerFromInt(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Integer)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromLong
    extends StringProducerFromNative {
        StringProducerFromLong(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Long)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static abstract class StringProducerFromNative {
        private Method method;

        StringProducerFromNative(Method method) {
            this.method = method;
        }

        final Method getMethod() {
            return this.method;
        }

        abstract String produce(Object var1, Object[] var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;
    }

    static final class StringProducerFromObject
    extends StringProducerFromNative {
        StringProducerFromObject(Method method) {
            super(method);
        }

        @Override
        public String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.getMethod().invoke(o, objects).toString();
        }
    }

    static final class StringProducerFromShort
    extends StringProducerFromNative {
        StringProducerFromShort(Method method) {
            super(method);
        }

        @Override
        String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return ((Short)this.getMethod().invoke(o, objects)).toString();
        }
    }

    static final class StringProducerFromString
    extends StringProducerFromNative {
        StringProducerFromString(Method method) {
            super(method);
        }

        @Override
        public String produce(Object o, Object[] objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (String)this.getMethod().invoke(o, objects);
        }
    }
}

