/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.AbstractTupleContainer;
import be.SIRAPRISE.client.ConstructorMissingException;
import be.SIRAPRISE.client.Heading;
import be.SIRAPRISE.client.NonScalarTypeDeclaration;
import be.SIRAPRISE.client.Relation;
import be.SIRAPRISE.client.SettersMissingException;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.TypeDeclaration;
import be.SIRAPRISE.client.jsba.ClassDoesNotImplementDBObjectException;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.RelationSetterMethod;
import be.SIRAPRISE.client.jsba.SetterMethod;
import be.SIRAPRISE.client.jsba.StringSetterMethod;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class DBObjectFactory {
    private static boolean classImplements(Class<?> objectClass, Class<?> interfaceClass) {
        Class<?>[] interfaces = objectClass.getInterfaces();
        int interfacesCount = interfaces.length;
        int i = 0;
        while (i < interfacesCount) {
            if (interfaces[i] == interfaceClass || DBObjectFactory.classImplements(interfaces[i], interfaceClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <C> C getObject(Tuple tuple, Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException, SettersMissingException {
        DBObjectFactory.getPublicNoArgConstructor(objectClass);
        Heading heading = tuple.getHeading();
        Set attributeNames = heading.keySet();
        HashMap<String, SetterMethod> setterMethods = DBObjectFactory.getSetterMethods(objectClass, heading);
        if (setterMethods.size() != attributeNames.size()) {
            ArrayList missingSetters = new ArrayList();
            missingSetters.addAll(attributeNames);
            missingSetters.removeAll(setterMethods.keySet());
            throw new SettersMissingException(String.valueOf(missingSetters.toString()) + '/' + objectClass.getName());
        }
        return DBObjectFactory.getObject(tuple, objectClass, setterMethods);
    }

    public static <C> C[] getObjectArray(AbstractTupleContainer c, Class<C> objectClass) throws SettersMissingException, ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return c.toObjectCollection(objectClass).toArray();
    }

    public static <C> C[] getObjectArrayIgnoringMissingSetters(AbstractTupleContainer c, Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        return c.toObjectCollectionIgnoringMissingSetters(objectClass).toArray();
    }

    public static final <C> C getObjectIgnoringMissingSetters(Tuple tuple, Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        DBObjectFactory.getPublicNoArgConstructor(objectClass);
        return DBObjectFactory.getObject(tuple, objectClass, DBObjectFactory.getSetterMethods(objectClass, tuple.getHeading()));
    }

    public static Map<Class<?>, Object> getObjects(Tuple tuple, Class<?>[] objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException, SettersMissingException {
        Heading heading = tuple.getHeading();
        Set attributeNames = heading.keySet();
        HashSet unmatchedAttributeNames = new HashSet();
        unmatchedAttributeNames.addAll(attributeNames);
        HashMap processingMap = new HashMap();
        int i = 0;
        while (i < objectClass.length) {
            DBObjectFactory.getPublicNoArgConstructor(objectClass[i]);
            HashMap<String, SetterMethod> setterMethods = DBObjectFactory.getSetterMethods(objectClass[i], heading);
            processingMap.put(objectClass[i], setterMethods);
            unmatchedAttributeNames.removeAll(processingMap.keySet());
            ++i;
        }
        if (unmatchedAttributeNames.size() > 0) {
            throw new SettersMissingException(unmatchedAttributeNames.toString());
        }
        return DBObjectFactory.toObjects(tuple, processingMap);
    }

    public static Constructor<?> getPublicNoArgConstructor(Class<?> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        try {
            Constructor<?> noargConstructor = objectClass.getConstructor(new Class[0]);
            int objectClassModifiers = objectClass.getModifiers();
            if (Modifier.isAbstract(objectClassModifiers) || !Modifier.isPublic(noargConstructor.getModifiers()) || !Modifier.isPublic(objectClass.getModifiers())) {
                throw new ConstructorMissingException();
            }
            if (DBObjectFactory.classImplements(objectClass, DBObject.class)) {
                return noargConstructor;
            }
            throw new ClassDoesNotImplementDBObjectException(objectClass);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructorMissingException(e);
        }
    }

    public static Constructor<?> getPublicTupleConstructor(Class<?> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException {
        int objectClassModifiers = objectClass.getModifiers();
        if (Modifier.isAbstract(objectClassModifiers) || !Modifier.isPublic(objectClass.getModifiers())) {
            throw new ConstructorMissingException();
        }
        if (!DBObjectFactory.classImplements(objectClass, DBObject.class)) {
            throw new ClassDoesNotImplementDBObjectException(objectClass);
        }
        Constructor<?>[] tupleConstructors = objectClass.getConstructors();
        int i = 0;
        while (i < tupleConstructors.length) {
            Constructor<?> tupleConstructor = tupleConstructors[i];
            Class<?>[] tupleConstructorParameterTypes = tupleConstructor.getParameterTypes();
            if (!tupleConstructor.isVarArgs() && tupleConstructorParameterTypes.length == 1 && DBObjectFactory.classImplements(tupleConstructorParameterTypes[0], Tuple.class)) {
                return tupleConstructor;
            }
            ++i;
        }
        throw new ConstructorMissingException();
    }

    public static HashMap<String, SetterMethod> getSetterMethods(Class<?> objectClass, Heading heading) {
        HashMap<String, SetterMethod> setterMethods = new HashMap<String, SetterMethod>();
        for (Map.Entry me : heading.entrySet()) {
            String attributeName = (String)me.getKey();
            String setterMethodName = "set" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1).toLowerCase() + "FromDB";
            TypeDeclaration typeDeclaration = (TypeDeclaration)me.getValue();
            boolean searchStringSetter = true;
            if (typeDeclaration instanceof NonScalarTypeDeclaration) {
                try {
                    Method relationSetterMethod = objectClass.getMethod(setterMethodName, Relation.class);
                    setterMethods.put(attributeName, new RelationSetterMethod(relationSetterMethod));
                    searchStringSetter = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (!searchStringSetter) continue;
            try {
                Method stringSetterMethod = objectClass.getMethod(setterMethodName, String.class);
                setterMethods.put(attributeName, new StringSetterMethod(stringSetterMethod));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return setterMethods;
    }

    public static final <C> C getObject(Tuple tuple, Class<C> objectClass, HashMap<String, SetterMethod> setterMethods) {
        try {
            C object = objectClass.newInstance();
            for (Map.Entry<String, SetterMethod> me : setterMethods.entrySet()) {
                String attributeName = me.getKey();
                SetterMethod jsbaSetterMethod = me.getValue();
                Method setterMethod = jsbaSetterMethod.getMethod();
                try {
                    if (jsbaSetterMethod instanceof RelationSetterMethod) {
                        setterMethod.invoke(object, tuple.rvaValue(attributeName));
                        continue;
                    }
                    setterMethod.invoke(object, tuple.value(attributeName));
                }
                catch (IllegalAccessException e2) {
                    throw new RuntimeException(e2);
                }
                catch (InvocationTargetException e2) {
                    throw new RuntimeException(e2);
                }
            }
            if (object instanceof UpdatableDBObject) {
                ((UpdatableDBObject)object).setPreUpdateState();
            }
            return object;
        }
        catch (InstantiationException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static final Map<Class<?>, Object> toObjects(Tuple tuple, Map<Class<?>, HashMap<String, SetterMethod>> classesProcessingMap) {
        HashMap map = new HashMap();
        for (Map.Entry<Class<?>, HashMap<String, SetterMethod>> me : classesProcessingMap.entrySet()) {
            Class<?> objectClass = me.getKey();
            map.put(objectClass, DBObjectFactory.getObject(tuple, objectClass, me.getValue()));
        }
        return map;
    }

    private DBObjectFactory() {
    }

    public static <C> Collection<C> getObjectCollection(AbstractTupleContainer tupleContainer, Class<C> objectClass) throws ConstructorMissingException, ClassDoesNotImplementDBObjectException, SettersMissingException {
        Heading heading = tupleContainer.getHeading();
        DBObjectFactory.getPublicNoArgConstructor(objectClass);
        HashMap<String, SetterMethod> setterMethods = DBObjectFactory.getSetterMethods(objectClass, heading);
        Set attributeNames = heading.keySet();
        if (setterMethods.size() != attributeNames.size()) {
            ArrayList missingSetters = new ArrayList();
            missingSetters.addAll(attributeNames);
            missingSetters.removeAll(setterMethods.keySet());
            throw new SettersMissingException(String.valueOf(missingSetters.toString()) + '/' + objectClass.getName());
        }
        ArrayList<C> objects = new ArrayList<C>();
        for (Tuple tuple : tupleContainer) {
            objects.add(DBObjectFactory.getObject(tuple, objectClass, setterMethods));
        }
        return objects;
    }
}

