/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.ConnectionClosedException;
import be.SIRAPRISE.client.DBConnection;
import be.SIRAPRISE.client.DBConnectionProperties;
import be.SIRAPRISE.client.DBException;
import be.SIRAPRISE.client.DBTransaction;
import be.SIRAPRISE.client.ErrorMessageException;
import be.SIRAPRISE.client.OneShotDBConnection;
import be.SIRAPRISE.client.Signer;
import be.SIRAPRISE.client.Tuple;
import be.SIRAPRISE.client.jsba.DBObject;
import be.SIRAPRISE.client.jsba.DBObjectInterfaceGeneratorProperties;
import be.SIRAPRISE.client.jsba.Messages;
import be.SIRAPRISE.util.CommandLineParameters;
import be.SIRAPRISE.util.MyKeyStore;
import be.SIRAPRISE.util.UserPrivateKeyProvider;
import be.erwinsmout.MyMessageFormat;
import be.erwinsmout.NotFoundException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Set;

public class DBObjectInterfaceGenerator
implements Signer {
    public static final String RELVAR = "RELVAR";
    private String canonicalizedRelvarName;
    private final String clientName = "DBOBJECTINTERFACEGENERATOR";
    private Set<String> cryptoAlgorithmNames;
    private String host;
    private String interfaceName1;
    private String interfaceName2;
    private String lowercaseRelvarName;
    private PrintWriter out1;
    private PrintWriter out2;
    private String packageDirectoryName;
    private String packageName;
    private int port;
    private String relvarName;
    private Set<String> signingAlgorithmNames;
    private String user;

    public static void main(String[] args) throws IOException {
        new DBObjectInterfaceGenerator(args).run();
    }

    DBObjectInterfaceGenerator(String[] args) throws IOException {
        CommandLineParameters commandLineParameters = CommandLineParameters.getCommandLineParameters(args, RELVAR, DBObjectInterfaceGeneratorProperties.getInstance());
        this.relvarName = commandLineParameters.getProperty(RELVAR);
        if (this.relvarName == null) {
            BufferedReader conin = new BufferedReader(new InputStreamReader(System.in));
            this.relvarName = conin.readLine();
        }
        this.canonicalizedRelvarName = this.canonicalizeName(this.relvarName);
        this.lowercaseRelvarName = this.relvarName.toLowerCase();
        this.user = commandLineParameters.getProperty("USER", "");
        this.host = commandLineParameters.getProperty("HOST", "127.0.0.1");
        this.port = Integer.parseInt(commandLineParameters.getProperty("PORT", "50000"));
        String outputDirectoryName = commandLineParameters.getProperty("OUTPUTDIRECTORY", ".");
        this.packageName = commandLineParameters.getProperty("PACKAGE", "");
        this.packageDirectoryName = String.valueOf(outputDirectoryName) + (outputDirectoryName.endsWith(File.separator) ? "" : File.separator) + this.packageName.replace('.', File.separatorChar) + File.separatorChar;
        this.interfaceName1 = "DBObjectTo" + this.canonicalizedRelvarName;
        this.out1 = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.packageDirectoryName) + this.interfaceName1 + ".java")));
        this.interfaceName2 = String.valueOf(this.canonicalizedRelvarName) + "ToDBObject";
        this.out2 = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.packageDirectoryName) + this.interfaceName2 + ".java")));
        String signingAlgorithmNameList = commandLineParameters.getProperty("SIGNINGALGORITHMS", "");
        this.signingAlgorithmNames = DBConnectionProperties.getSigningAlgorithmNameSet(signingAlgorithmNameList);
        String cryptoAlgorithmNameList = commandLineParameters.getProperty("CRYPTOALGORITHMS", "");
        this.cryptoAlgorithmNames = DBConnectionProperties.getCryptoAlgorithmNameSet(cryptoAlgorithmNameList);
    }

    private String canonicalizeName(String name) {
        return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1).toLowerCase();
    }

    private PrivateKey getPrivateKey(String algorithm) throws NotFoundException {
        try {
            KeyStore jks = MyKeyStore.getKeyStore(this.getClass());
            return (PrivateKey)jks.getKey("DBOBJECTINTERFACEGENERATOR" + algorithm, this.getClass().getSimpleName().toCharArray());
        }
        catch (KeyStoreException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (CertificateException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (IOException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
        catch (UnrecoverableKeyException e) {
            throw new NotFoundException(String.valueOf(e.getClass().getName()) + e.getMessage() != null ? e.getMessage() : "");
        }
    }

    private DBTransaction startTransaction(DBConnection dbc) throws DBException, ConnectionClosedException, ErrorMessageException {
        if (this.user.length() > 0) {
            try {
                UserPrivateKeyProvider userPrivateKeyProvider = new UserPrivateKeyProvider(this.user);
                return dbc.startTransaction(this.user, userPrivateKeyProvider);
            }
            catch (NotFoundException notFoundException) {
                this.out1.println(MyMessageFormat.format(Messages.getString("DBObjectInterfaceGenerator.UserNotAuthenticable"), new String[]{this.user}));
                return dbc.startTransaction();
            }
        }
        return dbc.startTransaction();
    }

    void run() {
        this.out1.println("/*\r\n * Created on 16-jan-2009\r\n */\r\npackage " + this.packageName + ";\r\n\r\nimport " + DBObject.class.getName() + ";\r\n\r\n/**\r\n * @author " + "DBOBJECTINTERFACEGENERATOR" + "\r\n */\r\npublic interface " + this.interfaceName1 + " extends DBObject {\r\n\r\n");
        this.out2.println("/*\r\n * Created on 16-jan-2009\r\n */\r\npackage " + this.packageName + ";\r\n\r\nimport " + DBObject.class.getName() + ";\r\n\r\n/**\r\n * @author " + "DBOBJECTINTERFACEGENERATOR" + "\r\n */\r\npublic interface " + this.interfaceName2 + " extends DBObject {\r\n\r\n");
        try {
            try {
                OneShotDBConnection dbc = new OneShotDBConnection(this.host, this.port, this.signingAlgorithmNames, "DBOBJECTINTERFACEGENERATOR", this.cryptoAlgorithmNames, (Signer)this);
                try {
                    Tuple metaInfoTuple = this.startTransaction(dbc).execDmlCommandAndEndTransaction("INQUIRE EXPRESSIONINFO(STRING(" + this.relvarName + "))").iterator().next();
                    AbstractRelation attributesRelation = metaInfoTuple.rvaValue("NONSCALARHEADING");
                    for (Tuple tuple : attributesRelation) {
                        String attributeName = tuple.value("ATTRIBUTENAME");
                        String canonicalAttributeNameForMethods = this.canonicalizeName(attributeName);
                        String lowercaseAttributeName = attributeName.toLowerCase();
                        this.out1.println("\t/**\r\n\t * Gets the " + lowercaseAttributeName + " for " + this.lowercaseRelvarName + "\r\n\t * \r\n\t * @return The " + lowercaseAttributeName + " for " + this.lowercaseRelvarName + "\r\n\t */\r\n\tpublic String get" + this.canonicalizedRelvarName + canonicalAttributeNameForMethods + "();\r\n\r\n");
                        this.out2.println("\t/**\r\n\t * Sets " + lowercaseAttributeName + " from the DB\r\n\t * \r\n\t * @param " + lowercaseAttributeName + " The DB value for " + lowercaseAttributeName + "\r\n\t */\r\n\tpublic void set" + canonicalAttributeNameForMethods + "FromDB(String " + lowercaseAttributeName + ");\r\n\r\n");
                    }
                }
                finally {
                    ((DBConnection)dbc).close();
                }
                this.out1.println("\r\n}\r\n");
                this.out2.println("\r\n}\r\n");
            }
            catch (Exception e) {
                String formattedMessage = MyMessageFormat.format(Messages.getString("DBObjectInterfaceGenerator.Exception"), new String[]{e.getClass().getName(), e.getMessage()});
                e.printStackTrace(this.out1);
                this.out1.println(formattedMessage);
                e.printStackTrace(System.err);
                System.err.println(formattedMessage);
                this.out1.close();
                this.out2.close();
            }
        }
        finally {
            this.out1.close();
            this.out2.close();
        }
    }

    @Override
    public byte[] sign(Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
        signature.initSign(this.getPrivateKey(signature.getAlgorithm()));
        signature.update(signMessage);
        return signature.sign();
    }
}

