/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToDataspace;
import be.SIRAPRISE.client.jsba.DBObjectToStoragespace;
import be.SIRAPRISE.client.jsba.DataspaceToDBObject;
import be.SIRAPRISE.client.jsba.ForRelvars;
import be.SIRAPRISE.client.jsba.StoragespaceToDBObject;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

@ForRelvars(relvarNames={"DataSpace", "StorageSpace"})
public final class DataSpace
extends AbstractUpdatableDBObject
implements DBObjectToDataspace,
DBObjectToStoragespace,
DataspaceToDBObject,
StoragespaceToDBObject {
    private int extentsCount;
    private String fileName;
    private int gapCompressionThreshold;
    private int maximumGaps;
    private int pageCount;
    private DataSpace preUpdateState;
    private int storageSpaceID;

    public DataSpace() {
    }

    public DataSpace(String fileName, int storageSpaceID, int pageCount, int gapCompressionThreshold, int maximumGaps) {
        this.fileName = fileName.toUpperCase();
        this.storageSpaceID = storageSpaceID;
        this.pageCount = pageCount;
        this.gapCompressionThreshold = gapCompressionThreshold;
        this.maximumGaps = maximumGaps;
    }

    public DataSpace(String fileName, int storageSpaceID, int pageCount, int gapCompressionThreshold, int maximumGaps, int extentsCount) {
        this(fileName, storageSpaceID, pageCount, gapCompressionThreshold, maximumGaps);
        this.extentsCount = extentsCount;
    }

    @Override
    public final String getDataspaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    @Override
    public final String getDataspaceGapcompressionthreshold() {
        return Integer.toString(this.gapCompressionThreshold);
    }

    @Override
    public final String getDataspaceMaximumgaps() {
        return Integer.toString(this.maximumGaps);
    }

    @Override
    public final String getDataspaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    public final int getExtentsCount() {
        return this.extentsCount;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getGapCompressionThreshold() {
        return this.gapCompressionThreshold;
    }

    public final int getMaximumGaps() {
        return this.maximumGaps;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    @Override
    public final UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    @Override
    public String getStoragespaceExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    public final String getStoragespaceextentsExtentscount() {
        return Integer.toString(this.extentsCount);
    }

    public final String getStoragespaceextentsFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final String getStoragespaceextentsStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    @Override
    public final String getStoragespaceFilename() {
        return BracketParser.meta(this.fileName);
    }

    public final int getStorageSpaceID() {
        return this.storageSpaceID;
    }

    @Override
    public final String getStoragespacePagecount() {
        return Integer.toString(this.pageCount);
    }

    @Override
    public final String getStoragespaceStoragespaceid() {
        return Integer.toString(this.storageSpaceID);
    }

    public final void setExtentsCount(int extentsCount) {
        this.extentsCount = extentsCount;
    }

    @Override
    public final void setExtentscountFromDB(String extentsCount) {
        this.extentsCount = Integer.parseInt(extentsCount);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName.toUpperCase();
    }

    @Override
    public final void setFilenameFromDB(String fileName) {
        try {
            this.fileName = BracketParser.unMeta(fileName).toUpperCase();
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setGapCompressionThreshold(int gapCompressionThreshold) {
        this.gapCompressionThreshold = gapCompressionThreshold;
    }

    @Override
    public final void setGapcompressionthresholdFromDB(String gapCompressionThreshold) {
        this.gapCompressionThreshold = Integer.parseInt(gapCompressionThreshold);
    }

    public final void setMaximumGaps(int maximumGaps) {
        this.maximumGaps = maximumGaps;
    }

    @Override
    public final void setMaximumgapsFromDB(String maximumGaps) {
        this.maximumGaps = Integer.parseInt(maximumGaps);
    }

    public final void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    @Override
    public final void setPagecountFromDB(String pageCount) {
        this.pageCount = Integer.parseInt(pageCount);
    }

    @Override
    public final void setPreUpdateState() {
        this.preUpdateState = new DataSpace(this.fileName, this.storageSpaceID, this.pageCount, this.gapCompressionThreshold, this.maximumGaps, this.extentsCount);
    }

    public final void setStorageSpaceID(int storageSpaceID) {
        this.storageSpaceID = storageSpaceID;
    }

    @Override
    public final void setStoragespaceidFromDB(String storageSpaceID) {
        this.storageSpaceID = Integer.parseInt(storageSpaceID);
    }
}

