/*
 * Decompiled with CFR 0.152.
 */
package be.SIRAPRISE.client.jsba;

import be.SIRAPRISE.client.jsba.AbstractUpdatableDBObject;
import be.SIRAPRISE.client.jsba.DBObjectToDbmsfile;
import be.SIRAPRISE.client.jsba.DbmsfileToDBObject;
import be.SIRAPRISE.client.jsba.ForRelvars;
import be.SIRAPRISE.client.jsba.UpdatableDBObject;
import be.SIRAPRISE.util.BracketParser;
import be.SIRAPRISE.util.InvalidEscapedCharacterException;
import be.SIRAPRISE.util.MissingEscapedCharacterException;

@ForRelvars(relvarNames={"DbmsFile"})
public final class DbmsFile
extends AbstractUpdatableDBObject
implements DBObjectToDbmsfile,
DbmsfileToDBObject {
    private String fileName;
    private int pageSize;
    private DbmsFile preUpdateState;

    public DbmsFile() {
    }

    public DbmsFile(String fileName, int pageSize) {
        this.fileName = fileName.toUpperCase();
        this.pageSize = pageSize;
    }

    @Override
    public final String getDbmsfileFilename() {
        return BracketParser.meta(this.fileName);
    }

    @Override
    public final String getDbmsfilePagesize() {
        return Integer.toString(this.pageSize);
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Override
    public final UpdatableDBObject getPreUpdateState() {
        return this.preUpdateState;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName.toUpperCase();
    }

    @Override
    public final void setFilenameFromDB(String fileName) {
        try {
            this.fileName = BracketParser.unMeta(fileName).toUpperCase();
        }
        catch (InvalidEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
        catch (MissingEscapedCharacterException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public final void setPagesizeFromDB(String pageSize) {
        this.pageSize = Integer.parseInt(pageSize);
    }

    @Override
    public final void setPreUpdateState() {
        this.preUpdateState = new DbmsFile(this.fileName, this.pageSize);
    }
}

